/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentUnmarshaller;
import org.eclipse.persistence.oxm.record.ContentHandlerRecord;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.NodeRecord;
import org.eclipse.persistence.oxm.record.WriterRecord;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.SDOXMLDocument;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDOMarshalListener;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOUnmappedContentHandler;
import org.eclipse.persistence.sdo.helper.SDOUnmarshalListener;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.types.SDOPropertyType;
import org.eclipse.persistence.sdo.types.SDOTypeType;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.xml.sax.InputSource;

public class SDOXMLHelperDelegate
implements SDOXMLHelper {
    private SDOClassLoader loader;
    private XMLContext xmlContext;
    private Map<Thread, XMLMarshaller> xmlMarshallerMap;
    private Map<Thread, XMLUnmarshaller> xmlUnmarshallerMap;
    private Project topLinkProject;
    private HelperContext aHelperContext;

    public SDOXMLHelperDelegate(HelperContext aContext) {
        this(aContext, Thread.currentThread().getContextClassLoader());
    }

    public SDOXMLHelperDelegate(HelperContext aContext, ClassLoader aClassLoader) {
        this.aHelperContext = aContext;
        this.loader = new SDOClassLoader(aClassLoader, aContext);
        this.xmlMarshallerMap = new WeakHashMap<Thread, XMLMarshaller>();
        this.xmlUnmarshallerMap = new WeakHashMap<Thread, XMLUnmarshaller>();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.getXmlConversionManager().setTimeZone(timeZone);
    }

    public void setTimeZoneQualified(boolean timeZoneQualified) {
        this.getXmlConversionManager().setTimeZoneQualified(timeZoneQualified);
    }

    public XMLDocument load(String inputString) {
        StringReader reader = new StringReader(inputString);
        try {
            return this.load(reader, null, null);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return null;
        }
    }

    public XMLDocument load(InputStream inputStream) throws IOException {
        return this.load(inputStream, null, null);
    }

    public XMLDocument load(InputStream inputStream, String locationURI, Object options) throws IOException {
        InputSource inputSource = new InputSource(inputStream);
        return this.load(inputSource, locationURI, options);
    }

    public XMLDocument load(InputSource inputSource, String locationURI, Object options) throws IOException {
        Object unmarshalledObject;
        block17: {
            XMLUnmarshaller anXMLUnmarshaller = this.getXmlUnmarshaller(options);
            unmarshalledObject = null;
            if (options == null) {
                try {
                    unmarshalledObject = anXMLUnmarshaller.unmarshal(inputSource);
                }
                catch (XMLMarshalException xmlException) {
                    this.handleXMLMarshalException(xmlException);
                }
            } else {
                try {
                    DataObject optionsDataObject = (DataObject)options;
                    try {
                        SDOType theType = (SDOType)optionsDataObject.get("type");
                        try {
                            if (theType != null) {
                                unmarshalledObject = anXMLUnmarshaller.unmarshal(inputSource, theType.getImplClass());
                                break block17;
                            }
                            unmarshalledObject = anXMLUnmarshaller.unmarshal(inputSource);
                        }
                        catch (XMLMarshalException xmlException) {
                            this.handleXMLMarshalException(xmlException);
                        }
                    }
                    catch (ClassCastException ccException) {
                        throw SDOException.typePropertyMustBeAType((Exception)ccException);
                    }
                }
                catch (ClassCastException ccException) {
                    throw SDOException.optionsMustBeADataObject((Exception)ccException, (String)"org.eclipse.persistence.sdo", (String)"LoadOptions");
                }
            }
        }
        if (unmarshalledObject instanceof XMLRoot) {
            XMLRoot xmlRoot = (XMLRoot)unmarshalledObject;
            XMLDocument xmlDocument = this.createDocument((DataObject)((XMLRoot)unmarshalledObject).getObject(), ((XMLRoot)unmarshalledObject).getNamespaceURI(), ((XMLRoot)unmarshalledObject).getLocalName());
            if (xmlRoot.getEncoding() != null) {
                xmlDocument.setEncoding(xmlRoot.getEncoding());
            }
            if (xmlRoot.getXMLVersion() != null) {
                xmlDocument.setXMLVersion(xmlRoot.getXMLVersion());
            }
            xmlDocument.setSchemaLocation(xmlRoot.getSchemaLocation());
            xmlDocument.setNoNamespaceSchemaLocation(xmlRoot.getNoNamespaceSchemaLocation());
            return xmlDocument;
        }
        if (unmarshalledObject instanceof DataObject) {
            String localName = ((SDOType)((DataObject)unmarshalledObject).getType()).getXmlDescriptor().getDefaultRootElement();
            if (localName == null) {
                localName = ((SDOType)((DataObject)unmarshalledObject).getType()).getXsdLocalName();
            }
            return this.createDocument((DataObject)unmarshalledObject, ((DataObject)unmarshalledObject).getType().getURI(), localName);
        }
        if (unmarshalledObject instanceof XMLDocument) {
            return (XMLDocument)unmarshalledObject;
        }
        return null;
    }

    public XMLDocument load(Reader inputReader, String locationURI, Object options) throws IOException {
        InputSource inputSource = new InputSource(inputReader);
        return this.load(inputSource, locationURI, options);
    }

    public XMLDocument load(Source source, String locationURI, Object options) throws IOException {
        Object unmarshalledObject;
        block17: {
            XMLUnmarshaller anXMLUnmarshaller = this.getXmlUnmarshaller(options);
            unmarshalledObject = null;
            if (options == null) {
                try {
                    unmarshalledObject = anXMLUnmarshaller.unmarshal(source);
                }
                catch (XMLMarshalException xmlException) {
                    this.handleXMLMarshalException(xmlException);
                }
            } else {
                try {
                    DataObject optionsDataObject = (DataObject)options;
                    try {
                        SDOType theType = (SDOType)optionsDataObject.get("type");
                        try {
                            if (theType != null) {
                                unmarshalledObject = anXMLUnmarshaller.unmarshal(source, theType.getImplClass());
                                break block17;
                            }
                            unmarshalledObject = anXMLUnmarshaller.unmarshal(source);
                        }
                        catch (XMLMarshalException xmlException) {
                            this.handleXMLMarshalException(xmlException);
                        }
                    }
                    catch (ClassCastException ccException) {
                        throw SDOException.typePropertyMustBeAType((Exception)ccException);
                    }
                }
                catch (ClassCastException ccException) {
                    throw SDOException.optionsMustBeADataObject((Exception)ccException, (String)"org.eclipse.persistence.sdo", (String)"LoadOptions");
                }
            }
        }
        if (unmarshalledObject instanceof XMLRoot) {
            XMLRoot xmlRoot = (XMLRoot)unmarshalledObject;
            XMLDocument xmlDocument = this.createDocument((DataObject)((XMLRoot)unmarshalledObject).getObject(), ((XMLRoot)unmarshalledObject).getNamespaceURI(), ((XMLRoot)unmarshalledObject).getLocalName());
            if (xmlRoot.getEncoding() != null) {
                xmlDocument.setEncoding(xmlRoot.getEncoding());
            }
            if (xmlRoot.getXMLVersion() != null) {
                xmlDocument.setXMLVersion(xmlRoot.getXMLVersion());
            }
            xmlDocument.setSchemaLocation(xmlRoot.getSchemaLocation());
            xmlDocument.setNoNamespaceSchemaLocation(xmlRoot.getNoNamespaceSchemaLocation());
            return xmlDocument;
        }
        if (unmarshalledObject instanceof DataObject) {
            DataObject unmarshalledDataObject = (DataObject)unmarshalledObject;
            String localName = ((SDOType)((DataObject)unmarshalledObject).getType()).getXmlDescriptor().getDefaultRootElement();
            if (localName == null) {
                localName = ((SDOType)((DataObject)unmarshalledObject).getType()).getXsdLocalName();
            }
            return this.createDocument(unmarshalledDataObject, unmarshalledDataObject.getType().getURI(), localName);
        }
        if (unmarshalledObject instanceof XMLDocument) {
            return (XMLDocument)unmarshalledObject;
        }
        return null;
    }

    public String save(DataObject dataObject, String rootElementURI, String rootElementName) {
        try {
            StringWriter writer = new StringWriter();
            this.save(dataObject, rootElementURI, rootElementName, writer, this.getXmlMarshaller(null));
            return writer.toString();
        }
        catch (XMLMarshalException e) {
            throw SDOException.xmlMarshalExceptionOccurred((XMLMarshalException)e, (String)rootElementURI, (String)rootElementName);
        }
    }

    public void save(DataObject dataObject, String rootElementURI, String rootElementName, OutputStream outputStream) throws XMLMarshalException, IOException {
        XMLMarshaller xmlMarshaller = this.getXmlMarshaller(null);
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, xmlMarshaller.getEncoding());
        this.save(dataObject, rootElementURI, rootElementName, writer, xmlMarshaller);
    }

    public void serialize(XMLDocument xmlDocument, OutputStream outputStream, Object options) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, this.getXmlMarshaller().getEncoding());
        XMLMarshaller xmlMarshaller = this.getXmlContext().createMarshaller();
        xmlMarshaller.setMarshalListener((XMLMarshalListener)new SDOMarshalListener(xmlMarshaller, (SDOTypeHelper)this.aHelperContext.getTypeHelper()));
        this.save(xmlDocument, (Writer)writer, xmlMarshaller);
    }

    public void save(XMLDocument xmlDocument, OutputStream outputStream, Object options) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationWithNullInputParameter((String)"save", (String)"xmlDocument"));
        }
        XMLMarshaller xmlMarshaller = this.getXmlMarshaller(options);
        String encoding = xmlMarshaller.getEncoding();
        if (xmlDocument.getEncoding() != null) {
            encoding = xmlDocument.getEncoding();
        }
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, encoding);
        this.save(xmlDocument, (Writer)writer, xmlMarshaller);
    }

    public void save(XMLDocument xmlDocument, Writer outputWriter, Object options) throws IOException {
        this.save(xmlDocument, outputWriter, this.getXmlMarshaller(options));
    }

    private void save(XMLDocument xmlDocument, Writer outputWriter, XMLMarshaller anXMLMarshaller) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationWithNullInputParameter((String)"save", (String)"xmlDocument"));
        }
        anXMLMarshaller.setFragment(!xmlDocument.isXMLDeclaration());
        anXMLMarshaller.setEncoding(xmlDocument.getEncoding());
        anXMLMarshaller.setSchemaLocation(xmlDocument.getSchemaLocation());
        anXMLMarshaller.setNoNamespaceSchemaLocation(xmlDocument.getNoNamespaceSchemaLocation());
        Object writerRecord = anXMLMarshaller.isFormattedOutput() ? new FormattedWriterRecord() : new WriterRecord();
        writerRecord.setWriter(outputWriter);
        writerRecord.setMarshaller(anXMLMarshaller);
        ((SDOMarshalListener)anXMLMarshaller.getMarshalListener()).setMarshalledObject(xmlDocument.getRootObject());
        ((SDOMarshalListener)anXMLMarshaller.getMarshalListener()).setMarshalledObjectRootQName(new QName(xmlDocument.getRootElementURI(), xmlDocument.getRootElementName()));
        ((SDOMarshalListener)anXMLMarshaller.getMarshalListener()).setRootMarshalReocrd((MarshalRecord)writerRecord);
        anXMLMarshaller.marshal((Object)xmlDocument, (MarshalRecord)writerRecord);
        outputWriter.flush();
    }

    public void save(XMLDocument xmlDocument, Result result, Object options) throws IOException {
        if (xmlDocument == null) {
            throw new IllegalArgumentException((Throwable)SDOException.cannotPerformOperationWithNullInputParameter((String)"save", (String)"xmlDocument"));
        }
        if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)result;
            Writer writer = streamResult.getWriter();
            if (null == writer) {
                this.save(xmlDocument, streamResult.getOutputStream(), options);
            } else {
                this.save(xmlDocument, writer, options);
            }
        } else {
            XMLMarshaller anXMLMarshaller = this.getXmlMarshaller(options);
            anXMLMarshaller.setFragment(!xmlDocument.isXMLDeclaration());
            anXMLMarshaller.setEncoding(xmlDocument.getEncoding());
            anXMLMarshaller.setSchemaLocation(xmlDocument.getSchemaLocation());
            anXMLMarshaller.setNoNamespaceSchemaLocation(xmlDocument.getNoNamespaceSchemaLocation());
            ((SDOMarshalListener)anXMLMarshaller.getMarshalListener()).setMarshalledObject(xmlDocument.getRootObject());
            ((SDOMarshalListener)anXMLMarshaller.getMarshalListener()).setMarshalledObjectRootQName(new QName(xmlDocument.getRootElementURI(), xmlDocument.getRootElementName()));
            if (result instanceof SAXResult) {
                ContentHandlerRecord marshalRecord = new ContentHandlerRecord();
                marshalRecord.setContentHandler(((SAXResult)result).getHandler());
                marshalRecord.setMarshaller(anXMLMarshaller);
                ((SDOMarshalListener)anXMLMarshaller.getMarshalListener()).setRootMarshalReocrd((MarshalRecord)marshalRecord);
                anXMLMarshaller.marshal((Object)xmlDocument, (MarshalRecord)marshalRecord);
            } else if (result instanceof DOMResult) {
                NodeRecord marshalRecord = new NodeRecord();
                marshalRecord.setDOM(((DOMResult)result).getNode());
                marshalRecord.setMarshaller(anXMLMarshaller);
                ((SDOMarshalListener)anXMLMarshaller.getMarshalListener()).setRootMarshalReocrd((MarshalRecord)marshalRecord);
                anXMLMarshaller.marshal((Object)xmlDocument, (MarshalRecord)marshalRecord);
            } else {
                StringWriter writer = new StringWriter();
                this.save(xmlDocument, (Writer)writer, options);
                String xml = writer.toString();
                StreamSource source = new StreamSource(new StringReader(xml));
                anXMLMarshaller.getTransformer().transform((Source)source, result);
            }
        }
    }

    public XMLDocument createDocument(DataObject dataObject, String rootElementURI, String rootElementName) {
        Property globalProp;
        SDOXMLDocument document = new SDOXMLDocument();
        document.setRootObject(dataObject);
        document.setRootElementURI(rootElementURI);
        if (rootElementName != null) {
            document.setRootElementName(rootElementName);
        }
        if (null != (globalProp = this.getHelperContext().getXSDHelper().getGlobalProperty(rootElementURI, rootElementName, true))) {
            document.setSchemaType(((SDOType)globalProp.getType()).getXsdType());
        }
        document.setEncoding("UTF-8");
        document.setXMLVersion("1.0");
        return document;
    }

    private void save(DataObject rootObject, String rootElementURI, String rootElementName, Writer writer, XMLMarshaller anXMLMarshaller) throws XMLMarshalException {
        SDOXMLDocument xmlDocument = (SDOXMLDocument)this.createDocument(rootObject, rootElementURI, rootElementName);
        anXMLMarshaller.setFragment(!xmlDocument.isXMLDeclaration());
        Object writerRecord = anXMLMarshaller.isFormattedOutput() ? new FormattedWriterRecord() : new WriterRecord();
        writerRecord.setWriter(writer);
        writerRecord.setMarshaller(anXMLMarshaller);
        ((SDOMarshalListener)anXMLMarshaller.getMarshalListener()).setMarshalledObject(rootObject);
        ((SDOMarshalListener)anXMLMarshaller.getMarshalListener()).setMarshalledObjectRootQName(new QName(rootElementURI, rootElementName));
        ((SDOMarshalListener)anXMLMarshaller.getMarshalListener()).setRootMarshalReocrd((MarshalRecord)writerRecord);
        anXMLMarshaller.marshal((Object)xmlDocument, (MarshalRecord)writerRecord);
        try {
            writer.flush();
        }
        catch (IOException ex) {
            throw XMLMarshalException.marshalException((Exception)ex);
        }
    }

    public void setLoader(SDOClassLoader loader) {
        this.loader = loader;
        this.getXmlConversionManager().setLoader((ClassLoader)this.loader);
    }

    public SDOClassLoader getLoader() {
        return this.loader;
    }

    public void setXmlContext(XMLContext xmlContext) {
        this.xmlContext = xmlContext;
    }

    public synchronized XMLContext getXmlContext() {
        if (this.xmlContext == null) {
            this.xmlContext = new XMLContext(this.getTopLinkProject());
            XMLConversionManager xmlConversionManager = this.getXmlConversionManager();
            xmlConversionManager.setLoader((ClassLoader)this.loader);
            xmlConversionManager.setTimeZone(TimeZone.getTimeZone("GMT"));
            xmlConversionManager.setTimeZoneQualified(true);
        }
        return this.xmlContext;
    }

    public void initializeDescriptor(XMLDescriptor descriptor) {
        AbstractSession theSession = (AbstractSession)this.getXmlContext().getSession(0);
        descriptor.preInitialize(theSession);
        descriptor.initialize(theSession);
        descriptor.postInitialize(theSession);
        descriptor.getObjectBuilder().initializePrimaryKey(theSession);
        this.getXmlContext().storeXMLDescriptorByQName(descriptor);
    }

    public void addDescriptors(List types) {
        XMLDescriptor nextDescriptor;
        SDOType nextType;
        int i;
        for (i = 0; i < types.size(); ++i) {
            nextType = (SDOType)types.get(i);
            if (nextType.isDataType() || !nextType.isFinalized()) continue;
            nextDescriptor = nextType.getXmlDescriptor();
            this.getTopLinkProject().addDescriptor((ClassDescriptor)nextDescriptor);
        }
        for (i = 0; i < types.size(); ++i) {
            nextType = (SDOType)types.get(i);
            if (nextType.isDataType() || !nextType.isFinalized()) continue;
            nextDescriptor = nextType.getXmlDescriptor();
            this.initializeDescriptor(nextDescriptor);
        }
    }

    public void setTopLinkProject(Project toplinkProject) {
        this.topLinkProject = toplinkProject;
        this.xmlContext = null;
        this.xmlMarshallerMap.clear();
        this.xmlUnmarshallerMap.clear();
    }

    public Project getTopLinkProject() {
        if (this.topLinkProject == null) {
            this.topLinkProject = new Project();
            XMLLogin xmlLogin = new XMLLogin();
            xmlLogin.setEqualNamespaceResolvers(false);
            this.topLinkProject.setDatasourceLogin((Login)xmlLogin);
            NamespaceResolver nr = new NamespaceResolver();
            SDOTypeHelper sdoTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
            String sdoPrefix = sdoTypeHelper.getPrefix("commonj.sdo");
            nr.put(sdoPrefix, "commonj.sdo");
            SDOType changeSummaryType = (SDOType)sdoTypeHelper.getType("commonj.sdo", "ChangeSummaryType");
            changeSummaryType.getXmlDescriptor().setNamespaceResolver(nr);
            this.topLinkProject.addDescriptor((ClassDescriptor)changeSummaryType.getXmlDescriptor());
            SDOType openSequencedType = (SDOType)this.aHelperContext.getTypeHelper().getType("org.eclipse.persistence.sdo", "OpenSequencedType");
            this.topLinkProject.addDescriptor((ClassDescriptor)openSequencedType.getXmlDescriptor());
            SDOTypeType typeType = (SDOTypeType)this.aHelperContext.getTypeHelper().getType("commonj.sdo", "Type");
            typeType.getXmlDescriptor().setNamespaceResolver(nr);
            if (!typeType.isInitialized()) {
                typeType.initializeMappings();
            }
            this.topLinkProject.addDescriptor((ClassDescriptor)typeType.getXmlDescriptor());
            SDOPropertyType propertyType = (SDOPropertyType)this.aHelperContext.getTypeHelper().getType("commonj.sdo", "Property");
            if (!propertyType.isInitialized()) {
                propertyType.initializeMappings();
            }
            this.topLinkProject.addDescriptor((ClassDescriptor)propertyType.getXmlDescriptor());
            ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).addWrappersToProject(this.topLinkProject);
        }
        return this.topLinkProject;
    }

    public void setXmlMarshaller(XMLMarshaller xmlMarshaller) {
        this.xmlMarshallerMap.put(Thread.currentThread(), xmlMarshaller);
    }

    public XMLMarshaller getXmlMarshaller() {
        XMLMarshaller marshaller = this.xmlMarshallerMap.get(Thread.currentThread());
        if (marshaller == null) {
            marshaller = this.getXmlContext().createMarshaller();
            marshaller.setMarshalListener((XMLMarshalListener)new SDOMarshalListener(marshaller, (SDOTypeHelper)this.aHelperContext.getTypeHelper()));
            this.xmlMarshallerMap.put(Thread.currentThread(), marshaller);
        }
        XMLContext context = this.getXmlContext();
        if (marshaller.getXMLContext() != context) {
            marshaller.setXMLContext(context);
        }
        return marshaller;
    }

    private XMLMarshaller getXmlMarshaller(Object options) {
        XMLMarshaller xmlMarshaller = this.getXmlMarshaller().clone();
        if (null == options) {
            return xmlMarshaller;
        }
        try {
            DataObject optionsDO = (DataObject)options;
            if (optionsDO.isSet("attachmentMarshaller")) {
                xmlMarshaller.setAttachmentMarshaller((XMLAttachmentMarshaller)optionsDO.get("attachmentMarshaller"));
            }
            xmlMarshaller.setMarshalListener((XMLMarshalListener)new SDOMarshalListener(xmlMarshaller, (SDOTypeHelper)this.aHelperContext.getTypeHelper()));
            return xmlMarshaller;
        }
        catch (ClassCastException ccException) {
            throw SDOException.optionsMustBeADataObject((Exception)ccException, (String)"org.eclipse.persistence.sdo", (String)"LoadOptions");
        }
    }

    public void setXmlUnmarshaller(XMLUnmarshaller xmlUnmarshaller) {
        this.xmlUnmarshallerMap.put(Thread.currentThread(), xmlUnmarshaller);
    }

    public XMLUnmarshaller getXmlUnmarshaller() {
        XMLUnmarshaller unmarshaller = this.xmlUnmarshallerMap.get(Thread.currentThread());
        if (null == unmarshaller) {
            unmarshaller = this.getXmlContext().createUnmarshaller();
            unmarshaller.getProperties().put("sdoHelperContext", this.aHelperContext);
            unmarshaller.setUnmappedContentHandlerClass(SDOUnmappedContentHandler.class);
            unmarshaller.setUnmarshalListener((XMLUnmarshalListener)new SDOUnmarshalListener(this.aHelperContext));
            unmarshaller.setResultAlwaysXMLRoot(true);
            this.xmlUnmarshallerMap.put(Thread.currentThread(), unmarshaller);
        }
        XMLContext context = this.getXmlContext();
        if (unmarshaller.getXMLContext() != context) {
            unmarshaller.setXMLContext(context);
        }
        return unmarshaller;
    }

    private XMLUnmarshaller getXmlUnmarshaller(Object options) {
        XMLUnmarshaller xmlUnmarshaller = this.getXmlUnmarshaller().clone();
        if (null == options) {
            return xmlUnmarshaller;
        }
        try {
            DataObject optionsDO = (DataObject)options;
            if (optionsDO.isSet("attachmentUnmarshaller")) {
                xmlUnmarshaller.setAttachmentUnmarshaller((XMLAttachmentUnmarshaller)optionsDO.get("attachmentUnmarshaller"));
            }
            return xmlUnmarshaller;
        }
        catch (ClassCastException ccException) {
            throw SDOException.optionsMustBeADataObject((Exception)ccException, (String)"org.eclipse.persistence.sdo", (String)"LoadOptions");
        }
    }

    public void reset() {
        this.setTopLinkProject(null);
        this.setXmlContext(null);
        this.xmlMarshallerMap.clear();
        this.xmlUnmarshallerMap.clear();
        this.setLoader(new SDOClassLoader(this.getClass().getClassLoader(), this.aHelperContext));
    }

    public HelperContext getHelperContext() {
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    private void handleXMLMarshalException(XMLMarshalException xmlException) throws IOException {
        if (xmlException.getErrorCode() == 25008 || xmlException.getErrorCode() == 25007) {
            throw SDOException.globalPropertyNotFound();
        }
        if (xmlException.getCause() instanceof IOException) {
            throw (IOException)xmlException.getCause();
        }
        throw xmlException;
    }

    public XMLConversionManager getXmlConversionManager() {
        return (XMLConversionManager)this.getXmlContext().getSession(0).getDatasourceLogin().getDatasourcePlatform().getConversionManager();
    }
}

