/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.util.Map;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.PluralAttributeImpl;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.MapKeyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapAttributeImpl<X, K, V>
extends PluralAttributeImpl<X, Map<K, V>, V>
implements MapAttribute<X, K, V> {
    private static final long serialVersionUID = 5702748112869113135L;
    private Type<K> keyType;

    protected MapAttributeImpl(ManagedTypeImpl<X> managedType, CollectionMapping mapping) {
        this(managedType, mapping, false);
    }

    protected MapAttributeImpl(ManagedTypeImpl<X> managedType, CollectionMapping mapping, boolean validationEnabled) {
        super(managedType, mapping, validationEnabled);
        ContainerPolicy policy = mapping.getContainerPolicy();
        Class javaClass = null;
        MapKeyMapping keyMapping = null;
        Object policyKeyType = null;
        if (policy.isMapPolicy()) {
            if (policy.isMappedKeyMapPolicy()) {
                keyMapping = ((MappedKeyMapContainerPolicy)policy).getKeyMapping();
                policyKeyType = keyMapping.getMapKeyTargetType();
            } else {
                policyKeyType = policy.getKeyType();
            }
        }
        if (null == policyKeyType) {
            if (null == javaClass && policy.isMappedKeyMapPolicy()) {
                javaClass = this.getOwningPKTypeWhenMapKeyAnnotationMissingOrDefaulted((MappedKeyMapContainerPolicy)policy);
            }
        } else {
            javaClass = policyKeyType instanceof ClassDescriptor ? ((ClassDescriptor)policyKeyType).getJavaClass() : (Class)policyKeyType;
        }
        if (null == javaClass) {
            javaClass = Object.class;
        }
        this.keyType = this.getMetamodel().getType(javaClass);
    }

    private Class getOwningPKTypeWhenMapKeyAnnotationMissingOrDefaulted(MappedKeyMapContainerPolicy policy) {
        Class javaClass = null;
        MapKeyMapping mapKeyMapping = policy.getKeyMapping();
        RelationalDescriptor descriptor = (RelationalDescriptor)((DatabaseMapping)mapKeyMapping).getDescriptor();
        if (null != descriptor && null == (javaClass = ((DatabaseMapping)mapKeyMapping).getAttributeClassification()) && descriptor.getCMPPolicy() != null) {
            javaClass = descriptor.getCMPPolicy().getPKClass();
        }
        return javaClass;
    }

    @Override
    public PluralAttribute.CollectionType getCollectionType() {
        return PluralAttribute.CollectionType.MAP;
    }

    public Class<K> getKeyJavaType() {
        return this.keyType.getJavaType();
    }

    public Type<K> getKeyType() {
        return this.keyType;
    }

    public String toString() {
        return "MapAttributeImpl[" + this.getMapping() + "]";
    }
}

