/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.helper.WriteLockManager;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.coordination.CommandManager;
import org.eclipse.persistence.sessions.coordination.MergeChangeSetCommand;

public class IdentityMapAccessor
implements org.eclipse.persistence.sessions.IdentityMapAccessor,
Serializable {
    protected IdentityMapManager identityMapManager = null;
    protected AbstractSession session = null;

    public IdentityMapAccessor(AbstractSession session) {
        this.session = session;
    }

    public IdentityMapAccessor(AbstractSession session, IdentityMapManager identityMapManager) {
        this.session = session;
        this.identityMapManager = identityMapManager;
    }

    public CacheKey acquireDeferredLock(Object primarKey, Class javaClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().acquireDeferredLock(primarKey, javaClass, descriptor);
    }

    public CacheKey acquireLock(Object primarKey, Class javaClass, ClassDescriptor descriptor) {
        return this.acquireLock(primarKey, javaClass, false, descriptor);
    }

    public CacheKey acquireLock(Object primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().acquireLock(primaryKey, domainClass, forMerge, descriptor);
    }

    public CacheKey acquireLockNoWait(Object primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().acquireLockNoWait(primaryKey, domainClass, forMerge, descriptor);
    }

    public CacheKey acquireLockWithWait(Object primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor, int wait) {
        return this.getIdentityMapManager().acquireLockWithWait(primaryKey, domainClass, forMerge, descriptor, wait);
    }

    public CacheKey acquireReadLockOnCacheKey(Object primaryKey, Class domainClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().acquireReadLockOnCacheKey(primaryKey, domainClass, descriptor);
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Object primaryKey, Class domainClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().acquireReadLockOnCacheKeyNoWait(primaryKey, domainClass, descriptor);
    }

    public boolean acquireWriteLock() {
        return this.getIdentityMapManager().acquireWriteLock();
    }

    public void clearQueryCache() {
        this.getIdentityMapManager().clearQueryCache();
    }

    public void clearQueryCache(ReadQuery query) {
        this.getIdentityMapManager().clearQueryCache(query);
    }

    public void clearQueryCache(String sessionQueryName) {
        this.getIdentityMapManager().clearQueryCache((ReadQuery)this.session.getQuery(sessionQueryName));
    }

    public void clearQueryCache(String descriptorQueryName, Class queryClass) {
        this.getIdentityMapManager().clearQueryCache((ReadQuery)this.session.getDescriptor(queryClass).getQueryManager().getQuery(descriptorQueryName));
    }

    public boolean containsObjectInIdentityMap(Object object) {
        return this.containsObjectInIdentityMap(this.getSession().getId(object), object.getClass());
    }

    public Object primaryKeyFromVector(Vector primaryKeyVector) {
        if (primaryKeyVector == null) {
            return null;
        }
        if (primaryKeyVector.size() == 1) {
            return primaryKeyVector.get(0);
        }
        return new CacheId(primaryKeyVector.toArray());
    }

    @Deprecated
    public boolean containsObjectInIdentityMap(Vector primaryKey, Class theClass) {
        return this.containsObjectInIdentityMap(this.primaryKeyFromVector(primaryKey), theClass);
    }

    public boolean containsObjectInIdentityMap(Object primaryKey, Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        return this.containsObjectInIdentityMap(primaryKey, theClass, descriptor);
    }

    public boolean containsObjectInIdentityMap(Object primaryKey, Class theClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().containsKey(primaryKey, theClass, descriptor);
    }

    public boolean containsObjectInIdentityMap(Record rowContainingPrimaryKey, Class theClass) {
        return this.containsObjectInIdentityMap(this.extractPrimaryKeyFromRow(rowContainingPrimaryKey, theClass), theClass);
    }

    protected Object extractPrimaryKeyFromRow(Record rowContainingPrimaryKey, Class theClass) {
        return this.session.getDescriptor(theClass).getObjectBuilder().extractPrimaryKeyFromRow((AbstractRecord)rowContainingPrimaryKey, this.session);
    }

    public CacheKey getCacheKeyForObject(Object object, ClassDescriptor descriptor) {
        return this.getCacheKeyForObject(this.getSession().keyFromObject(object, descriptor), object.getClass(), descriptor);
    }

    public Vector getClassesRegistered() {
        return this.getIdentityMapManager().getClassesRegistered();
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow) throws QueryException {
        return this.getAllFromIdentityMap(selectionCriteria, theClass, translationRow, 0, true);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy) throws QueryException {
        return this.getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, true);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy) throws QueryException {
        return this.getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, true);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy, boolean shouldReturnInvalidatedObjects) throws QueryException {
        int policy = 0;
        if (valueHolderPolicy != null) {
            policy = valueHolderPolicy.getPolicy();
        }
        return this.getAllFromIdentityMap(selectionCriteria, theClass, translationRow, policy, shouldReturnInvalidatedObjects);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean shouldReturnInvalidatedObjects) throws QueryException {
        return this.getIdentityMapManager().getAllFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, shouldReturnInvalidatedObjects);
    }

    public Object getFromIdentityMap(Object object) {
        return this.getFromIdentityMap(this.getSession().getId(object), object.getClass());
    }

    public CacheKey getCacheKeyForObject(Object object) {
        return this.getCacheKeyForObject(this.getSession().getId(object), object.getClass(), this.getSession().getDescriptor(object.getClass()));
    }

    public CacheKey getCacheKeyForObjectForLock(Object primaryKey, Class myClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getCacheKeyForObjectForLock(primaryKey, myClass, descriptor);
    }

    public CacheKey getCacheKeyForObject(Object primaryKey, Class myClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getCacheKeyForObject(primaryKey, myClass, descriptor);
    }

    @Deprecated
    public Object getFromIdentityMap(Vector primaryKey, Class theClass) {
        return this.getFromIdentityMap(this.primaryKeyFromVector(primaryKey), theClass);
    }

    public Object getFromIdentityMap(Object primaryKey, Class theClass) {
        return this.getFromIdentityMap(primaryKey, theClass, true);
    }

    public Object getFromIdentityMap(Object primaryKey, Class theClass, ClassDescriptor descriptor) {
        return this.getFromIdentityMap(primaryKey, theClass, true, descriptor);
    }

    @Deprecated
    public Object getFromIdentityMap(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects) {
        return this.getFromIdentityMap(this.primaryKeyFromVector(primaryKey), theClass, shouldReturnInvalidatedObjects);
    }

    public Object getFromIdentityMap(Object primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects) {
        return this.getFromIdentityMap(primaryKey, theClass, shouldReturnInvalidatedObjects, this.getSession().getDescriptor(theClass));
    }

    public Object getFromIdentityMap(Object primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getFromIdentityMap(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    public Object getFromLocalIdentityMap(Object primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getFromIdentityMap(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    public Object getFromIdentityMap(Record rowContainingPrimaryKey, Class theClass) {
        return this.getFromIdentityMap(this.extractPrimaryKeyFromRow(rowContainingPrimaryKey, theClass), theClass);
    }

    public Object getFromIdentityMap(Record rowContainingPrimaryKey, Class theClass, boolean shouldReturnInvalidatedObjects) {
        return this.getFromIdentityMap(this.extractPrimaryKeyFromRow(rowContainingPrimaryKey, theClass), theClass, shouldReturnInvalidatedObjects);
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow) throws QueryException {
        return this.getFromIdentityMap(selectionCriteria, theClass, translationRow, 0);
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, InMemoryQueryIndirectionPolicy valueHolderPolicy) throws QueryException {
        int policy = 0;
        if (valueHolderPolicy != null) {
            policy = valueHolderPolicy.getPolicy();
        }
        return this.getFromIdentityMap(selectionCriteria, theClass, translationRow, policy, false);
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy) throws QueryException {
        return this.getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, false);
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean conforming) {
        return this.getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, conforming, true, this.getSession().getDescriptor(theClass));
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean conforming, boolean shouldReturnInvalidatedObjects) {
        return this.getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, conforming, shouldReturnInvalidatedObjects, this.getSession().getDescriptor(theClass));
    }

    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean conforming, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getFromIdentityMap(selectionCriteria, theClass, translationRow, valueHolderPolicy, conforming, shouldReturnInvalidatedObjects, descriptor);
    }

    public Object getFromIdentityMapWithDeferredLock(Object primaryKey, Class theClass, ClassDescriptor descriptor) {
        return this.getFromIdentityMapWithDeferredLock(primaryKey, theClass, true, descriptor);
    }

    public Object getFromIdentityMapWithDeferredLock(Object primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getFromIdentityMapWithDeferredLock(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    public IdentityMapManager getIdentityMapManager() {
        if (this.session.hasBroker()) {
            return this.getSession().getBroker().getIdentityMapAccessorInstance().getIdentityMapManager();
        }
        return this.identityMapManager;
    }

    public IdentityMap getIdentityMap(Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(theClass.toString());
        }
        return this.getIdentityMap(descriptor);
    }

    public IdentityMap getIdentityMap(ClassDescriptor descriptor) {
        return this.getIdentityMap(descriptor, false);
    }

    public IdentityMap getIdentityMap(ClassDescriptor descriptor, boolean returnNullIfMissing) {
        return this.getIdentityMapManager().getIdentityMap(descriptor, returnNullIfMissing);
    }

    public Object getQueryResult(ReadQuery query, List parameters, boolean checkExpiry) {
        return this.getIdentityMapManager().getQueryResult(query, parameters, checkExpiry);
    }

    public long getRemainingValidTime(Object object) {
        Object primaryKey = this.getSession().getId(object);
        ClassDescriptor descriptor = this.getSession().getDescriptor(object);
        CacheKey key = this.getCacheKeyForObjectForLock(primaryKey, object.getClass(), descriptor);
        if (key == null) {
            throw QueryException.objectDoesNotExistInCache(object);
        }
        return descriptor.getCacheInvalidationPolicy().getRemainingValidTime(key);
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Object getWrapper(Object primaryKey, Class theClass) {
        return this.getIdentityMapManager().getWrapper(primaryKey, theClass);
    }

    public WriteLockManager getWriteLockManager() {
        return this.getIdentityMapManager().getWriteLockManager();
    }

    public Object getWriteLockValue(Object object) {
        return this.getWriteLockValue(this.getSession().getId(object), object.getClass());
    }

    @Deprecated
    public Object getWriteLockValue(Vector primaryKey, Class theClass) {
        return this.getWriteLockValue(this.primaryKeyFromVector(primaryKey), theClass);
    }

    public Object getWriteLockValue(Object primaryKey, Class theClass) {
        return this.getWriteLockValue(primaryKey, theClass, this.getSession().getDescriptor(theClass));
    }

    public Object getWriteLockValue(Object primaryKey, Class theClass, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().getWriteLockValue(primaryKey, theClass, descriptor);
    }

    public void initializeAllIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_all_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
    }

    public void initializeIdentityMap(Class theClass) {
        this.getSession().log(2, "cache", "initialize_identitymap", theClass);
        this.getIdentityMapManager().initializeIdentityMap(theClass);
    }

    public void initializeIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
        if (this.getSession().hasCommitManager()) {
            this.getSession().getCommitManager().reinitialize();
        }
    }

    public void invalidateObject(Object object) {
        this.invalidateObject(object, false);
    }

    public void invalidateObject(Object object, boolean invalidateCluster) {
        this.invalidateObject(this.getSession().getId(object), object.getClass(), invalidateCluster);
    }

    @Deprecated
    public void invalidateObject(Vector primaryKey, Class theClass, boolean invalidateCluster) {
        this.invalidateObject(this.primaryKeyFromVector(primaryKey), theClass, invalidateCluster);
    }

    @Deprecated
    public void invalidateObject(Vector primaryKey, Class theClass) {
        this.invalidateObject(this.primaryKeyFromVector(primaryKey), theClass);
    }

    public void invalidateObject(Object primaryKey, Class theClass) {
        this.invalidateObject(primaryKey, theClass, false);
    }

    public void invalidateObject(Object primaryKey, Class theClass, boolean invalidateCluster) {
        CommandManager rcm;
        if (primaryKey == null) {
            return;
        }
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        CacheKey key = this.getCacheKeyForObjectForLock(primaryKey, theClass, descriptor);
        if (key != null) {
            key.setInvalidationState(-1);
        }
        if (invalidateCluster && (rcm = this.getSession().getCommandManager()) != null) {
            UnitOfWorkChangeSet changeSet = new UnitOfWorkChangeSet(this.getSession());
            ObjectChangeSet objectChangeSet = new ObjectChangeSet(primaryKey, descriptor, null, changeSet, false);
            objectChangeSet.setSynchronizationType(2);
            changeSet.getAllChangeSets().put(objectChangeSet, objectChangeSet);
            MergeChangeSetCommand command = new MergeChangeSetCommand();
            command.setChangeSet(changeSet);
            try {
                command.convertChangeSetToByteArray(this.getSession());
            }
            catch (IOException exception) {
                throw CommunicationException.unableToPropagateChanges(command.getServiceId().getId(), exception);
            }
            rcm.propagateCommand(command);
        }
    }

    public void invalidateObject(Record rowContainingPrimaryKey, Class theClass) {
        this.invalidateObject(rowContainingPrimaryKey, theClass, false);
    }

    public void invalidateObject(Record rowContainingPrimaryKey, Class theClass, boolean invalidateCluster) {
        this.invalidateObject(this.extractPrimaryKeyFromRow(rowContainingPrimaryKey, theClass), theClass, invalidateCluster);
    }

    public void invalidateObjects(Expression selectionCriteria) {
        this.invalidateObjects(selectionCriteria, selectionCriteria.getBuilder().getQueryClass(), new DatabaseRecord(0), true);
    }

    public void invalidateObjects(Expression selectionCriteria, Class theClass, Record translationRow, boolean shouldInvalidateOnException) {
        this.getIdentityMapManager().invalidateObjects(selectionCriteria, theClass, translationRow, shouldInvalidateOnException);
    }

    public void invalidateObjects(Collection collection) {
        this.invalidateObjects(collection, false);
    }

    public void invalidateObjects(Collection collection, boolean invalidateCluster) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.invalidateObject(iterator.next(), invalidateCluster);
        }
    }

    public void invalidateClass(Class myClass) {
        this.invalidateClass(myClass, true);
    }

    public void invalidateClass(Class myClass, boolean recurseAndInvalidateToParentRoot) {
        IdentityMap identityMap = this.getIdentityMap(myClass);
        Enumeration keys = identityMap.keys(false);
        while (keys.hasMoreElements()) {
            CacheKey key = (CacheKey)keys.nextElement();
            Object obj = key.getObject();
            if (!recurseAndInvalidateToParentRoot && (obj == null || null == myClass || !myClass.isAssignableFrom(obj.getClass()))) continue;
            key.setInvalidationState(-1);
        }
    }

    public void invalidateAll() {
        Iterator identiyMapClasses = this.getIdentityMapManager().getIdentityMapClasses();
        while (identiyMapClasses.hasNext()) {
            this.invalidateClass((Class)identiyMapClasses.next());
        }
    }

    public boolean isValid(Object object) {
        return this.isValid(this.getSession().getId(object), object.getClass());
    }

    @Deprecated
    public boolean isValid(Vector primaryKey, Class theClass) {
        return this.isValid(this.primaryKeyFromVector(primaryKey), theClass);
    }

    public boolean isValid(Object primaryKey, Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        CacheKey key = this.getCacheKeyForObjectForLock(primaryKey, theClass, descriptor);
        if (key == null) {
            throw QueryException.classPkDoesNotExistInCache(theClass, primaryKey);
        }
        return !descriptor.getCacheInvalidationPolicy().isInvalidated(key);
    }

    public boolean isValid(Record rowContainingPrimaryKey, Class theClass) {
        return this.isValid(this.extractPrimaryKeyFromRow(rowContainingPrimaryKey, theClass), theClass);
    }

    public void printIdentityMap(Class businessClass) {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMap(businessClass);
        }
    }

    public void printIdentityMaps() {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMaps();
        }
    }

    public void printIdentityMapLocks() {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printLocks();
        }
    }

    public Object putInIdentityMap(Object object) {
        return this.putInIdentityMap(object, this.getSession().getId(object));
    }

    @Deprecated
    public Object putInIdentityMap(Object object, Vector key) {
        return this.putInIdentityMap(object, this.primaryKeyFromVector(key));
    }

    public Object putInIdentityMap(Object object, Object key) {
        return this.putInIdentityMap(object, key, null);
    }

    @Deprecated
    public Object putInIdentityMap(Object object, Vector key, Object writeLockValue) {
        return this.putInIdentityMap(object, key, writeLockValue, 0L);
    }

    public Object putInIdentityMap(Object object, Object key, Object writeLockValue) {
        return this.putInIdentityMap(object, key, writeLockValue, 0L);
    }

    @Deprecated
    public Object putInIdentityMap(Object object, Vector key, Object writeLockValue, long readTime) {
        return this.putInIdentityMap(object, this.primaryKeyFromVector(key), writeLockValue, readTime);
    }

    public Object putInIdentityMap(Object object, Object key, Object writeLockValue, long readTime) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(object);
        return this.putInIdentityMap(object, key, writeLockValue, readTime, descriptor);
    }

    public Object putInIdentityMap(Object object, Object key, Object writeLockValue, long readTime, ClassDescriptor descriptor) {
        CacheKey cacheKey = this.internalPutInIdentityMap(object, key, writeLockValue, readTime, descriptor);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getObject();
    }

    public void putQueryResult(ReadQuery query, List parameters, Object results) {
        this.getIdentityMapManager().putQueryResult(query, parameters, results);
    }

    public CacheKey internalPutInIdentityMap(Object object, Object key, Object writeLockValue, long readTime, ClassDescriptor descriptor) {
        return this.getIdentityMapManager().putInIdentityMap(object, key, writeLockValue, readTime, descriptor);
    }

    public void releaseWriteLock() {
        this.getIdentityMapManager().releaseWriteLock();
    }

    public Object removeFromIdentityMap(Object object) {
        Class<?> theClass = object.getClass();
        return this.removeFromIdentityMap(this.getSession().getId(object), theClass, this.getSession().getDescriptor(theClass), object);
    }

    @Deprecated
    public Object removeFromIdentityMap(Vector key, Class theClass) {
        return this.removeFromIdentityMap(this.primaryKeyFromVector(key), theClass);
    }

    public Object removeFromIdentityMap(Object key, Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        return this.removeFromIdentityMap(key, theClass, descriptor, null);
    }

    public Object removeFromIdentityMap(Object key, Class theClass, ClassDescriptor descriptor, Object object) {
        return this.getIdentityMapManager().removeFromIdentityMap(key, theClass, descriptor, object);
    }

    public void setIdentityMapManager(IdentityMapManager identityMapManager) {
        this.identityMapManager = identityMapManager;
    }

    public void setWrapper(Object primaryKey, Class theClass, Object wrapper) {
        this.getIdentityMapManager().setWrapper(primaryKey, theClass, wrapper);
    }

    public void updateWriteLockValue(Object object, Object writeLockValue) {
        this.updateWriteLockValue(this.getSession().getId(object), object.getClass(), writeLockValue);
    }

    @Deprecated
    public void updateWriteLockValue(Vector primaryKey, Class theClass, Object writeLockValue) {
        this.updateWriteLockValue(this.primaryKeyFromVector(primaryKey), theClass, writeLockValue);
    }

    public void updateWriteLockValue(Object primaryKey, Class theClass, Object writeLockValue) {
        this.getIdentityMapManager().setWriteLockValue(primaryKey, theClass, writeLockValue);
    }

    public void validateCache() {
        this.getSession().log(2, "cache", "validate_cache");
        DescriptorIterator iterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (!IdentityMapAccessor.this.containsObjectInIdentityMap(IdentityMapAccessor.this.session.getDescriptor(object.getClass()).getObjectBuilder().extractPrimaryKeyFromObject(object, IdentityMapAccessor.this.getSession()), object.getClass())) {
                    IdentityMapAccessor.this.session.log(1, "cache", "stack_of_visited_objects_that_refer_to_the_corrupt_object", this.getVisitedStack());
                    IdentityMapAccessor.this.session.log(2, "cache", "corrupt_object_referenced_through_mapping", this.getCurrentMapping());
                    IdentityMapAccessor.this.session.log(2, "cache", "corrupt_object", object);
                }
            }
        };
        iterator.setSession(this.getSession());
        for (ClassDescriptor descriptor : this.getSession().getDescriptors().values()) {
            IdentityMap cache = this.getIdentityMap(descriptor, true);
            if (cache == null) continue;
            Enumeration mapEnum = cache.elements();
            while (mapEnum.hasMoreElements()) {
                iterator.startIterationOn(mapEnum.nextElement());
            }
        }
    }
}

