/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.MapsId;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.WeavedObjectBasicIndirectionPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedIdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToOneMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectAccessor
extends RelationshipAccessor {
    private Boolean m_id;
    private Boolean m_optional;
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();
    private String m_mapsId;

    protected ObjectAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected ObjectAccessor(MetadataAnnotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        MetadataAnnotation primaryKeyJoinColumn;
        MetadataAnnotation primaryKeyJoinColumns;
        if (annotation != null) {
            this.m_optional = (Boolean)annotation.getAttribute("optional");
        }
        if ((primaryKeyJoinColumns = this.getAnnotation(PrimaryKeyJoinColumns.class)) != null) {
            for (Object primaryKeyJoinColumn2 : (Object[])primaryKeyJoinColumns.getAttributeArray("value")) {
                this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((MetadataAnnotation)primaryKeyJoinColumn2, accessibleObject));
            }
        }
        if ((primaryKeyJoinColumn = this.getAnnotation(PrimaryKeyJoinColumn.class)) != null) {
            this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata(primaryKeyJoinColumn, accessibleObject));
        }
        if (this.isAnnotationPresent(MapsId.class)) {
            this.m_mapsId = (String)this.getAnnotation(MapsId.class).getAttributeString("value");
        }
        this.m_id = this.isAnnotationPresent(Id.class);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof ObjectAccessor) {
            ObjectAccessor objectAccessor = (ObjectAccessor)objectToCompare;
            if (!this.valuesMatch(this.m_id, objectAccessor.getId())) {
                return false;
            }
            if (!this.valuesMatch(this.m_optional, objectAccessor.getOptional())) {
                return false;
            }
            if (!this.valuesMatch(this.m_primaryKeyJoinColumns, objectAccessor.getPrimaryKeyJoinColumns())) {
                return false;
            }
            return this.valuesMatch(this.m_mapsId, objectAccessor.getMapsId());
        }
        return false;
    }

    @Override
    public boolean derivesId() {
        return this.hasId() || this.hasMapsId();
    }

    @Override
    public String getDefaultFetchType() {
        return FetchType.EAGER.name();
    }

    public Boolean getId() {
        return this.m_id;
    }

    public String getMapsId() {
        return this.m_mapsId;
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    @Override
    public MetadataClass getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass.isVoid()) {
                this.m_referenceClass = super.getReferenceClass();
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    protected MetadataClass getSimplePKType() {
        MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
        ClassAccessor referenceAccessor = referenceDescriptor.getClassAccessor();
        if (referenceAccessor.hasDerivedId()) {
            return ((ObjectAccessor)referenceDescriptor.getAccessorFor(referenceDescriptor.getIdAttributeName())).getSimplePKType();
        }
        return referenceDescriptor.getAccessorFor(referenceDescriptor.getIdAttributeName()).getRawClass();
    }

    @Override
    public boolean hasAttributeType() {
        return this.getReferenceClass() != null;
    }

    protected boolean hasId() {
        return this.m_id != null && this.m_id != false;
    }

    protected boolean hasMapsId() {
        return this.m_mapsId != null;
    }

    protected OneToOneMapping initOneToOneMapping() {
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setIsOneToOneRelationship(true);
        mapping.setIsReadOnly(false);
        mapping.setIsOptional(this.isOptional());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setDerivesId(this.derivesId());
        this.processJoinFetch(this.getJoinFetch(), (ForeignReferenceMapping)mapping);
        this.processBatchFetch(this.getBatchFetch(), (ForeignReferenceMapping)mapping);
        this.processOrphanRemoval((ForeignReferenceMapping)mapping);
        this.processIndirection((ObjectReferenceMapping)mapping);
        this.setAccessorMethods((DatabaseMapping)mapping);
        this.processCascadeTypes((ForeignReferenceMapping)mapping);
        this.processReturnInsertAndUpdate();
        return mapping;
    }

    protected ManyToOneMapping initManyToOneMapping() {
        ManyToOneMapping mapping = new ManyToOneMapping();
        mapping.setIsReadOnly(false);
        mapping.setIsOptional(this.isOptional());
        mapping.setAttributeName(this.getAttributeName());
        mapping.setReferenceClassName(this.getReferenceClassName());
        mapping.setDerivesId(this.derivesId());
        this.processJoinFetch(this.getJoinFetch(), (ForeignReferenceMapping)mapping);
        this.processBatchFetch(this.getBatchFetch(), (ForeignReferenceMapping)mapping);
        this.processOrphanRemoval((ForeignReferenceMapping)mapping);
        this.processIndirection((ObjectReferenceMapping)mapping);
        this.setAccessorMethods((DatabaseMapping)mapping);
        this.processCascadeTypes((ForeignReferenceMapping)mapping);
        this.processReturnInsertAndUpdate();
        return mapping;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, accessibleObject);
    }

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && !this.m_primaryKeyJoinColumns.isEmpty();
    }

    public boolean isOptional() {
        return this.m_optional != null && this.m_optional != false;
    }

    @Override
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, MetadataDescriptor owningDescriptor) {
        if (this.getMapping().isOneToOneMapping()) {
            this.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor.getPrimaryTable(), owningDescriptor);
        } else {
            super.processAssociationOverride(associationOverride, embeddableMapping, owningDescriptor);
        }
    }

    protected void processAssociationOverride(AssociationOverrideMetadata associationOverride, EmbeddableMapping embeddableMapping, DatabaseTable defaultTable, MetadataDescriptor owningDescriptor) {
        for (JoinColumnMetadata joinColumn : this.getJoinColumnsAndValidate(associationOverride.getJoinColumns(), this.getReferenceDescriptor())) {
            DatabaseField pkField = joinColumn.getPrimaryKeyField();
            this.setFieldName(pkField, this.getReferenceDescriptor().getPrimaryKeyFieldName(), "metadata_default_pk_column");
            pkField.setTable(this.getReferenceDescriptor().getPrimaryKeyTable());
            DatabaseField fkField = (DatabaseField)((OneToOneMapping)this.getMapping()).getTargetToSourceKeyFields().get(pkField);
            if (fkField == null) {
                throw ValidationException.invalidAssociationOverrideReferenceColumnName((String)pkField.getName(), (String)associationOverride.getName(), (String)embeddableMapping.getAttributeName(), (String)owningDescriptor.getJavaClassName());
            }
            DatabaseField translationFKField = joinColumn.getForeignKeyField();
            if (!translationFKField.hasTableName()) {
                translationFKField.setTable(defaultTable);
            }
            embeddableMapping.addFieldNameTranslation(translationFKField.getQualifiedName(), fkField.getName());
        }
    }

    protected void processId(OneToOneMapping mapping) {
        MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
        String referencePKClassName = referenceDescriptor.getPKClassName();
        if (referencePKClassName != null) {
            String pkClassName = this.getDescriptor().getPKClassName();
            if (pkClassName == null) {
                throw ValidationException.invalidCompositePKSpecification((Object)this.getJavaClass(), (String)pkClassName);
            }
            if (pkClassName.equals(referencePKClassName)) {
                this.getOwningDescriptor().getPKClassIDs().clear();
            } else {
                this.getOwningDescriptor().validateDerivedPKClassId(this.getAttributeName(), referencePKClassName, this.getReferenceClassName());
            }
        } else {
            MetadataClass type = null;
            type = referenceDescriptor.getClassAccessor().hasDerivedId() ? ((ObjectAccessor)referenceDescriptor.getAccessorFor(referenceDescriptor.getIdAttributeName())).getSimplePKType() : referenceDescriptor.getAccessorFor(referenceDescriptor.getIdAttributeName()).getRawClass();
            this.getOwningDescriptor().validateDerivedPKClassId(this.getAttributeName(), this.getBoxedType(type.getName()), this.getReferenceClassName());
        }
        this.getOwningDescriptor().addIdAttributeName(this.getAttributeName());
        for (DatabaseField pkField : mapping.getForeignKeyFields()) {
            this.getOwningDescriptor().addPrimaryKeyField(pkField, null);
        }
    }

    protected void processIndirection(ObjectReferenceMapping mapping) {
        boolean usesIndirection = this.usesIndirection();
        if (usesIndirection && !this.getProject().isWeavingEnabled() && !ClassConstants.PersistenceWeavedLazy_Class.isAssignableFrom(this.getJavaClass(this.getDescriptor().getJavaClass()))) {
            usesIndirection = false;
        }
        String actualAttributeType = this.getAttributeType();
        if (this.getAccessibleObject() != null) {
            actualAttributeType = this.getAccessibleObject().getType();
        }
        if (usesIndirection && this.usesPropertyAccess()) {
            mapping.setIndirectionPolicy((IndirectionPolicy)new WeavedObjectBasicIndirectionPolicy(this.getGetMethodName(), this.getSetMethodName(), actualAttributeType, true));
        } else if (usesIndirection && this.usesFieldAccess()) {
            mapping.setIndirectionPolicy((IndirectionPolicy)new WeavedObjectBasicIndirectionPolicy(Helper.getWeavedGetMethodName((String)mapping.getAttributeName()), Helper.getWeavedSetMethodName((String)mapping.getAttributeName()), actualAttributeType, false));
        } else {
            mapping.setUsesIndirection(usesIndirection);
        }
        mapping.setIsLazy(this.isLazy());
    }

    protected void processMapsId(OneToOneMapping oneToOneMapping) {
        EmbeddedIdAccessor embeddedIdAccessor = this.getDescriptor().getEmbeddedIdAccessor();
        if (embeddedIdAccessor == null) {
            MappingAccessor idAccessor = this.getDescriptor().getAccessorFor(this.getDescriptor().getIdAttributeName());
            DatabaseMapping idMapping = idAccessor.getMapping();
            DatabaseField foreignKeyField = (DatabaseField)oneToOneMapping.getForeignKeyFields().elementAt(0);
            this.updatePrimaryKeyField(idAccessor, foreignKeyField);
            ((DirectToFieldMapping)idMapping).setField(foreignKeyField);
            idMapping.setIsReadOnly(true);
            oneToOneMapping.setDerivedIdMapping(idMapping);
        } else {
            if (embeddedIdAccessor.getReferenceClassName().equals(this.getReferenceDescriptor().getPKClassName())) {
                this.processMapsIdFields(oneToOneMapping, embeddedIdAccessor, embeddedIdAccessor);
            } else {
                if (this.m_mapsId.equals("")) {
                    this.m_mapsId = this.getAttributeName();
                }
                oneToOneMapping.setMapsIdValue(this.m_mapsId);
                MappingAccessor mappingAccessor = embeddedIdAccessor.getReferenceDescriptor().getAccessorFor(this.m_mapsId);
                if (mappingAccessor == null) {
                    throw ValidationException.invalidMappedByIdValue((String)this.m_mapsId, (String)this.getAnnotatedElementName(), (Object)embeddedIdAccessor.getReferenceClass());
                }
                this.processMapsIdFields(oneToOneMapping, embeddedIdAccessor, mappingAccessor);
            }
            oneToOneMapping.setDerivedIdMapping(embeddedIdAccessor.getMapping());
        }
    }

    protected void processMapsIdFields(OneToOneMapping oneToOneMapping, EmbeddedIdAccessor embeddedIdAccessor, MappingAccessor mapsIdAccessor) {
        for (DatabaseField fkField : oneToOneMapping.getForeignKeyFields()) {
            if (mapsIdAccessor.isBasic()) {
                embeddedIdAccessor.addMapsIdAccessor(mapsIdAccessor);
                embeddedIdAccessor.updateDerivedIdField((EmbeddableMapping)embeddedIdAccessor.getMapping(), mapsIdAccessor.getAttributeName(), fkField, mapsIdAccessor);
                continue;
            }
            if (mapsIdAccessor.isDerivedIdClass()) {
                embeddedIdAccessor.addMapsIdAccessor(mapsIdAccessor);
            } else {
                embeddedIdAccessor.getMapping().setIsReadOnly(true);
            }
            DatabaseField referencePKField = (DatabaseField)oneToOneMapping.getSourceToTargetKeyFields().get(fkField);
            MappingAccessor referencePKAccessor = this.getReferenceDescriptor().getPrimaryKeyAccessorForField(referencePKField);
            if (referencePKAccessor == null) {
                throw ValidationException.invalidDerivedIdPrimaryKeyField((String)this.getReferenceClassName(), (String)referencePKField.getQualifiedName(), (String)this.getAttributeName(), (String)this.getJavaClassName());
            }
            MappingAccessor idAccessor = mapsIdAccessor.getReferenceDescriptor().getAccessorFor(referencePKAccessor.getAttributeName());
            ((EmbeddedAccessor)mapsIdAccessor).updateDerivedIdField((EmbeddableMapping)mapsIdAccessor.getMapping(), idAccessor.getAttributeName(), fkField, idAccessor);
        }
    }

    protected void processOneToOneForeignKeyRelationship(OneToOneMapping mapping) {
        String defaultPKFieldName = this.getReferenceDescriptor().getPrimaryKeyFieldName();
        String defaultFKFieldName = this.getDefaultAttributeName() + "_" + defaultPKFieldName;
        this.processOneToOneForeignKeyRelationship(mapping, this.getJoinColumns(this.getJoinColumns(), this.getReferenceDescriptor()), defaultPKFieldName, this.getReferenceDatabaseTable(), defaultFKFieldName, this.getDescriptor().getPrimaryTable());
    }

    protected void processOneToOnePrimaryKeyRelationship(OneToOneMapping mapping) {
        MetadataDescriptor referenceDescriptor = this.getReferenceDescriptor();
        List<PrimaryKeyJoinColumnMetadata> pkJoinColumns = this.processPrimaryKeyJoinColumns(new PrimaryKeyJoinColumnsMetadata(this.getPrimaryKeyJoinColumns()));
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumn : pkJoinColumns) {
            DatabaseField pkField = primaryKeyJoinColumn.getPrimaryKeyField();
            this.setFieldName(pkField, referenceDescriptor.getPrimaryKeyFieldName(), "metadata_default_pk_column");
            pkField.setTable(referenceDescriptor.getPrimaryTable());
            DatabaseField fkField = primaryKeyJoinColumn.getForeignKeyField();
            this.setFieldName(fkField, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column");
            fkField.setTable(this.getDescriptor().getPrimaryTable());
            mapping.addForeignKeyField(fkField, pkField);
            mapping.setIsReadOnly(true);
        }
    }

    protected void processOwningMappingKeys(OneToOneMapping mapping) {
        if (this.derivesId()) {
            this.processOneToOneForeignKeyRelationship(mapping);
            if (this.hasMapsId()) {
                this.processMapsId(mapping);
            } else {
                this.processId(mapping);
            }
        } else if (this.isOneToOnePrimaryKeyRelationship()) {
            this.processOneToOnePrimaryKeyRelationship(mapping);
        } else if (this.hasJoinTable()) {
            mapping.setRelationTableMechanism(new RelationTableMechanism());
            this.processJoinTable((ForeignReferenceMapping)mapping, mapping.getRelationTableMechanism(), this.getJoinTable());
        } else {
            this.processOneToOneForeignKeyRelationship(mapping);
        }
    }

    public void setId(Boolean id) {
        this.m_id = id;
    }

    public void setMapsId(String mapsId) {
        this.m_mapsId = mapsId;
    }

    public void setOptional(Boolean isOptional) {
        this.m_optional = isOptional;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> primaryKeyJoinColumns) {
        this.m_primaryKeyJoinColumns = primaryKeyJoinColumns;
    }
}

