/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.TypeMappingInfo;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.Generator;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.jaxb.javamodel.reflection.AnnotationHelper;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelInputImpl;
import org.eclipse.persistence.jaxb.xmlmodel.JavaType;
import org.eclipse.persistence.jaxb.xmlmodel.XmlBindings;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.platform.SAXPlatform;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBContextFactory {
    public static final String ECLIPSELINK_OXM_XML_KEY = "eclipselink-oxm-xml";
    public static final String DEFAULT_TARGET_NAMESPACE_KEY = "defaultTargetNamespace";
    public static final String ANNOTATION_HELPER_KEY = "annotationHelper";
    public static final String PKG_SEPARATOR = ".";

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties) throws JAXBException {
        ClassLoader loader = null;
        if (classesToBeBound.length > 0 && null == (loader = classesToBeBound[0].getClassLoader())) {
            loader = JAXBContextFactory.getDefaultClassLoader();
        }
        return JAXBContextFactory.createContext(classesToBeBound, properties, loader);
    }

    public static javax.xml.bind.JAXBContext createContext(Class[] classesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        Type[] types = new Type[classesToBeBound.length];
        System.arraycopy(classesToBeBound, 0, types, 0, classesToBeBound.length);
        return JAXBContextFactory.createContext(types, properties, classLoader);
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader) throws JAXBException {
        return JAXBContextFactory.createContext(contextPath, classLoader, null);
    }

    public static javax.xml.bind.JAXBContext createContext(String contextPath, ClassLoader classLoader, Map properties) throws JAXBException {
        if (null == classLoader) {
            classLoader = JAXBContextFactory.getDefaultClassLoader();
        }
        Throwable sessionLoadingException = null;
        try {
            XMLContext xmlContext = new XMLContext(contextPath, classLoader);
            return new JAXBContext(xmlContext);
        }
        catch (ValidationException vex) {
            if (vex.getErrorCode() != 7095) {
                sessionLoadingException = vex;
            }
        }
        catch (SessionLoaderException ex) {
            sessionLoadingException = ex;
        }
        catch (Exception ex) {
            throw new JAXBException((Throwable)ex);
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        Map<String, XmlBindings> xmlBindingMap = JAXBContextFactory.getXmlBindingsFromProperties(properties, classLoader);
        classes = JAXBContextFactory.getXmlBindingsClassesFromMap(xmlBindingMap, classLoader, classes);
        StringTokenizer tokenizer = new StringTokenizer(contextPath, ":");
        while (tokenizer.hasMoreElements()) {
            InputStream jaxbIndex;
            String path = tokenizer.nextToken();
            try {
                Class<?> objectFactory = classLoader.loadClass(path + ".ObjectFactory");
                if (JAXBContextFactory.isJAXB2ObjectFactory(objectFactory)) {
                    classes.add(objectFactory);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                classLoader.loadClass(path + ".package-info");
            }
            catch (Exception ex) {
                // empty catch block
            }
            if ((jaxbIndex = classLoader.getResourceAsStream(path.replace('.', '/') + "/jaxb.index")) == null) continue;
            BufferedReader reader = new BufferedReader(new InputStreamReader(jaxbIndex));
            try {
                String line = reader.readLine();
                while (line != null) {
                    String className = path + PKG_SEPARATOR + line.trim();
                    try {
                        classes.add(classLoader.loadClass(className));
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception ex) {
            }
        }
        if (classes.size() == 0) {
            org.eclipse.persistence.exceptions.JAXBException jaxbException = org.eclipse.persistence.exceptions.JAXBException.noObjectFactoryOrJaxbIndexInPath((String)contextPath);
            if (sessionLoadingException != null) {
                jaxbException.setInternalException(sessionLoadingException);
            }
            throw new JAXBException((Throwable)jaxbException);
        }
        Class[] classArray = new Class[classes.size()];
        for (int i = 0; i < classes.size(); ++i) {
            classArray[i] = classes.get(i);
        }
        return JAXBContextFactory.createContext(classArray, properties, classLoader, xmlBindingMap);
    }

    public static javax.xml.bind.JAXBContext createContext(Type[] typesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        HashMap<Type, TypeMappingInfo> typeToTypeMappingInfo = new HashMap<Type, TypeMappingInfo>();
        TypeMappingInfo[] typeMappingInfo = new TypeMappingInfo[typesToBeBound.length];
        for (int i = 0; i < typesToBeBound.length; ++i) {
            TypeMappingInfo tmi = new TypeMappingInfo();
            tmi.setType(typesToBeBound[i]);
            typeToTypeMappingInfo.put(typesToBeBound[i], tmi);
            typeMappingInfo[i] = tmi;
        }
        JAXBContext context = (JAXBContext)JAXBContextFactory.createContext(typeMappingInfo, properties, classLoader);
        context.setTypeToTypeMappingInfo(typeToTypeMappingInfo);
        return context;
    }

    public static javax.xml.bind.JAXBContext createContext(TypeMappingInfo[] typesToBeBound, Map properties, ClassLoader classLoader) throws JAXBException {
        if (null == classLoader) {
            classLoader = JAXBContextFactory.getDefaultClassLoader();
        }
        Map<String, XmlBindings> xmlBindings = JAXBContextFactory.getXmlBindingsFromProperties(properties, classLoader);
        String defaultTargetNamespace = null;
        AnnotationHelper annotationHelper = null;
        if (properties != null) {
            defaultTargetNamespace = (String)properties.get(DEFAULT_TARGET_NAMESPACE_KEY);
            annotationHelper = (AnnotationHelper)properties.get(ANNOTATION_HELPER_KEY);
        }
        for (Map.Entry<String, XmlBindings> entry : xmlBindings.entrySet()) {
            typesToBeBound = JAXBContextFactory.getXmlBindingsClasses(entry.getValue(), classLoader, typesToBeBound);
        }
        JaxbClassLoader loader = new JaxbClassLoader(classLoader, typesToBeBound);
        typesToBeBound = JAXBContextFactory.updateTypesWithObjectFactory(typesToBeBound, loader);
        JavaModelImpl jModel = annotationHelper != null ? new JavaModelImpl(loader, annotationHelper) : new JavaModelImpl(loader);
        HashMap<String, Boolean> metadataComplete = new HashMap<String, Boolean>();
        for (String packageName : xmlBindings.keySet()) {
            if (!xmlBindings.get(packageName).isXmlMappingMetadataComplete()) continue;
            metadataComplete.put(packageName, true);
        }
        if (metadataComplete.size() > 0) {
            jModel.setMetadataCompletePackageMap(metadataComplete);
        }
        JavaModelInputImpl inputImpl = new JavaModelInputImpl(typesToBeBound, (JavaModel)jModel);
        try {
            Generator generator = new Generator(inputImpl, typesToBeBound, inputImpl.getJavaClasses(), null, xmlBindings, classLoader, defaultTargetNamespace);
            return JAXBContextFactory.createContext(generator, properties, classLoader, loader, typesToBeBound);
        }
        catch (Exception ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static JAXBContext createContext(Class[] classesToBeBound, Map properties, ClassLoader classLoader, Map<String, XmlBindings> xmlBindings) throws JAXBException {
        JaxbClassLoader loader = new JaxbClassLoader(classLoader, classesToBeBound);
        String defaultTargetNamespace = null;
        AnnotationHelper annotationHelper = null;
        if (properties != null) {
            defaultTargetNamespace = (String)properties.get(DEFAULT_TARGET_NAMESPACE_KEY);
            annotationHelper = (AnnotationHelper)properties.get(ANNOTATION_HELPER_KEY);
        }
        JavaModelImpl jModel = annotationHelper != null ? new JavaModelImpl(loader, annotationHelper) : new JavaModelImpl(loader);
        HashMap<String, Boolean> metadataComplete = new HashMap<String, Boolean>();
        for (String packageName : xmlBindings.keySet()) {
            if (!xmlBindings.get(packageName).isXmlMappingMetadataComplete()) continue;
            metadataComplete.put(packageName, true);
        }
        if (metadataComplete.size() > 0) {
            jModel.setMetadataCompletePackageMap(metadataComplete);
        }
        JavaModelInputImpl inputImpl = new JavaModelInputImpl(classesToBeBound, (JavaModel)jModel);
        try {
            Generator generator = new Generator(inputImpl, xmlBindings, loader, defaultTargetNamespace);
            return JAXBContextFactory.createContext(generator, properties, classLoader, loader, classesToBeBound);
        }
        catch (Exception ex) {
            throw new JAXBException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static JAXBContext createContext(Generator generator, Map properties, ClassLoader classLoader, JaxbClassLoader loader, Type[] typesToBeBound) throws Exception {
        Project proj = generator.generateProject();
        ConversionManager conversionManager = null;
        if (classLoader != null) {
            conversionManager = new ConversionManager();
            conversionManager.setLoader((ClassLoader)loader);
        } else {
            conversionManager = ConversionManager.getDefaultManager();
        }
        proj.convertClassNamesToClasses(conversionManager.getLoader());
        for (ClassDescriptor descriptor : proj.getOrderedDescriptors()) {
            if (descriptor.getJavaClass() != null) continue;
            descriptor.setJavaClass(conversionManager.convertClassNameToClass(descriptor.getJavaClassName()));
        }
        org.eclipse.persistence.internal.jaxb.SessionEventListener eventListener = new org.eclipse.persistence.internal.jaxb.SessionEventListener();
        eventListener.setShouldValidateInstantiationPolicy(false);
        SAXPlatform platform = new SAXPlatform();
        platform.getConversionManager().setLoader((ClassLoader)loader);
        XMLContext xmlContext = new XMLContext(proj, (ClassLoader)loader, (SessionEventListener)eventListener);
        if (generator.getAnnotationsProcessor().getPackageToPackageInfoMappings().size() > 1) {
            ((XMLLogin)xmlContext.getSession(0).getDatasourceLogin()).setEqualNamespaceResolvers(false);
        }
        return new JAXBContext(xmlContext, generator, typesToBeBound);
    }

    private static JAXBContext createContext(Generator generator, Map properties, ClassLoader classLoader, JaxbClassLoader loader, TypeMappingInfo[] typesToBeBound) throws Exception {
        Project proj = generator.generateProject();
        ConversionManager conversionManager = null;
        if (classLoader != null) {
            conversionManager = new ConversionManager();
            conversionManager.setLoader((ClassLoader)loader);
        } else {
            conversionManager = ConversionManager.getDefaultManager();
        }
        proj.convertClassNamesToClasses(conversionManager.getLoader());
        for (ClassDescriptor descriptor : proj.getOrderedDescriptors()) {
            if (descriptor.getJavaClass() != null) continue;
            descriptor.setJavaClass(conversionManager.convertClassNameToClass(descriptor.getJavaClassName()));
        }
        org.eclipse.persistence.internal.jaxb.SessionEventListener eventListener = new org.eclipse.persistence.internal.jaxb.SessionEventListener();
        eventListener.setShouldValidateInstantiationPolicy(false);
        SAXPlatform platform = new SAXPlatform();
        platform.getConversionManager().setLoader((ClassLoader)loader);
        XMLContext xmlContext = new XMLContext(proj, (ClassLoader)loader, (SessionEventListener)eventListener);
        if (generator.getAnnotationsProcessor().getPackageToPackageInfoMappings().size() > 1) {
            ((XMLLogin)xmlContext.getSession(0).getDatasourceLogin()).setEqualNamespaceResolvers(false);
        }
        return new JAXBContext(xmlContext, generator, typesToBeBound);
    }

    private static boolean isJAXB2ObjectFactory(Class objectFactoryClass) {
        try {
            Class xmlRegistry = PrivilegedAccessHelper.getClassForName((String)"javax.xml.bind.annotation.XmlRegistry");
            return objectFactoryClass.isAnnotationPresent(xmlRegistry);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static Map<String, XmlBindings> getXmlBindingsFromProperties(Map properties, ClassLoader classLoader) {
        Object value;
        Map<String, XmlBindings> bindings = new HashMap<String, XmlBindings>();
        if (properties != null && (value = properties.get(ECLIPSELINK_OXM_XML_KEY)) != null) {
            if (value instanceof Map) {
                Map metadataFiles = null;
                try {
                    metadataFiles = (Map)properties.get(ECLIPSELINK_OXM_XML_KEY);
                }
                catch (ClassCastException x) {
                    throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
                }
                if (metadataFiles != null) {
                    for (Map.Entry entry : metadataFiles.entrySet()) {
                        String key = null;
                        try {
                            key = (String)entry.getKey();
                            if (key == null) {
                                throw org.eclipse.persistence.exceptions.JAXBException.nullMapKey();
                            }
                        }
                        catch (ClassCastException cce) {
                            throw org.eclipse.persistence.exceptions.JAXBException.incorrectKeyParameterType();
                        }
                        Object metadataSource = entry.getValue();
                        if (metadataSource == null) {
                            throw org.eclipse.persistence.exceptions.JAXBException.nullMetadataSource((String)key);
                        }
                        XmlBindings binding = JAXBContextFactory.getXmlBindings(metadataSource, classLoader);
                        if (binding == null) continue;
                        bindings.put(key, binding);
                    }
                }
            } else if (value instanceof List) {
                for (Object metadataSource : (List)value) {
                    if (metadataSource == null) {
                        throw org.eclipse.persistence.exceptions.JAXBException.nullMetadataSource();
                    }
                    bindings = JAXBContextFactory.processBindingFile(bindings, metadataSource, classLoader);
                }
            } else {
                bindings = JAXBContextFactory.processBindingFile(bindings, value, classLoader);
            }
        }
        return bindings;
    }

    private static Map<String, XmlBindings> processBindingFile(Map<String, XmlBindings> originalBindings, Object bindingHandle, ClassLoader classLoader) {
        Map<String, XmlBindings> bindingMap = originalBindings;
        XmlBindings binding = JAXBContextFactory.getXmlBindings(bindingHandle, classLoader);
        if (binding != null) {
            String key = binding.getPackageName();
            if (key.equals("##default")) {
                throw org.eclipse.persistence.exceptions.JAXBException.packageNotSetForBindingException();
            }
            XmlBindings.JavaTypes jTypes = binding.getJavaTypes();
            if (jTypes != null) {
                for (JavaType javaType : jTypes.getJavaType()) {
                    String javaTypeName = javaType.getName();
                    if (javaTypeName.contains(key)) continue;
                    javaType.setName(key + PKG_SEPARATOR + javaTypeName);
                }
            }
            bindingMap.put(key, binding);
        }
        return bindingMap;
    }

    private static XmlBindings getXmlBindings(Object metadata, ClassLoader classLoader) {
        XmlBindings xmlBindings;
        block11: {
            xmlBindings = null;
            JAXBContext jaxbContext = CompilerHelper.getXmlBindingsModelContext();
            try {
                JAXBUnmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                if (metadata instanceof File) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((File)metadata);
                    break block11;
                }
                if (metadata instanceof InputSource) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((InputSource)metadata);
                    break block11;
                }
                if (metadata instanceof InputStream) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((InputStream)metadata);
                    break block11;
                }
                if (metadata instanceof Node) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((Node)metadata);
                    break block11;
                }
                if (metadata instanceof Reader) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((Reader)metadata);
                    break block11;
                }
                if (metadata instanceof Source) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((Source)metadata);
                    break block11;
                }
                if (metadata instanceof URL) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((URL)metadata);
                    break block11;
                }
                if (metadata instanceof XMLEventReader) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((XMLEventReader)metadata);
                    break block11;
                }
                if (metadata instanceof XMLStreamReader) {
                    xmlBindings = (XmlBindings)unmarshaller.unmarshal((XMLStreamReader)metadata);
                    break block11;
                }
                throw org.eclipse.persistence.exceptions.JAXBException.incorrectValueParameterTypeForOxmXmlKey();
            }
            catch (JAXBException jaxbEx) {
                throw org.eclipse.persistence.exceptions.JAXBException.couldNotUnmarshalMetadata((Exception)((Object)jaxbEx));
            }
        }
        return xmlBindings;
    }

    private static TypeMappingInfo[] getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, TypeMappingInfo[] existingTypes) {
        XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
        if (jTypes != null) {
            ArrayList existingClasses = new ArrayList(existingTypes.length);
            for (TypeMappingInfo typeMappingInfo : existingTypes) {
                Type type = typeMappingInfo.getType();
                if (type == null) {
                    throw org.eclipse.persistence.exceptions.JAXBException.nullTypeOnTypeMappingInfo((QName)typeMappingInfo.getXmlTagName());
                }
                if (!(type instanceof Class)) continue;
                Class cls = (Class)type;
                existingClasses.add(cls);
            }
            ArrayList<TypeMappingInfo> additionalTypeMappingInfos = new ArrayList<TypeMappingInfo>(jTypes.getJavaType().size());
            for (JavaType javaType : jTypes.getJavaType()) {
                try {
                    Class<?> nextClass = classLoader.loadClass(javaType.getName());
                    if (existingClasses.contains(nextClass)) continue;
                    TypeMappingInfo typeMappingInfo = new TypeMappingInfo();
                    typeMappingInfo.setType(nextClass);
                    additionalTypeMappingInfos.add(typeMappingInfo);
                    existingClasses.add(nextClass);
                }
                catch (ClassNotFoundException e) {
                    throw org.eclipse.persistence.exceptions.JAXBException.couldNotLoadClassFromMetadata((String)javaType.getName());
                }
            }
            TypeMappingInfo[] allTypeMappingInfos = new TypeMappingInfo[existingTypes.length + additionalTypeMappingInfos.size()];
            System.arraycopy(existingTypes, 0, allTypeMappingInfos, 0, existingTypes.length);
            Object[] additionalTypes = additionalTypeMappingInfos.toArray();
            System.arraycopy(additionalTypes, 0, allTypeMappingInfos, existingTypes.length, additionalTypes.length);
            return allTypeMappingInfos;
        }
        return existingTypes;
    }

    private static ArrayList<Class> getXmlBindingsClasses(XmlBindings xmlBindings, ClassLoader classLoader, ArrayList<Class> existingClasses) {
        ArrayList<Class> additionalClasses = existingClasses;
        XmlBindings.JavaTypes jTypes = xmlBindings.getJavaTypes();
        if (jTypes != null) {
            for (JavaType javaType : jTypes.getJavaType()) {
                try {
                    Class<?> jClass = classLoader.loadClass(javaType.getName());
                    if (additionalClasses.contains(jClass)) continue;
                    additionalClasses.add(jClass);
                }
                catch (ClassNotFoundException e) {
                    throw org.eclipse.persistence.exceptions.JAXBException.couldNotLoadClassFromMetadata((String)javaType.getName());
                }
            }
        }
        return additionalClasses;
    }

    private static ArrayList<Class> getXmlBindingsClassesFromMap(Map<String, XmlBindings> xmlBindingMap, ClassLoader classLoader, ArrayList<Class> existingClasses) {
        ArrayList<Class> additionalClasses = existingClasses;
        for (Map.Entry<String, XmlBindings> entry : xmlBindingMap.entrySet()) {
            additionalClasses = JAXBContextFactory.getXmlBindingsClasses(entry.getValue(), classLoader, additionalClasses);
        }
        return additionalClasses;
    }

    private static TypeMappingInfo[] updateTypesWithObjectFactory(TypeMappingInfo[] typeMappingInfos, ClassLoader loader) {
        ArrayList<TypeMappingInfo> updatedTypes = new ArrayList<TypeMappingInfo>();
        for (TypeMappingInfo next : typeMappingInfos) {
            Type theType;
            if (!updatedTypes.contains(next)) {
                updatedTypes.add(next);
            }
            if (!((theType = next.getType()) instanceof Class) || ((Class)theType).getPackage() == null) continue;
            String packageName = ((Class)theType).getPackage().getName();
            try {
                Class<?> objectFactoryClass = loader.loadClass(packageName + ".ObjectFactory");
                if (updatedTypes.contains(objectFactoryClass)) continue;
                TypeMappingInfo objectFactoryTypeMappingInfo = new TypeMappingInfo();
                objectFactoryTypeMappingInfo.setType(objectFactoryClass);
                updatedTypes.add(objectFactoryTypeMappingInfo);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return updatedTypes.toArray(new TypeMappingInfo[updatedTypes.size()]);
    }

    private static ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

