/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaConstructor;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaAnnotationImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaConstructorImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaFieldImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaMethodImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaModelImpl;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaPackageImpl;

public class JavaClassImpl
implements JavaClass {
    protected ParameterizedType jType;
    protected Class jClass;
    private JavaModelImpl javaModelImpl;

    public JavaClassImpl(Class javaClass, JavaModelImpl javaModelImpl) {
        this.jClass = javaClass;
        this.javaModelImpl = javaModelImpl;
    }

    public JavaClassImpl(ParameterizedType javaType, Class javaClass, JavaModelImpl javaModelImpl) {
        this.jType = javaType;
        this.jClass = javaClass;
        this.javaModelImpl = javaModelImpl;
    }

    public Collection getActualTypeArguments() {
        ArrayList<JavaClass> argCollection = new ArrayList<JavaClass>();
        if (this.jType instanceof ParameterizedType) {
            Type[] params;
            ParameterizedType pType = this.jType;
            for (Type type : params = pType.getActualTypeArguments()) {
                if (type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    argCollection.add(new JavaClassImpl(pt, (Class)pt.getRawType(), this.javaModelImpl));
                    continue;
                }
                if (type instanceof WildcardType) {
                    Type upperType;
                    Type[] upperTypes = ((WildcardType)type).getUpperBounds();
                    if (upperTypes.length <= 0 || !((upperType = upperTypes[0]) instanceof Class)) continue;
                    argCollection.add(this.javaModelImpl.getClass((Class)upperType));
                    continue;
                }
                if (type instanceof Class) {
                    argCollection.add(this.javaModelImpl.getClass((Class)type));
                    continue;
                }
                if (!(type instanceof GenericArrayType)) continue;
                Class<?> genericTypeClass = (Class<?>)((GenericArrayType)type).getGenericComponentType();
                genericTypeClass = Array.newInstance(genericTypeClass, 0).getClass();
                argCollection.add(this.javaModelImpl.getClass(genericTypeClass));
            }
        }
        return argCollection;
    }

    public String toString() {
        return this.getName();
    }

    public JavaAnnotation getAnnotation(JavaClass arg0) {
        Class annotationClass;
        if (arg0 != null && this.jClass.isAnnotationPresent(annotationClass = ((JavaClassImpl)arg0).getJavaClass())) {
            return new JavaAnnotationImpl((Annotation)this.jClass.getAnnotation(annotationClass));
        }
        return null;
    }

    public Collection getAnnotations() {
        Annotation[] annotations;
        ArrayList<JavaAnnotationImpl> annotationCollection = new ArrayList<JavaAnnotationImpl>();
        for (Annotation annotation : annotations = this.jClass.getAnnotations()) {
            annotationCollection.add(new JavaAnnotationImpl(annotation));
        }
        return annotationCollection;
    }

    public Collection getDeclaredClasses() {
        Class<?>[] classes;
        ArrayList<JavaClass> classCollection = new ArrayList<JavaClass>();
        for (Class<?> javaClass : classes = this.jClass.getDeclaredClasses()) {
            classCollection.add(this.javaModelImpl.getClass(javaClass));
        }
        return classCollection;
    }

    public JavaField getDeclaredField(String arg0) {
        try {
            return new JavaFieldImpl(this.jClass.getDeclaredField(arg0), this.javaModelImpl);
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
    }

    public Collection getDeclaredFields() {
        Field[] fields;
        ArrayList<JavaFieldImpl> fieldCollection = new ArrayList<JavaFieldImpl>();
        for (Field field : fields = PrivilegedAccessHelper.getDeclaredFields((Class)this.jClass)) {
            field.setAccessible(true);
            fieldCollection.add(new JavaFieldImpl(field, this.javaModelImpl));
        }
        return fieldCollection;
    }

    public JavaMethod getDeclaredMethod(String arg0, JavaClass[] arg1) {
        if (arg1 == null) {
            arg1 = new JavaClass[]{};
        }
        Class[] params = new Class[arg1.length];
        for (int i = 0; i < arg1.length; ++i) {
            JavaClass jType = arg1[i];
            if (jType == null) continue;
            params[i] = ((JavaClassImpl)jType).getJavaClass();
        }
        try {
            return new JavaMethodImpl(this.jClass.getDeclaredMethod(arg0, params), this.javaModelImpl);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    public Collection getDeclaredMethods() {
        Method[] methods;
        ArrayList<JavaMethodImpl> methodCollection = new ArrayList<JavaMethodImpl>();
        for (Method method : methods = this.jClass.getDeclaredMethods()) {
            methodCollection.add(new JavaMethodImpl(method, this.javaModelImpl));
        }
        return methodCollection;
    }

    public JavaConstructor getConstructor(JavaClass[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new JavaClass[]{};
        }
        Class[] params = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            JavaClass jType = paramTypes[i];
            if (jType == null) continue;
            params[i] = ((JavaClassImpl)jType).getJavaClass();
        }
        try {
            Constructor constructor = PrivilegedAccessHelper.getConstructorFor((Class)this.jClass, (Class[])params, (boolean)true);
            return new JavaConstructorImpl(constructor, this.javaModelImpl);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    public JavaConstructor getDeclaredConstructor(JavaClass[] paramTypes) {
        if (paramTypes == null) {
            paramTypes = new JavaClass[]{};
        }
        Class[] params = new Class[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            JavaClass jType = paramTypes[i];
            if (jType == null) continue;
            params[i] = ((JavaClassImpl)jType).getJavaClass();
        }
        try {
            return new JavaConstructorImpl(this.jClass.getDeclaredConstructor(params), this.javaModelImpl);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    public Collection getConstructors() {
        Constructor<?>[] constructors = this.jClass.getConstructors();
        ArrayList<JavaConstructorImpl> constructorCollection = new ArrayList<JavaConstructorImpl>(constructors.length);
        for (Constructor<?> next : constructors) {
            constructorCollection.add(new JavaConstructorImpl(next, this.javaModelImpl));
        }
        return constructorCollection;
    }

    public Collection getDeclaredConstructors() {
        Constructor<?>[] constructors = this.jClass.getDeclaredConstructors();
        ArrayList<JavaConstructorImpl> constructorCollection = new ArrayList<JavaConstructorImpl>(constructors.length);
        for (Constructor<?> next : constructors) {
            constructorCollection.add(new JavaConstructorImpl(next, this.javaModelImpl));
        }
        return constructorCollection;
    }

    public JavaField getField(String arg0) {
        try {
            Field field = PrivilegedAccessHelper.getField((Class)this.jClass, (String)arg0, (boolean)true);
            return new JavaFieldImpl(field, this.javaModelImpl);
        }
        catch (NoSuchFieldException nsfe) {
            return null;
        }
    }

    public Collection getFields() {
        Field[] fields;
        ArrayList<JavaFieldImpl> fieldCollection = new ArrayList<JavaFieldImpl>();
        for (Field field : fields = PrivilegedAccessHelper.getFields((Class)this.jClass)) {
            fieldCollection.add(new JavaFieldImpl(field, this.javaModelImpl));
        }
        return fieldCollection;
    }

    public Class getJavaClass() {
        return this.jClass;
    }

    public JavaMethod getMethod(String arg0, JavaClass[] arg1) {
        if (arg1 == null) {
            arg1 = new JavaClass[]{};
        }
        Class[] params = new Class[arg1.length];
        for (int i = 0; i < arg1.length; ++i) {
            JavaClass jType = arg1[i];
            if (jType == null) continue;
            params[i] = ((JavaClassImpl)jType).getJavaClass();
        }
        try {
            Method method = PrivilegedAccessHelper.getMethod((Class)this.jClass, (String)arg0, (Class[])params, (boolean)true);
            return new JavaMethodImpl(method, this.javaModelImpl);
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    public Collection getMethods() {
        Method[] methods;
        ArrayList<JavaMethodImpl> methodCollection = new ArrayList<JavaMethodImpl>();
        for (Method method : methods = PrivilegedAccessHelper.getMethods((Class)this.jClass)) {
            methodCollection.add(new JavaMethodImpl(method, this.javaModelImpl));
        }
        return methodCollection;
    }

    public String getName() {
        return this.jClass.getName();
    }

    public JavaPackage getPackage() {
        return new JavaPackageImpl(this.jClass.getPackage());
    }

    public String getPackageName() {
        int index;
        if (this.jClass.getPackage() != null) {
            return this.jClass.getPackage().getName();
        }
        String className = this.jClass.getCanonicalName();
        if (className != null && (index = className.lastIndexOf(".")) > -1) {
            return className.substring(0, index);
        }
        return null;
    }

    public String getQualifiedName() {
        return this.jClass.getName();
    }

    public String getRawName() {
        return this.jClass.getCanonicalName();
    }

    public JavaClass getSuperclass() {
        return this.javaModelImpl.getClass(this.jClass.getSuperclass());
    }

    public boolean hasActualTypeArguments() {
        ParameterizedType pType;
        return this.jType instanceof ParameterizedType && (pType = this.jType).getActualTypeArguments() != null && pType.getActualTypeArguments().length > 0;
    }

    public JavaClass getOwningClass() {
        return this.javaModelImpl.getClass(this.jClass.getEnclosingClass());
    }

    public boolean isAnnotation() {
        return this.jClass.isAnnotation();
    }

    public boolean isArray() {
        return this.jClass.isArray();
    }

    public boolean isAssignableFrom(JavaClass arg0) {
        return this.jClass.isAssignableFrom(((JavaClassImpl)arg0).getJavaClass());
    }

    public boolean isEnum() {
        return this.jClass.isEnum();
    }

    public boolean isInterface() {
        return this.jClass.isInterface();
    }

    public boolean isMemberClass() {
        return this.jClass.isMemberClass();
    }

    public boolean isPrimitive() {
        return this.jClass.isPrimitive();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public int getModifiers() {
        return this.jClass.getModifiers();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isSynthetic() {
        return this.jClass.isSynthetic();
    }

    public JavaClass getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return this.javaModelImpl.getClass(this.jClass.getComponentType());
    }

    public JavaAnnotation getDeclaredAnnotation(JavaClass arg0) {
        return null;
    }

    public Collection getDeclaredAnnotations() {
        return null;
    }
}

