/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.resolver.BaseDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.GenericDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ImportPackageSpecificationImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeDescriptionImpl;
import org.eclipse.osgi.internal.resolver.NativeCodeSpecificationImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateReader;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;

public final class BundleDescriptionImpl
extends BaseDescriptionImpl
implements BundleDescription,
KeyedElement {
    static final String[] EMPTY_STRING = new String[0];
    static final ImportPackageSpecification[] EMPTY_IMPORTS = new ImportPackageSpecification[0];
    static final BundleSpecification[] EMPTY_BUNDLESPECS = new BundleSpecification[0];
    static final ExportPackageDescription[] EMPTY_EXPORTS = new ExportPackageDescription[0];
    static final BundleDescription[] EMPTY_BUNDLEDESCS = new BundleDescription[0];
    static final GenericSpecification[] EMPTY_GENERICSPECS = new GenericSpecification[0];
    static final GenericDescription[] EMPTY_GENERICDESCS = new GenericDescription[0];
    static final int RESOLVED = 1;
    static final int SINGLETON = 2;
    static final int REMOVAL_PENDING = 4;
    static final int FULLY_LOADED = 8;
    static final int LAZY_LOADED = 16;
    static final int HAS_DYNAMICIMPORT = 32;
    static final int ATTACH_FRAGMENTS = 64;
    static final int DYNAMIC_FRAGMENTS = 128;
    private volatile int stateBits = 200;
    private volatile long bundleId = -1L;
    private volatile HostSpecification host;
    private volatile StateImpl containingState;
    private volatile Object userObject;
    private volatile int lazyDataOffset = -1;
    private volatile int lazyDataSize = -1;
    private ArrayList dependencies;
    private ArrayList dependents;
    private volatile LazyData lazyData;
    private volatile int equinox_ee = -1;

    public long getBundleId() {
        return this.bundleId;
    }

    public String getSymbolicName() {
        return this.getName();
    }

    public BundleDescription getSupplier() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLocation() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return currentData.location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPlatformFilter() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return currentData.platformFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getExecutionEnvironments() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.executionEnvironments == null) {
                return EMPTY_STRING;
            }
            return currentData.executionEnvironments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportPackageSpecification[] getImportPackages() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.importPackages == null) {
                return EMPTY_IMPORTS;
            }
            return currentData.importPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleSpecification[] getRequiredBundles() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.requiredBundles == null) {
                return EMPTY_BUNDLESPECS;
            }
            return currentData.requiredBundles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericSpecification[] getGenericRequires() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.genericRequires == null) {
                return EMPTY_GENERICSPECS;
            }
            return currentData.genericRequires;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDescription[] getGenericCapabilities() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.genericCapabilities == null) {
                return EMPTY_GENERICDESCS;
            }
            return currentData.genericCapabilities;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NativeCodeSpecification getNativeCodeSpecification() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return currentData.nativeCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportPackageDescription[] getExportPackages() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return currentData.exportPackages == null ? EMPTY_EXPORTS : currentData.exportPackages;
        }
    }

    public boolean isResolved() {
        return (this.stateBits & 1) != 0;
    }

    public State getContainingState() {
        return this.containingState;
    }

    public BundleDescription[] getFragments() {
        if (this.host != null) {
            return EMPTY_BUNDLEDESCS;
        }
        StateImpl currentState = (StateImpl)this.getContainingState();
        if (currentState == null) {
            throw new IllegalStateException("BundleDescription does not belong to a state.");
        }
        return currentState.getFragments(this);
    }

    public HostSpecification getHost() {
        return this.host;
    }

    public boolean isSingleton() {
        return (this.stateBits & 2) != 0;
    }

    public boolean isRemovalPending() {
        return (this.stateBits & 4) != 0;
    }

    public boolean hasDynamicImports() {
        return (this.stateBits & 0x20) != 0;
    }

    public boolean attachFragments() {
        return (this.stateBits & 0x40) != 0;
    }

    public boolean dynamicFragments() {
        return (this.stateBits & 0x80) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportPackageDescription[] getSelectedExports() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.selectedExports == null) {
                return EMPTY_EXPORTS;
            }
            return currentData.selectedExports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportPackageDescription[] getSubstitutedExports() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.substitutedExports == null) {
                return EMPTY_EXPORTS;
            }
            return currentData.substitutedExports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDescription[] getResolvedRequires() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.resolvedRequires == null) {
                return EMPTY_BUNDLEDESCS;
            }
            return currentData.resolvedRequires;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportPackageDescription[] getResolvedImports() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            if (currentData.resolvedImports == null) {
                return EMPTY_EXPORTS;
            }
            return currentData.resolvedImports;
        }
    }

    protected void setBundleId(long bundleId) {
        this.bundleId = bundleId;
    }

    protected void setSymbolicName(String symbolicName) {
        this.setName(symbolicName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLocation(String location) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.location = location;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPlatformFilter(String platformFilter) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.platformFilter = platformFilter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExecutionEnvironments(String[] executionEnvironments) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.executionEnvironments = executionEnvironments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExportPackages(ExportPackageDescription[] exportPackages) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.exportPackages = exportPackages;
            if (exportPackages != null) {
                int i = 0;
                while (i < exportPackages.length) {
                    ((ExportPackageDescriptionImpl)exportPackages[i]).setExporter(this);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setImportPackages(ImportPackageSpecification[] importPackages) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.importPackages = importPackages;
            if (importPackages != null) {
                int i = 0;
                while (i < importPackages.length) {
                    ((ImportPackageSpecificationImpl)importPackages[i]).setBundle(this);
                    if ("dynamic".equals(importPackages[i].getDirective("resolution"))) {
                        this.stateBits |= 0x20;
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRequiredBundles(BundleSpecification[] requiredBundles) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.requiredBundles = requiredBundles;
            if (requiredBundles != null) {
                int i = 0;
                while (i < requiredBundles.length) {
                    ((VersionConstraintImpl)((Object)requiredBundles[i])).setBundle(this);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGenericCapabilities(GenericDescription[] genericCapabilities) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.genericCapabilities = genericCapabilities;
            if (genericCapabilities != null) {
                int i = 0;
                while (i < genericCapabilities.length) {
                    ((GenericDescriptionImpl)genericCapabilities[i]).setSupplier(this);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setGenericRequires(GenericSpecification[] genericRequires) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.genericRequires = genericRequires;
            if (genericRequires != null) {
                int i = 0;
                while (i < genericRequires.length) {
                    ((VersionConstraintImpl)((Object)genericRequires[i])).setBundle(this);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNativeCodeSpecification(NativeCodeSpecification nativeCode) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.nativeCode = nativeCode;
            if (nativeCode != null) {
                ((NativeCodeSpecificationImpl)nativeCode).setBundle(this);
                NativeCodeDescription[] suppliers = nativeCode.getPossibleSuppliers();
                if (suppliers != null) {
                    int i = 0;
                    while (i < suppliers.length) {
                        ((NativeCodeDescriptionImpl)suppliers[i]).setSupplier(this);
                        ++i;
                    }
                }
            }
        }
    }

    protected int getStateBits() {
        return this.stateBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setStateBit(int stateBit, boolean on) {
        Object object = this.monitor;
        synchronized (object) {
            this.stateBits = on ? (this.stateBits |= stateBit) : (this.stateBits &= ~stateBit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContainingState(State value) {
        Object object = this.monitor;
        synchronized (object) {
            this.containingState = (StateImpl)value;
            this.stateBits = this.containingState != null && this.containingState.getReader() != null ? (this.containingState.getReader().isLazyLoaded() ? (this.stateBits |= 0x10) : (this.stateBits &= 0xFFFFFFEF)) : (this.stateBits &= 0xFFFFFFEF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setHost(HostSpecification host) {
        Object object = this.monitor;
        synchronized (object) {
            this.host = host;
            if (host != null) {
                ((VersionConstraintImpl)((Object)host)).setBundle(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLazyLoaded(boolean lazyLoad) {
        this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            this.stateBits = lazyLoad ? (this.stateBits |= 0x10) : (this.stateBits &= 0xFFFFFFEF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSelectedExports(ExportPackageDescription[] selectedExports) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.selectedExports = selectedExports;
            if (selectedExports != null) {
                int i = 0;
                while (i < selectedExports.length) {
                    ((ExportPackageDescriptionImpl)selectedExports[i]).setExporter(this);
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSubstitutedExports(ExportPackageDescription[] substitutedExports) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.substitutedExports = substitutedExports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResolvedImports(ExportPackageDescription[] resolvedImports) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.resolvedImports = resolvedImports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResolvedRequires(BundleDescription[] resolvedRequires) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.resolvedRequires = resolvedRequires;
        }
    }

    public String toString() {
        if (this.getSymbolicName() == null) {
            return "[" + this.getBundleId() + "]";
        }
        return String.valueOf(this.getSymbolicName()) + "_" + this.getVersion();
    }

    public Object getKey() {
        return new Long(this.bundleId);
    }

    public boolean compare(KeyedElement other) {
        if (!(other instanceof BundleDescriptionImpl)) {
            return false;
        }
        BundleDescriptionImpl otherBundleDescription = (BundleDescriptionImpl)other;
        return this.bundleId == otherBundleDescription.bundleId;
    }

    public int getKeyHashCode() {
        return (int)(this.bundleId ^ this.bundleId >>> 32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDependencies() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependencies == null) {
                return;
            }
            Iterator iter = this.dependencies.iterator();
            while (iter.hasNext()) {
                ((BundleDescriptionImpl)iter.next()).removeDependent(this);
            }
            this.dependencies = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDependencies(BaseDescription[] newDependencies, boolean checkDups) {
        Object object = this.monitor;
        synchronized (object) {
            if (newDependencies == null) {
                return;
            }
            if (!checkDups && this.dependencies == null) {
                this.dependencies = new ArrayList(newDependencies.length);
            }
            int i = 0;
            while (i < newDependencies.length) {
                this.addDependency((BaseDescriptionImpl)newDependencies[i], checkDups);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDependency(BaseDescriptionImpl dependency, boolean checkDups) {
        Object object = this.monitor;
        synchronized (object) {
            BundleDescriptionImpl bundle = (BundleDescriptionImpl)dependency.getSupplier();
            if (bundle == this) {
                return;
            }
            if (this.dependencies == null) {
                this.dependencies = new ArrayList(10);
            }
            if (!checkDups || !this.dependencies.contains(bundle)) {
                bundle.addDependent(this);
                this.dependencies.add(bundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List getBundleDependencies() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependencies == null) {
                return new ArrayList(0);
            }
            ArrayList required = new ArrayList(this.dependencies.size());
            Iterator iter = this.dependencies.iterator();
            while (iter.hasNext()) {
                Object dep = iter.next();
                if (dep == this || !(dep instanceof BundleDescription) || ((BundleDescription)dep).getHost() != null) continue;
                required.add(dep);
            }
            return required;
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDependent(BundleDescription dependent) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependents == null) {
                this.dependents = new ArrayList(10);
            }
            this.dependents.add(dependent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDependent(BundleDescription dependent) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependents == null) {
                return;
            }
            this.dependents.remove(dependent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDescription[] getDependents() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.dependents == null) {
                return EMPTY_BUNDLEDESCS;
            }
            return this.dependents.toArray(new BundleDescription[this.dependents.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFullyLoaded(boolean fullyLoaded) {
        Object object = this.monitor;
        synchronized (object) {
            this.stateBits = fullyLoaded ? (this.stateBits |= 8) : (this.stateBits &= 0xFFFFFFF7);
        }
    }

    boolean isFullyLoaded() {
        return (this.stateBits & 8) != 0;
    }

    void setLazyDataOffset(int lazyDataOffset) {
        this.lazyDataOffset = lazyDataOffset;
    }

    int getLazyDataOffset() {
        return this.lazyDataOffset;
    }

    void setLazyDataSize(int lazyDataSize) {
        this.lazyDataSize = lazyDataSize;
    }

    int getLazyDataSize() {
        return this.lazyDataSize;
    }

    private LazyData loadLazyData() {
        StateReader reader;
        if ((this.stateBits & 0x10) == 0) {
            return this.lazyData;
        }
        StateImpl currentState = (StateImpl)this.getContainingState();
        StateReader stateReader = reader = currentState == null ? null : currentState.getReader();
        if (reader == null) {
            throw new IllegalStateException("No valid reader for the bundle description");
        }
        StateReader stateReader2 = reader;
        synchronized (stateReader2) {
            if (this.isFullyLoaded()) {
                reader.setAccessedFlag(true);
                return this.lazyData;
            }
            try {
                reader.fullyLoad(this);
                return this.lazyData;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDynamicResolvedImport(ExportPackageDescriptionImpl result) {
        Object object = this.monitor;
        synchronized (object) {
            this.addDependency(result, true);
            this.checkLazyData();
            if (this.lazyData.resolvedImports == null) {
                this.lazyData.resolvedImports = new ExportPackageDescription[]{result};
                return;
            }
            ExportPackageDescription[] newImports = new ExportPackageDescription[this.lazyData.resolvedImports.length + 1];
            System.arraycopy(this.lazyData.resolvedImports, 0, newImports, 0, this.lazyData.resolvedImports.length);
            newImports[newImports.length - 1] = result;
            this.lazyData.resolvedImports = newImports;
        }
        this.setLazyLoaded(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unload() {
        StateReader reader;
        StateImpl currentState = (StateImpl)this.getContainingState();
        StateReader stateReader = reader = currentState == null ? null : currentState.getReader();
        if (reader == null) {
            throw new IllegalStateException("BundleDescription does not belong to a reader.");
        }
        StateReader stateReader2 = reader;
        synchronized (stateReader2) {
            if ((this.stateBits & 0x10) == 0) {
                return;
            }
            if (!this.isFullyLoaded()) {
                return;
            }
            Object object = this.monitor;
            synchronized (object) {
                this.setFullyLoaded(false);
                this.lazyData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDynamicStamps(HashMap dynamicStamps) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            this.lazyData.dynamicStamps = dynamicStamps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDynamicStamp(String requestedPackage, Long timestamp) {
        Object object = this.monitor;
        synchronized (object) {
            this.checkLazyData();
            if (this.lazyData.dynamicStamps == null) {
                if (timestamp == null) {
                    return;
                }
                this.lazyData.dynamicStamps = new HashMap();
            }
            if (timestamp == null) {
                this.lazyData.dynamicStamps.remove(requestedPackage);
            } else {
                this.lazyData.dynamicStamps.put(requestedPackage, timestamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getDynamicStamp(String requestedPackage) {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            Long stamp = currentData.dynamicStamps == null ? null : (Long)currentData.dynamicStamps.get(requestedPackage);
            return stamp == null ? 0L : stamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HashMap getDynamicStamps() {
        LazyData currentData = this.loadLazyData();
        Object object = this.monitor;
        synchronized (object) {
            return currentData.dynamicStamps;
        }
    }

    public void setEquinoxEE(int equinox_ee) {
        this.equinox_ee = equinox_ee;
    }

    public int getEquinoxEE() {
        return this.equinox_ee;
    }

    private void checkLazyData() {
        if (this.lazyData == null) {
            this.lazyData = new LazyData();
        }
    }

    private final class LazyData {
        String location;
        String platformFilter;
        BundleSpecification[] requiredBundles;
        ExportPackageDescription[] exportPackages;
        ImportPackageSpecification[] importPackages;
        GenericDescription[] genericCapabilities;
        GenericSpecification[] genericRequires;
        NativeCodeSpecification nativeCode;
        ExportPackageDescription[] selectedExports;
        BundleDescription[] resolvedRequires;
        ExportPackageDescription[] resolvedImports;
        ExportPackageDescription[] substitutedExports;
        String[] executionEnvironments;
        HashMap dynamicStamps;

        private LazyData() {
        }
    }
}

