/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class TableViewerTab
extends ExampleTab {
    private static final int ADD_ITEMS = 300;
    private static final int FIRST_NAME = 0;
    private static final int LAST_NAME = 1;
    private static final int AGE = 2;
    private static final int EDITABLE = 3;
    private static final String[] LAST_NAMES = new String[]{"H\u00f6vl&lt;_'><'&amp;", "Panther", "Marx", "Loren", "Cool", "Einstein", "Duck", "Mouse", "", "Presley"};
    private TableViewer viewer;
    private TableViewerColumn firstNameColumn;
    private TableViewerColumn lastNameColumn;
    private TableViewerColumn ageColumn;
    private TableViewerColumn editableColumn;
    private Label lblSelection;
    private Button btnCreateCellEditor;
    private final PersonFilter viewerFilter;
    private final PersonLabelProvider labelProvider;
    private final List persons = new ArrayList();

    public TableViewerTab(CTabFolder topFolder) {
        super(topFolder, "TableViewer");
        this.viewerFilter = new PersonFilter();
        this.labelProvider = new PersonLabelProvider();
    }

    private void initPersons() {
        this.persons.clear();
        this.persons.add(new Person("R\u00f6gn\"\u00edy&", LAST_NAMES[0], 1, false));
        this.persons.add(new Person("Paul", LAST_NAMES[1], 1, false));
        this.persons.add(new Person("Karl", LAST_NAMES[2], 2, false));
        this.persons.add(new Person("Sofia", LAST_NAMES[3], 3, true));
        this.persons.add(new Person("King", LAST_NAMES[4], 4, false));
        this.persons.add(new Person("Albert", LAST_NAMES[5], 5, true));
        this.persons.add(new Person("Donald", LAST_NAMES[6], 6, false));
        this.persons.add(new Person("Mickey", LAST_NAMES[7], 7, true));
        this.persons.add(new Person("Asterix", LAST_NAMES[8], 8, false));
        this.persons.add(new Person("Nero", LAST_NAMES[8], 9, false));
        this.persons.add(new Person("Elvis", LAST_NAMES[9], 10, true));
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("MULTI", 2);
        this.createStyleButton("VIRTUAL", 0x10000000);
        this.createAddItemsButton();
        this.createSelectYoungestPersonButton();
        this.createRemoveButton();
        this.createCellEditorButton();
        this.lblSelection = new Label(this.styleComp, 0);
    }

    protected void createExampleControls(Composite parent) {
        if (this.btnCreateCellEditor != null && !this.btnCreateCellEditor.isDisposed()) {
            this.btnCreateCellEditor.setEnabled(true);
        }
        parent.setLayout((Layout)new GridLayout(2, false));
        Label lblFilter = new Label(parent, 0);
        lblFilter.setText("Filter");
        lblFilter.setEnabled((this.getStyle() & 0x10000000) == 0);
        Text txtFilter = new Text(parent, 2048);
        txtFilter.setEnabled((this.getStyle() & 0x10000000) == 0);
        GridDataFactory gridDataFactory = GridDataFactory.swtDefaults();
        gridDataFactory.grab(true, false);
        gridDataFactory.align(4, 0x1000000);
        gridDataFactory.applyTo((Control)txtFilter);
        txtFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.widget;
                TableViewerTab.this.viewerFilter.setText(text.getText());
                TableViewerTab.this.viewer.refresh();
            }
        });
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().dispose();
        }
        this.initPersons();
        this.viewer = new TableViewer(parent, this.getStyle());
        this.viewer.setUseHashlookup(true);
        if ((this.getStyle() & 0x10000000) == 0) {
            this.viewer.setContentProvider((IContentProvider)new PersonContentProvider());
        } else {
            this.viewer.setContentProvider((IContentProvider)new LazyPersonContentProvider());
        }
        this.viewer.setLabelProvider((IBaseLabelProvider)new PersonLabelProvider());
        this.firstNameColumn = this.createFirstNameColumn();
        this.lastNameColumn = this.createLastNameColumn();
        this.ageColumn = this.createAgeColumn();
        this.editableColumn = this.createEditableColumn();
        this.viewer.setInput((Object)this.persons);
        this.viewer.setItemCount(this.persons.size());
        this.viewer.addFilter((ViewerFilter)this.viewerFilter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableViewerTab.this.lblSelection.setText("Selection: " + event.getSelection());
                TableViewerTab.this.lblSelection.getParent().layout(new Control[]{TableViewerTab.this.lblSelection});
            }
        });
        this.viewer.getTable().setHeaderVisible(true);
        gridDataFactory = GridDataFactory.swtDefaults();
        gridDataFactory.grab(true, true);
        gridDataFactory.align(4, 4);
        gridDataFactory.span(2, -1);
        gridDataFactory.applyTo((Control)this.viewer.getTable());
        this.registerControl(this.viewer.getControl());
    }

    private TableViewerColumn createFirstNameColumn() {
        TableViewerColumn result = new TableViewerColumn(this.viewer, 0);
        result.setLabelProvider((CellLabelProvider)this.labelProvider);
        TableColumn column = result.getColumn();
        column.setText("First Name");
        column.setWidth(170);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sortDirection = TableViewerTab.updateSortDirection((TableColumn)event.widget);
                TableViewerTab.sort(TableViewerTab.this.viewer, 0, sortDirection == 1024);
            }
        });
        return result;
    }

    private TableViewerColumn createLastNameColumn() {
        TableViewerColumn result = new TableViewerColumn(this.viewer, 0);
        result.setLabelProvider((CellLabelProvider)this.labelProvider);
        TableColumn column = result.getColumn();
        column.setText("Last Name");
        column.setWidth(120);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sortDirection = TableViewerTab.updateSortDirection((TableColumn)event.widget);
                TableViewerTab.sort(TableViewerTab.this.viewer, 1, sortDirection == 1024);
            }
        });
        return result;
    }

    private TableViewerColumn createAgeColumn() {
        TableViewerColumn result = new TableViewerColumn(this.viewer, 0);
        result.setLabelProvider((CellLabelProvider)this.labelProvider);
        TableColumn column = result.getColumn();
        column.setText("Age");
        column.setWidth(80);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sortDirection = TableViewerTab.updateSortDirection((TableColumn)event.widget);
                TableViewerTab.sort(TableViewerTab.this.viewer, 2, sortDirection == 1024);
            }
        });
        return result;
    }

    private TableViewerColumn createEditableColumn() {
        TableViewerColumn result = new TableViewerColumn(this.viewer, 0);
        result.setLabelProvider((CellLabelProvider)this.labelProvider);
        TableColumn column = result.getColumn();
        column.setText("Editable");
        column.setWidth(50);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sortDirection = TableViewerTab.updateSortDirection((TableColumn)event.widget);
                TableViewerTab.sort(TableViewerTab.this.viewer, 3, sortDirection == 1024);
            }
        });
        return result;
    }

    private void addPerson() {
        int maxAge = 0;
        int i = 0;
        while (i < this.persons.size()) {
            Person person = (Person)this.persons.get(i);
            if (person.age > maxAge) {
                maxAge = person.age;
            }
            ++i;
        }
        this.persons.add(new Person("new", "person", maxAge + 1, false));
    }

    private void createAddItemsButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Add 300 Items");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int i = 0;
                while (i < 300) {
                    TableViewerTab.this.addPerson();
                    ++i;
                }
                TableViewerTab.this.getViewer().setInput((Object)TableViewerTab.this.persons);
                if ((TableViewerTab.this.getStyle() & 0x10000000) != 0) {
                    TableViewerTab.this.getViewer().setItemCount(TableViewerTab.this.persons.size());
                }
            }
        });
    }

    private void createSelectYoungestPersonButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Select youngest Person");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Person youngestPerson = null;
                int minAge = Integer.MAX_VALUE;
                int i = 0;
                while (i < TableViewerTab.this.persons.size()) {
                    Person person = (Person)TableViewerTab.this.persons.get(i);
                    if (person.age < minAge) {
                        minAge = person.age;
                        youngestPerson = person;
                    }
                    ++i;
                }
                TableViewerTab.this.getViewer().setSelection((ISelection)new StructuredSelection(youngestPerson));
                TableViewerTab.this.getViewer().reveal(youngestPerson);
            }
        });
    }

    private void createRemoveButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Remove selected rows");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)TableViewerTab.this.getViewer().getSelection();
                Iterator iter = selection.iterator();
                while (iter.hasNext()) {
                    Person person = (Person)iter.next();
                    TableViewerTab.this.persons.remove(person);
                }
                TableViewerTab.this.getViewer().getTable().setTopIndex(0);
                if ((TableViewerTab.this.getViewer().getTable().getStyle() & 0x10000000) != 0) {
                    TableViewerTab.this.getViewer().setItemCount(TableViewerTab.this.persons.size());
                }
                TableViewerTab.this.getViewer().setInput((Object)TableViewerTab.this.persons);
            }
        });
    }

    private void createCellEditorButton() {
        this.btnCreateCellEditor = new Button(this.styleComp, 8);
        this.btnCreateCellEditor.setText("Create Cell Editor");
        this.btnCreateCellEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableViewerTab.this.createCellEditor();
                TableViewerTab.this.btnCreateCellEditor.setEnabled(false);
            }
        });
    }

    private void createCellEditor() {
        EditingSupport editingSupport = new FirstNameEditingSupport(this.viewer);
        this.firstNameColumn.setEditingSupport(editingSupport);
        editingSupport = new LastNameEditingSupport(this.viewer);
        this.lastNameColumn.setEditingSupport(editingSupport);
        editingSupport = new AgeEditingSupport(this.viewer);
        this.ageColumn.setEditingSupport(editingSupport);
        editingSupport = new EditableEditingSupport((ColumnViewer)this.viewer);
        this.editableColumn.setEditingSupport(editingSupport);
        EditorActivationStrategy activationStrategy = new EditorActivationStrategy((ColumnViewer)this.viewer);
        FocusCellOwnerDrawHighlighter highlighter = new FocusCellOwnerDrawHighlighter((ColumnViewer)this.viewer);
        TableViewerFocusCellManager focusManager = new TableViewerFocusCellManager(this.viewer, (FocusCellHighlighter)highlighter);
        int feature = 18;
        TableViewerEditor.create((TableViewer)this.viewer, (SWTFocusCellManager)focusManager, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)feature);
    }

    private static int updateSortDirection(TableColumn column) {
        Table table = column.getParent();
        if (column == table.getSortColumn()) {
            if (table.getSortDirection() == 128) {
                table.setSortDirection(1024);
            } else {
                table.setSortDirection(128);
            }
        } else {
            table.setSortColumn(column);
            table.setSortDirection(1024);
        }
        return table.getSortDirection();
    }

    private static void sort(TableViewer viewer, int property, boolean ascending) {
        if ((viewer.getControl().getStyle() & 0x10000000) != 0) {
            List input = (List)viewer.getInput();
            Collections.sort(input, new PersonComparator(property, ascending));
            viewer.refresh();
        } else {
            viewer.setComparator((ViewerComparator)new PersonComparator(property, ascending));
        }
    }

    private TableViewer getViewer() {
        return this.viewer;
    }

    private static final class AgeEditingSupport
    extends EditingSupport {
        private final CellEditor editor;

        public AgeEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.editor = new TextCellEditor((Composite)viewer.getTable());
            this.editor.setValidator(new ICellEditorValidator(this){
                final /* synthetic */ AgeEditingSupport this$1;
                {
                    this.this$1 = ageEditingSupport;
                }

                public String isValid(Object value) {
                    String result = null;
                    try {
                        Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String text = "''{0}'' is not a valid age.";
                        result = MessageFormat.format(text, value);
                    }
                    return result;
                }
            });
        }

        protected boolean canEdit(Object element) {
            Person person = (Person)element;
            return person.editable;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            Person person = (Person)element;
            return String.valueOf(person.age);
        }

        protected void setValue(Object element, Object value) {
            if (value != null) {
                Person person = (Person)element;
                person.age = Integer.parseInt((String)value);
                this.getViewer().update(element, null);
            }
        }
    }

    private static final class EditableEditingSupport
    extends EditingSupport {
        private final CheckboxCellEditor editor = new CheckboxCellEditor();

        public EditableEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            Person person = (Person)element;
            return person.editable;
        }

        protected void setValue(Object element, Object value) {
            Person person = (Person)element;
            person.editable = (Boolean)value;
            this.getViewer().update(element, null);
        }
    }

    private static final class EditorActivationStrategy
    extends ColumnViewerEditorActivationStrategy {
        private EditorActivationStrategy(ColumnViewer viewer) {
            super(viewer);
            this.setEnableEditorActivationWithKeyboard(true);
        }

        protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
            boolean result = event.character == '\r' ? true : super.isEditorActivationEvent(event);
            return result;
        }
    }

    private static final class FirstNameEditingSupport
    extends EditingSupport {
        private final CellEditor editor;

        public FirstNameEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.editor = new TextCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            Person person = (Person)element;
            return person.editable;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            Person person = (Person)element;
            String result = person.firstName;
            return result;
        }

        protected void setValue(Object element, Object value) {
            Person person = (Person)element;
            person.firstName = (String)value;
            this.getViewer().update(element, null);
        }
    }

    private static final class LastNameEditingSupport
    extends EditingSupport {
        private final CellEditor editor;

        public LastNameEditingSupport(TableViewer viewer) {
            super((ColumnViewer)viewer);
            this.editor = new ComboBoxCellEditor((Composite)viewer.getTable(), LAST_NAMES, 8);
        }

        protected boolean canEdit(Object element) {
            Person person = (Person)element;
            return person.editable;
        }

        protected CellEditor getCellEditor(Object element) {
            return this.editor;
        }

        protected Object getValue(Object element) {
            Person person = (Person)element;
            Integer result = new Integer(0);
            int i = 0;
            while (i < LAST_NAMES.length) {
                if (LAST_NAMES[i].equals(person.lastName)) {
                    result = new Integer(i);
                }
                ++i;
            }
            return result;
        }

        protected void setValue(Object element, Object value) {
            Person person = (Person)element;
            person.lastName = LAST_NAMES[(Integer)value];
            this.getViewer().update(element, null);
        }
    }

    private static final class LazyPersonContentProvider
    implements ILazyContentProvider {
        private TableViewer tableViewer;
        private List elements;

        private LazyPersonContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.tableViewer = (TableViewer)viewer;
            this.elements = (List)newInput;
        }

        public void updateElement(int index) {
            this.tableViewer.replace(this.elements.get(index), index);
        }

        public void dispose() {
        }
    }

    private static final class Person {
        String firstName;
        String lastName;
        int age;
        boolean editable;

        public Person(String firstName, String lastName, int age, boolean editable) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
            this.editable = editable;
        }

        public String toString() {
            return String.valueOf(this.firstName) + " " + this.lastName + " " + this.age;
        }
    }

    private static final class PersonComparator
    extends ViewerComparator
    implements Comparator {
        private final boolean ascending;
        private final int property;

        public PersonComparator(int property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        public int compare(Viewer viewer, Object object1, Object object2) {
            return this.compare(object1, object2);
        }

        public boolean isSorterProperty(Object elem, String property) {
            return true;
        }

        public int compare(Object object1, Object object2) {
            Person person1 = (Person)object1;
            Person person2 = (Person)object2;
            int result = 0;
            if (this.property == 0) {
                result = person1.firstName.compareTo(person2.firstName);
            } else if (this.property == 1) {
                result = person1.lastName.compareTo(person2.lastName);
            } else if (this.property == 2) {
                result = person1.age - person2.age;
            } else if (this.property == 3) {
                if (person1.editable && !person2.editable) {
                    result = -1;
                } else if (!person1.editable && person2.editable) {
                    result = 1;
                }
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }
    }

    private static final class PersonContentProvider
    implements IStructuredContentProvider {
        Object[] elements;

        private PersonContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.elements = new Object[0];
            } else {
                List personList = (List)newInput;
                this.elements = personList.toArray();
            }
        }

        public void dispose() {
        }
    }

    private static final class PersonFilter
    extends ViewerFilter {
        private String text;

        private PersonFilter() {
        }

        public void setText(String string) {
            this.text = string;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean result = true;
            Person person = (Person)element;
            if (this.text != null && this.text.length() > 0) {
                String personText = person.toString().toLowerCase();
                result = personText.indexOf(this.text.toLowerCase()) != -1;
            }
            return result;
        }

        public boolean isFilterProperty(Object element, String prop) {
            return true;
        }
    }

    private static final class PersonLabelProvider
    extends CellLabelProvider {
        private PersonLabelProvider() {
        }

        public void update(ViewerCell cell) {
            Person person = (Person)cell.getElement();
            int columnIndex = cell.getColumnIndex();
            switch (columnIndex) {
                case 0: {
                    cell.setText(person.firstName);
                    break;
                }
                case 1: {
                    cell.setText(person.lastName);
                    break;
                }
                case 2: {
                    cell.setText(String.valueOf(person.age));
                    break;
                }
                case 3: {
                    cell.setText(person.editable ? "yes" : "no");
                }
            }
        }
    }
}

