/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LinkTab
extends ExampleTab {
    private Link customLink;

    public LinkTab(CTabFolder topFolder) {
        super(topFolder, "Link");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        this.createCustomLinkControl(parent);
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        int style = this.getStyle();
        Link link1 = new Link(parent, style);
        link1.setText("Lorem <a>ipsum</a> dolor <a>sit amet</a>");
        Link link2 = new Link(parent, style);
        link2.setText("Link without href");
        Link link3 = new Link(parent, style);
        link3.setText("<a>Link with one href</a>");
        this.customLink = new Link(parent, style);
        this.customLink.setText("Custom link, use controls to your right to change");
        this.customLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String msg = "Link widget selected, text=" + event.text;
                MessageDialog.openInformation((Shell)LinkTab.this.getShell(), (String)"Information", (String)msg);
            }
        });
        this.registerControl((Control)link1);
        this.registerControl((Control)link2);
        this.registerControl((Control)link3);
        this.registerControl((Control)this.customLink);
    }

    private void createCustomLinkControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblText = new Label(composite, 0);
        lblText.setText("Text");
        final Text txtText = new Text(composite, 2048);
        Button btnChange = new Button(composite, 8);
        btnChange.setText("Change");
        btnChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LinkTab.this.customLink.setText(txtText.getText());
            }
        });
    }
}

