/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.Iterator;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class CTabFolderTab
extends ExampleTab {
    private CTabFolder folder;
    private boolean unselectedCloseVisible;
    private boolean showTopRightControl;
    private boolean minVisible;
    private boolean maxVisible;
    private int selFgIndex;
    private int selBgIndex;
    private int tabHeight = -1;

    public CTabFolderTab(CTabFolder parent) {
        super(parent, "CTabFolder");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("FLAT", 0x800000);
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("TOP", 128);
        this.createStyleButton("BOTTOM", 1024);
        this.createStyleButton("CLOSE", 64);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFontChooser();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createSelectionFgColorButton();
        this.createSelectionBgColorButton();
        this.createBgImageButton();
        this.createTabHeightControl(this.styleComp);
        this.createTopRightControl(this.styleComp);
        int i = 0;
        while (i < 3) {
            final int index = i++;
            String rbText = "Select " + this.folder.getItem(index).getText();
            Button rbSelectTab = this.createPropertyButton(rbText, 16);
            rbSelectTab.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Button radio = (Button)event.getSource();
                    if (radio.getSelection()) {
                        CTabFolderTab.this.folder.setSelection(index);
                    }
                }
            });
        }
        final Button cbMin = this.createPropertyButton("Minimize visible", 32);
        cbMin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.minVisible = cbMin.getSelection();
                CTabFolderTab.this.updateProperties();
            }
        });
        final Button cbMax = this.createPropertyButton("Maximize visible", 32);
        cbMax.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.maxVisible = cbMax.getSelection();
                CTabFolderTab.this.updateProperties();
            }
        });
        String text = "UnselectedCloseVisible";
        Button cbUnselectedCloseVisible = this.createPropertyButton(text, 32);
        cbUnselectedCloseVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                CTabFolderTab.this.unselectedCloseVisible = button.getSelection();
                CTabFolderTab.this.updateProperties();
            }
        });
        text = "Switch tabPosition";
        Button btnSwitchTabPosition = this.createPropertyButton(text, 8);
        btnSwitchTabPosition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean isTop = CTabFolderTab.this.folder.getTabPosition() == 128;
                CTabFolderTab.this.folder.setTabPosition(isTop ? 1024 : 128);
            }
        });
        Button borderVisibleButton = this.createPropertyButton("Switch borderVisible", 8);
        borderVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.folder.setBorderVisible(!CTabFolderTab.this.folder.getBorderVisible());
            }
        });
        Button btnAddTabItem = new Button(parent, 8);
        btnAddTabItem.setText("Add Item (SWT.NONE)");
        btnAddTabItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.createTabItem(0);
            }
        });
        Button btnAddCloseableTabItem = new Button(parent, 8);
        btnAddCloseableTabItem.setText("Add Item (SWT.CLOSE)");
        btnAddCloseableTabItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.createTabItem(64);
            }
        });
    }

    protected void createExampleControls(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        parent.setLayout((Layout)layout);
        this.folder = new CTabFolder(parent, this.getStyle());
        this.folder.setLayoutData((Object)new GridData(300, 300));
        int i = 0;
        while (i < 3) {
            this.createTabItem(0);
            ++i;
        }
        this.folder.setSelection(0);
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.registerControl((Control)this.folder);
        if (this.tabHeight >= 0) {
            this.folder.setTabHeight(this.tabHeight);
        }
        this.updateTopRightControl();
        this.updateProperties();
        this.updateSelFgColor();
        this.updateSelBgColor();
    }

    private void createTabItem(int style) {
        CTabItem item = new CTabItem(this.folder, style);
        int count = this.folder.getItemCount();
        item.setText("Tab " + count);
        if (count != 3) {
            Text content = new Text((Composite)this.folder, 66);
            if (count % 2 != 0) {
                content.setBackground(BG_COLOR_BROWN);
                content.setForeground(FG_COLOR_BLUE);
            }
            content.setText("Some Content " + count);
            item.setControl((Control)content);
        }
    }

    private void createTabHeightControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Tab Height");
        final Spinner spinner = new Spinner(composite, 2048);
        spinner.setSelection(this.folder.getTabHeight());
        spinner.setMinimum(0);
        spinner.setMaximum(100);
        spinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                CTabFolderTab.this.tabHeight = spinner.getSelection();
                CTabFolderTab.this.folder.setTabHeight(CTabFolderTab.this.tabHeight);
            }
        });
    }

    private void createTopRightControl(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Top Right Control");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.showTopRightControl = button.getSelection();
                CTabFolderTab.this.updateTopRightControl();
            }
        });
    }

    private Button createSelectionFgColorButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Selection Foreground");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.selFgIndex = (CTabFolderTab.this.selFgIndex + 1) % CTabFolderTab.this.fgColors.length;
                CTabFolderTab.this.updateSelFgColor();
            }
        });
        return button;
    }

    private Button createSelectionBgColorButton() {
        Button button = new Button(this.styleComp, 8);
        button.setText("Selection Background");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.selBgIndex = (CTabFolderTab.this.selBgIndex + 1) % CTabFolderTab.this.bgColors.length;
                CTabFolderTab.this.updateSelBgColor();
            }
        });
        return button;
    }

    private void updateProperties() {
        this.folder.setMinimizeVisible(this.minVisible);
        this.folder.setMaximizeVisible(this.maxVisible);
        this.folder.setUnselectedCloseVisible(this.unselectedCloseVisible);
    }

    private void updateTopRightControl() {
        if (this.showTopRightControl) {
            Label label = new Label((Composite)this.folder, 0);
            label.setText("topRight");
            Display display = label.getDisplay();
            label.setBackground(display.getSystemColor(14));
            this.folder.setTopRight((Control)label);
        } else {
            Control topRight = this.folder.getTopRight();
            if (topRight != null && !topRight.isDisposed()) {
                topRight.dispose();
            }
            this.folder.setTopRight(null);
        }
    }

    private void updateSelFgColor() {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            if (!(control instanceof CTabFolder)) continue;
            CTabFolder folder = (CTabFolder)control;
            folder.setSelectionForeground(this.fgColors[this.selFgIndex]);
        }
    }

    private void updateSelBgColor() {
        Iterator iter = this.controls.iterator();
        while (iter.hasNext()) {
            Control control = (Control)iter.next();
            if (!(control instanceof CTabFolder)) continue;
            CTabFolder folder = (CTabFolder)control;
            folder.setSelectionBackground(this.bgColors[this.selBgIndex]);
        }
    }
}

