/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

class DateTimeTab
extends ExampleTab {
    private static final String PROP_CONTEXT_MENU = "contextMenu";
    private static final String PROP_SELECTION_LISTENER = "selectionListener";
    DateTime dateTime1;
    Group group1;
    Group group2;

    DateTimeTab(CTabFolder topFolder) {
        super(topFolder, "DateTime");
        this.setDefaultStyle(67616);
    }

    protected void createStyleControls(Composite parent) {
        this.group1 = new Group(this.styleComp, 4);
        this.group1.setLayout((Layout)new RowLayout(512));
        this.createStyleButton((Composite)this.group1, "DATE", 32, 16, true);
        this.createStyleButton((Composite)this.group1, "TIME", 128, 16, false);
        this.createStyleButton((Composite)this.group1, "CALENDAR", 1024, 16, false);
        this.group2 = new Group(this.styleComp, 4);
        this.group2.setLayout((Layout)new RowLayout(512));
        this.createStyleButton((Composite)this.group2, "SHORT", 32768, 16, false);
        this.createStyleButton((Composite)this.group2, "MEDIUM", 65536, 16, true);
        this.createStyleButton((Composite)this.group2, "LONG", 0x10000000, 16, false);
        this.createStyleButton("BORDER", 2048, true);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFontChooser();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createPropertyCheckbox("Add Context Menu", PROP_CONTEXT_MENU);
        this.createPropertyCheckbox("Add Selection Listener", PROP_SELECTION_LISTENER);
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new RowLayout(512));
        int style = this.getStyle() | this.getStyle((Composite)this.group1) | this.getStyle((Composite)this.group2);
        this.dateTime1 = new DateTime(parent, style);
        if (this.hasCreateProperty(PROP_CONTEXT_MENU)) {
            Menu dateTimeMenu = new Menu((Control)this.dateTime1);
            MenuItem dateTimeMenuItem = new MenuItem(dateTimeMenu, 8);
            dateTimeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String message = "You requested a context menu for the DateTime";
                    MessageDialog.openInformation((Shell)DateTimeTab.this.dateTime1.getShell(), (String)"Information", (String)message);
                }
            });
            dateTimeMenuItem.setText("DateTime context menu item");
            this.dateTime1.setMenu(dateTimeMenu);
        }
        if (this.hasCreateProperty(PROP_SELECTION_LISTENER)) {
            this.dateTime1.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    String message = "DateTime WidgetSelected! Selected date: " + DateTimeTab.this.dateTime1.getDay() + "/" + (DateTimeTab.this.dateTime1.getMonth() + 1) + "/" + DateTimeTab.this.dateTime1.getYear() + " " + DateTimeTab.this.dateTime1.getHours() + ":" + DateTimeTab.this.dateTime1.getMinutes() + ":" + DateTimeTab.this.dateTime1.getSeconds();
                    DateTimeTab.this.log(message);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    String message = "DateTime WidgetDefaultSelected!";
                    DateTimeTab.this.log(message);
                }
            });
        }
        this.registerControl((Control)this.dateTime1);
    }

    protected Button createStyleButton(Composite parent, String name, int style, int buttonStyle, boolean checked) {
        Button button = new Button(parent, buttonStyle);
        button.setText(name);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DateTimeTab.this.createNew();
            }
        });
        button.setData("style", (Object)new Integer(style));
        button.setSelection(checked);
        return button;
    }

    protected int getStyle(Composite comp) {
        Control[] ctrls;
        int result = 0;
        if (comp != null && (ctrls = comp.getChildren()).length != 0) {
            int i = 0;
            while (i < ctrls.length) {
                Object data;
                Button button;
                if (ctrls[i] instanceof Button && (button = (Button)ctrls[i]).getSelection() && (data = button.getData("style")) != null && data instanceof Integer) {
                    int style = (Integer)data;
                    result |= style;
                }
                ++i;
            }
        }
        return result;
    }
}

