/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.business;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.IMenuService;

public class CommandUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Action wrapCommand(CommandContributionItem item, Composite parent) {
        Action result = null;
        final CommandParameter param = CommandUtil.extractCommandInformation(item, parent);
        String text = param.getTooltipText();
        String toolTipText = param.getTooltipText();
        int style = 1;
        if (param.getStyle() == 4) {
            style = 4;
        } else if (param.getStyle() == 32) {
            style = 2;
        } else if (param.getStyle() == 16) {
            style = 8;
        }
        result = new Action(text, style){

            public void run() {
                Command command = param.getCommand();
                if (command != null) {
                    try {
                        command.getHandler().execute(new ExecutionEvent());
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        ImageDescriptor desc = new ImageDescriptor(){

            public Image createImage() {
                return param.getIcon();
            }
        };
        result.setImageDescriptor(desc);
        result.setToolTipText(toolTipText);
        return result;
    }

    public static CommandParameter extractCommandInformation(CommandContributionItem item, Composite parent) {
        CommandParameter result = null;
        CommandManager manager = new CommandManager();
        Command command = manager.getCommand(item.getId());
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object service = activeWindow.getService((Class)clazz);
        if (!command.isDefined() && service != null && service instanceof ICommandService) {
            ICommandService commandService = (ICommandService)service;
            command = commandService.getCommand(item.getId());
        }
        Image icon = null;
        String text = "";
        String tooltipText = "";
        int style = 8;
        ToolBar toolbar = new ToolBar(parent, 0);
        toolbar.setVisible(false);
        item.fill(toolbar, -1);
        ToolItem[] toolItems = toolbar.getItems();
        if (toolItems.length <= 0) {
            throw new IllegalStateException("Command information not extractable");
        }
        ToolItem toolItem = toolItems[0];
        style = toolItem.getStyle();
        icon = toolItem.getImage();
        text = toolItem.getToolTipText();
        tooltipText = toolItem.getToolTipText();
        Menu menu = null;
        if (style == 4) {
            MenuManager menuManager = new MenuManager();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.ui.menus.IMenuService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object abstractService = activeWindow.getService((Class)clazz2);
            IMenuService menuService = (IMenuService)abstractService;
            String identifier = "menu:" + item.getId();
            menuService.populateContributionManager((ContributionManager)menuManager, identifier);
            menu = menuManager.createContextMenu((Control)parent);
        }
        result = new CommandParameter(command, item.getId(), icon, style, menu, text, tooltipText);
        toolbar.dispose();
        return result;
    }

    public static class CommandParameter {
        private Menu menu;
        private int style;
        private Image icon;
        private Command command;
        private String text;
        private String tooltipText;

        public CommandParameter(Command command, String id, Image icon, int style, Menu menu, String text, String tooltipText) {
            this.command = command;
            this.icon = icon;
            this.style = style;
            this.menu = menu;
            this.text = text;
            this.tooltipText = tooltipText;
        }

        public Command getCommand() {
            return this.command;
        }

        public Menu getMenu() {
            return this.menu;
        }

        public int getStyle() {
            return this.style;
        }

        public Image getIcon() {
            return this.icon;
        }

        public String getText() {
            return this.text;
        }

        public String getTooltipText() {
            return this.tooltipText;
        }
    }
}

