/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.business.managers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.internal.provisional.action.IToolBarManager2;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.rap.internal.design.example.business.CommandUtil;
import org.eclipse.rap.internal.design.example.business.builder.DummyBuilder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.internal.WWinPluginPulldown;
import org.eclipse.ui.menus.CommandContributionItem;

public class BusinessViewToolBarManager
extends ContributionManager
implements IToolBarManager2,
IAdaptable {
    private Composite control;
    private List itemList = new ArrayList();

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
    }

    public ToolBar createControl(Composite parent) {
        return null;
    }

    public Control createControl2(Composite parent) {
        if (!this.toolBarExist() && parent != null) {
            this.control = new Composite(parent, 0);
            this.control.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
            RowLayout layout = new RowLayout();
            layout.spacing = 3;
            this.control.setLayout((Layout)layout);
        }
        return this.control;
    }

    private boolean toolBarExist() {
        return this.control != null && !this.control.isDisposed();
    }

    public ToolBar getControl() {
        return null;
    }

    public Control getControl2() {
        return this.control;
    }

    public int getItemCount() {
        return this.getItems().length;
    }

    private void makeActionButton(final Action action, IContributionItem item) {
        if (!this.itemList.contains(item.getId())) {
            int flags = 8;
            switch (action.getStyle()) {
                case 2: {
                    flags = 2;
                    break;
                }
                case 4: {
                    flags = 4;
                    break;
                }
                case 8: {
                    flags = 2;
                    break;
                }
                default: {
                    flags = 8;
                }
            }
            Composite parent = this.control;
            Menu menu = null;
            if (flags == 4 && item instanceof CommandContributionItem) {
                CommandContributionItem commandItem = (CommandContributionItem)item;
                CommandUtil.CommandParameter param = CommandUtil.extractCommandInformation(commandItem, this.control);
                if (param.getMenu() != null) {
                    menu = param.getMenu();
                }
            } else if (action instanceof WWinPluginPulldown) {
                WWinPluginPulldown pulldown = (WWinPluginPulldown)action;
                menu = pulldown.getMenuCreator().getMenu((Control)this.control);
            } else if (action instanceof IMenuCreator) {
                IMenuCreator creator = (IMenuCreator)action;
                menu = creator.getMenu((Control)this.control);
            } else if (action instanceof IWorkbenchWindowPulldownDelegate) {
                System.out.println("pull");
            }
            if (menu != null) {
                Composite pulldownParent;
                parent = pulldownParent = this.getPulldownParent();
                flags = 8;
            }
            final Button button = new Button(parent, flags);
            button.setData((Object)item);
            button.setToolTipText(action.getToolTipText());
            button.setImage(action.getImageDescriptor().createImage());
            button.setData("org.eclipse.rwt.themeVariant", (Object)"clearButton");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean checked = button.getSelection();
                    int style = button.getStyle();
                    if ((style & 0x22) != 0) {
                        if (action.getStyle() == 2) {
                            action.setChecked(checked);
                        }
                    } else if ((style & 0x10) != 0 && action.getStyle() == 8) {
                        action.setChecked(checked);
                    }
                    action.run();
                }
            });
            if (menu != null) {
                FormData fdButton = new FormData();
                button.setLayoutData((Object)fdButton);
                fdButton.left = new FormAttachment(0);
                fdButton.top = new FormAttachment(0);
                final Button arrow = new Button(parent, 8);
                FormData fdArrow = new FormData();
                arrow.setLayoutData((Object)fdArrow);
                fdArrow.left = new FormAttachment((Control)button, 0);
                fdArrow.top = new FormAttachment(0, 7);
                DummyBuilder builder = new DummyBuilder(null, "org.eclipse.rap.design.example.business.layoutset.stack");
                Image image = builder.getImage("stack.view.pulldown.arrow");
                arrow.setImage(image);
                arrow.setData("org.eclipse.rwt.themeVariant", (Object)"clearButton");
                arrow.setMenu(menu);
                arrow.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Display display = arrow.getDisplay();
                        Point newLoc = display.map((Control)arrow, null, 0, 10);
                        arrow.getMenu().setVisible(true);
                        arrow.getMenu().setLocation(newLoc);
                    }
                });
            }
            this.itemList.add(item.getId());
        }
    }

    private Composite getPulldownParent() {
        final Composite pulldownParent = new Composite(this.control, 0);
        pulldownParent.setLayout((Layout)new FormLayout());
        pulldownParent.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
        pulldownParent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                Control[] children = pulldownParent.getChildren();
                int i = 0;
                while (i < children.length) {
                    Control control = children[i];
                    control.dispose();
                    ++i;
                }
            }
        });
        return pulldownParent;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
    }

    public void update(boolean force) {
        this.itemList.clear();
        Control[] children = this.control.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        IContributionItem[] items = this.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            IContributionItem item = items[i2];
            if (item.isVisible() && item instanceof ActionContributionItem) {
                IAction action = ((ActionContributionItem)item).getAction();
                this.makeActionButton((Action)action, item);
            } else if (item.isVisible() && item instanceof CommandContributionItem) {
                this.makeCommandButton(item);
            }
            ++i2;
        }
        this.control.pack();
        this.control.layout(true);
    }

    private void makeCommandButton(IContributionItem item) {
        CommandContributionItem comamndItem = (CommandContributionItem)item;
        Action action = CommandUtil.wrapCommand(comamndItem, this.control);
        this.makeActionButton(action, item);
    }

    public void dispose() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.dispose();
        }
        IContributionItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        return result;
    }
}

