/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.business.stacks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.internal.design.example.business.builder.BusinessStackBuider;
import org.eclipse.rap.internal.design.example.business.stacks.ViewToolBarRegistry;
import org.eclipse.rap.ui.interactiondesign.ConfigurableStack;
import org.eclipse.rap.ui.interactiondesign.ConfigurationAction;
import org.eclipse.rap.ui.interactiondesign.IConfigurationChangeListener;
import org.eclipse.rap.ui.interactiondesign.layout.ElementBuilder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;

public class ViewStackPresentation
extends ConfigurableStack {
    private static final String ID_CLOSE = "close";
    private static final String BUTTON_ID = "buttonId";
    private Control presentationControl;
    private IPresentablePart currentPart;
    private ElementBuilder stackBuilder;
    private Composite tabBg;
    private Composite confArea;
    private Button confButton;
    private Label confCorner;
    private Map buttonPartMap = new HashMap();
    private List partList = new ArrayList();
    private List buttonList = new ArrayList();
    private Composite toolbarBg;
    private Shell toolBarLayer;
    private int state = 0;
    protected boolean deactivated = false;
    private Button viewMenuButton;
    private Map dirtyListenerMap = new HashMap();

    public void init() {
        ConfigurationAction action = this.getConfigAction();
        if (action != null) {
            action.addConfigurationChangeListener(new IConfigurationChangeListener(){

                public void toolBarChanged() {
                    ViewToolBarRegistry registry = ViewToolBarRegistry.getInstance();
                    registry.fireToolBarChanged();
                }

                public void presentationChanged(String newStackPresentationId) {
                }
            });
        }
        this.presentationControl = this.createStyledControl();
        ViewToolBarRegistry registry = ViewToolBarRegistry.getInstance();
        registry.addViewPartPresentation(this);
    }

    void catchToolbarChange() {
        this.layoutToolBar();
        this.setBounds(this.presentationControl.getBounds());
    }

    private void createToolBarBg() {
        Composite tabBar = this.getTabBar();
        this.toolbarBg = new Composite(tabBar.getParent(), 0);
        this.toolbarBg.setLayout((Layout)new FormLayout());
        Image bg = this.stackBuilder.getImage("stack.viewtoolbar.bg");
        this.toolbarBg.setBackgroundImage(bg);
        FormData fdToolBar = new FormData();
        this.toolbarBg.setLayoutData((Object)fdToolBar);
        fdToolBar.left = new FormAttachment(0);
        fdToolBar.right = new FormAttachment(100);
        fdToolBar.top = new FormAttachment((Control)tabBar);
        fdToolBar.height = bg.getBounds().height;
        this.toolbarBg.moveAbove((Control)tabBar);
    }

    private Control createStyledControl() {
        this.getParent().setData("org.eclipse.rwt.themeVariant", (Object)"compGray");
        final Composite parent = new Composite(this.getParent(), 0);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ViewStackPresentation.this.setBounds(parent.getBounds());
            }
        });
        parent.setData("org.eclipse.rwt.themeVariant", (Object)"compGray");
        this.stackBuilder = new BusinessStackBuider(parent, "org.eclipse.rap.design.example.business.layoutset.stack");
        this.stackBuilder.build();
        return parent;
    }

    private boolean isStandalone() {
        return this.getType().equals("standaloneview");
    }

    public void addPart(IPresentablePart newPart, Object cookie) {
        this.checkTabBg();
        if (!this.isStandalone()) {
            this.createPartButton(newPart);
            this.partList.add(newPart);
            Control partControl = newPart.getControl();
            if (partControl != null) {
                partControl.getParent().setBackgroundMode(0);
                partControl.setData("org.eclipse.rwt.themeVariant", (Object)"partBorder");
            }
        } else {
            this.decorateStandaloneView(newPart);
        }
        DirtyListener listener = new DirtyListener(newPart);
        this.dirtyListenerMap.put(newPart, listener);
        newPart.addPropertyListener((IPropertyListener)listener);
    }

    private void decorateStandaloneView(IPresentablePart newPart) {
        this.checkTabBg();
        if (this.getShowTitle()) {
            this.getTabBar().setVisible(true);
            this.tabBg.setVisible(true);
            Label title = new Label(this.tabBg, 0);
            title.setData("org.eclipse.rwt.themeVariant", (Object)"standaloneView");
            title.setText(newPart.getName());
        } else {
            this.getTabBar().setVisible(false);
        }
    }

    private void layoutToolBar() {
        if (this.toolbarBg == null && this.tabBg != null) {
            this.createToolBarBg();
        }
        if (this.currentPart != null) {
            Control toolBar = this.currentPart.getToolBar();
            final IPartMenu viewMenu = this.currentPart.getMenu();
            if (viewMenu != null) {
                if (this.viewMenuButton == null) {
                    this.viewMenuButton = new Button(this.toolbarBg, 8);
                    this.viewMenuButton.setData("org.eclipse.rwt.themeVariant", (Object)"clearButton");
                    Image icon = this.stackBuilder.getImage("stack.viewmenu.icon");
                    this.viewMenuButton.setImage(icon);
                    FormData fdViewMenuButton = new FormData();
                    this.viewMenuButton.setLayoutData((Object)fdViewMenuButton);
                    fdViewMenuButton.right = new FormAttachment(100, -3);
                    fdViewMenuButton.top = new FormAttachment(0, 7);
                    this.viewMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Display display = ViewStackPresentation.this.viewMenuButton.getDisplay();
                            int height = ((ViewStackPresentation)ViewStackPresentation.this).viewMenuButton.getSize().y;
                            Point newLoc = display.map((Control)ViewStackPresentation.this.viewMenuButton, null, 0, height);
                            viewMenu.showMenu(newLoc);
                        }
                    });
                }
            } else if (this.viewMenuButton != null) {
                this.viewMenuButton.setVisible(false);
                this.viewMenuButton.dispose();
                this.viewMenuButton = null;
            }
            Point size = this.toolbarBg.getSize();
            if (toolBar != null) {
                Point point = this.currentPart.getControl().getLocation();
                point.y -= size.y + 2;
                point.x += size.x - toolBar.getSize().x;
                if (viewMenu != null) {
                    point.x -= 20;
                }
                toolBar.setLocation(point);
                toolBar.setVisible(true);
                this.toolbarBg.moveBelow(toolBar);
                this.presentationControl.moveBelow(toolBar);
                this.currentPart.getControl().moveBelow(toolBar);
            }
            if (toolBar != null || viewMenu != null) {
                this.toolbarBg.setVisible(true);
                if (!this.deactivated) {
                    this.getToolBarLayer();
                    this.toolBarLayer.setVisible(false);
                    if (this.state != 1) {
                        Display display = this.toolBarLayer.getDisplay();
                        Point newLocation = display.map((Control)this.toolbarBg, null, 0, 0);
                        this.toolBarLayer.setBounds(newLocation.x, newLocation.y, size.x, size.y - 1);
                        this.toolBarLayer.setVisible(true);
                    }
                }
            } else {
                this.toolbarBg.setVisible(false);
            }
            this.toolbarBg.layout(true);
        }
    }

    private void createPartButton(final IPresentablePart part) {
        Composite buttonArea = new Composite(this.tabBg, 0);
        buttonArea.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
        Image bg = this.stackBuilder.getImage("stack.tab.inactive.bg.act");
        buttonArea.setBackgroundImage(bg);
        buttonArea.setBackgroundMode(2);
        buttonArea.setLayout((Layout)new FormLayout());
        Button partButton = new Button(buttonArea, 8);
        partButton.setData("org.eclipse.rwt.themeVariant", (Object)"partInactive");
        partButton.setText(part.getName());
        FormData fdPartButton = new FormData();
        partButton.setLayoutData((Object)fdPartButton);
        fdPartButton.left = new FormAttachment(0);
        fdPartButton.top = new FormAttachment(0);
        fdPartButton.bottom = new FormAttachment(100);
        partButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ViewStackPresentation.this.currentPart.equals(part)) {
                    ViewStackPresentation.this.selectPart(part);
                    ViewStackPresentation.this.layoutToolBar();
                }
                ViewStackPresentation.this.activePart(part);
            }
        });
        partButton.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                page.toggleZoom(ViewStackPresentation.this.getReference(part));
            }
        });
        Composite corner = new Composite(buttonArea, 0);
        corner.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
        corner.setLayout((Layout)new FormLayout());
        Image cornerImage = this.stackBuilder.getImage("stack.tab.inactive.separator.active");
        corner.setBackgroundImage(cornerImage);
        FormData fdCorner = new FormData();
        corner.setLayoutData((Object)fdCorner);
        fdCorner.right = new FormAttachment(100);
        fdCorner.bottom = new FormAttachment(100);
        fdCorner.width = cornerImage.getBounds().width;
        fdCorner.height = cornerImage.getBounds().height;
        fdPartButton.right = new FormAttachment((Control)corner, -8);
        this.buttonPartMap.put(part, buttonArea);
        this.buttonList.add(buttonArea);
    }

    protected void activePart(IPresentablePart part) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = window.getActivePage();
        IWorkbenchPart workbenchPart = this.getReference(part).getPart(false);
        if (workbenchPart != null) {
            activePage.activate(workbenchPart);
        }
    }

    private IWorkbenchPartReference getReference(IPresentablePart part) {
        IWorkbenchPartReference result = null;
        if (part instanceof PresentablePart) {
            PresentablePart presentablePart = (PresentablePart)part;
            PartPane pane = presentablePart.getPane();
            result = pane.getPartReference();
        }
        return result;
    }

    private void makePartButtonActive(final IPresentablePart part) {
        Object object = this.buttonPartMap.get(part);
        if (object instanceof Composite) {
            Composite buttonArea = (Composite)object;
            this.checkHideSeparator(buttonArea);
            Image bg = this.stackBuilder.getImage("stack.conf.bg.inactive");
            buttonArea.setBackgroundImage(bg);
            Control[] children = buttonArea.getChildren();
            buttonArea.setLayout((Layout)new FormLayout());
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child instanceof Button) {
                    Button partButton = (Button)child;
                    partButton.setData("org.eclipse.rwt.themeVariant", (Object)"partActive");
                } else if (child instanceof Composite) {
                    Composite corner = (Composite)child;
                    corner.setVisible(true);
                    String cornerDesc = "stack.inactive.corner.inactive";
                    Image cornerImage = this.stackBuilder.getImage(cornerDesc);
                    corner.setBackgroundImage(cornerImage);
                    FormData fdCorner = (FormData)corner.getLayoutData();
                    fdCorner.top = new FormAttachment(0);
                    fdCorner.width = cornerImage.getBounds().width;
                    fdCorner.height = cornerImage.getBounds().height;
                    if (part.isCloseable()) {
                        Button close = new Button(buttonArea, 8);
                        close.setData(BUTTON_ID, (Object)ID_CLOSE);
                        close.setData("org.eclipse.rwt.themeVariant", (Object)"viewClose");
                        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                ViewStackPresentation.this.getSite().close(new IPresentablePart[]{part});
                            }
                        });
                        FormData fdClose = new FormData();
                        close.setLayoutData((Object)fdClose);
                        fdClose.right = new FormAttachment(100, -5);
                        fdClose.top = new FormAttachment(0, 6);
                        fdClose.width = 8;
                        fdClose.height = 8;
                        close.setLayoutData((Object)fdClose);
                        close.moveAbove((Control)corner);
                    }
                }
                ++i;
            }
            buttonArea.getParent().layout();
        }
    }

    private void checkHideSeparator(Composite buttonArea) {
        int indexOf = this.buttonList.indexOf(buttonArea);
        int i = 0;
        while (i < this.buttonList.size()) {
            Composite area = (Composite)this.buttonList.get(i);
            Control[] children = area.getChildren();
            int j = 0;
            while (j < children.length) {
                if (children[j] instanceof Composite) {
                    if (i == indexOf || i == indexOf - 1) {
                        ((Composite)children[j]).setVisible(false);
                    } else {
                        ((Composite)children[j]).setVisible(true);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void makePartButtonInactive(IPresentablePart part) {
        Object object = this.buttonPartMap.get(part);
        if (object instanceof Composite) {
            Composite buttonArea = (Composite)object;
            String bgDesc = "stack.tab.inactive.bg.act";
            Image bg = this.stackBuilder.getImage(bgDesc);
            buttonArea.setBackgroundImage(bg);
            Control[] children = buttonArea.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child instanceof Button) {
                    Button button = (Button)child;
                    if (button.getData(BUTTON_ID) != null) {
                        button.setVisible(false);
                        button.dispose();
                    } else {
                        button.setData("org.eclipse.rwt.themeVariant", (Object)"partInactive");
                    }
                } else if (child instanceof Composite) {
                    Composite corner = (Composite)child;
                    corner.setVisible(true);
                    String sepConst = "stack.tab.inactive.separator.active";
                    Image cornerImage = this.stackBuilder.getImage(sepConst);
                    corner.setBackgroundImage(cornerImage);
                    FormData fdCorner = (FormData)corner.getLayoutData();
                    fdCorner.width = cornerImage.getBounds().width;
                    fdCorner.height = cornerImage.getBounds().height;
                }
                ++i;
            }
            buttonArea.getParent().layout();
        }
    }

    private void checkTabBg() {
        Composite tabBar = this.getTabBar();
        if (this.tabBg == null && tabBar != null) {
            this.tabBg = new Composite(tabBar, 0);
            this.tabBg.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
            FormData fdTabBg = new FormData();
            this.tabBg.setLayoutData((Object)fdTabBg);
            fdTabBg.left = new FormAttachment(0);
            fdTabBg.top = new FormAttachment(0);
            fdTabBg.bottom = new FormAttachment(100);
            this.createConfArea(fdTabBg);
            RowLayout layout = new RowLayout(256);
            layout.spacing = 0;
            layout.marginBottom = 0;
            if (!this.isStandalone()) {
                layout.marginHeight = 0;
                layout.marginLeft = 0;
            } else {
                layout.marginHeight = 4;
                layout.marginLeft = 6;
            }
            layout.marginRight = 0;
            layout.marginTop = 0;
            layout.marginWidth = 0;
            layout.pack = true;
            this.tabBg.setLayout((Layout)layout);
        }
    }

    private void createConfArea(FormData fdTabBg) {
        final ConfigurationAction configAction = this.getConfigAction();
        if (configAction != null) {
            this.confArea = new Composite(this.getTabBar(), 0);
            Image confBg = this.stackBuilder.getImage("stack.conf.bg.inactive");
            this.confArea.setBackgroundImage(confBg);
            this.confArea.setLayout((Layout)new FormLayout());
            FormData fdConfArea = new FormData();
            this.confArea.setLayoutData((Object)fdConfArea);
            fdConfArea.top = new FormAttachment(0);
            fdConfArea.bottom = new FormAttachment(100);
            fdConfArea.right = new FormAttachment(100);
            fdTabBg.right = new FormAttachment((Control)this.confArea);
            this.confCorner = new Label(this.confArea, 0);
            Image cornerImage = this.stackBuilder.getImage("stack.corner.inactive");
            this.confCorner.setImage(cornerImage);
            FormData fdCorner = new FormData();
            this.confCorner.setLayoutData((Object)fdCorner);
            fdCorner.left = new FormAttachment(0);
            fdCorner.top = new FormAttachment(0);
            fdCorner.bottom = new FormAttachment(100);
            this.confButton = new Button(this.confArea, 8);
            Image confImage = this.stackBuilder.getImage("stack.conf.inactive");
            this.confButton.setImage(confImage);
            this.confButton.setData("org.eclipse.rwt.themeVariant", (Object)"clearButton");
            FormData fdConfButton = new FormData();
            this.confButton.setLayoutData((Object)fdConfButton);
            fdConfButton.left = new FormAttachment((Control)this.confCorner);
            fdConfButton.top = new FormAttachment(0);
            fdConfButton.right = new FormAttachment(100, 0);
            this.confButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ViewStackPresentation.this.activePart(ViewStackPresentation.this.getSite().getSelectedPart());
                    configAction.run();
                }
            });
        } else {
            fdTabBg.right = new FormAttachment(100);
        }
    }

    public void dispose() {
        ViewToolBarRegistry registry = ViewToolBarRegistry.getInstance();
        registry.removeViewPartPresentation(this);
        if (this.toolBarLayer != null) {
            this.toolBarLayer.dispose();
        }
        this.presentationControl.dispose();
    }

    public Control getControl() {
        return this.presentationControl;
    }

    public Control[] getTabList(IPresentablePart part) {
        ArrayList<Control> list = new ArrayList<Control>();
        if (this.getControl() != null) {
            list.add(this.getControl());
        }
        if (part.getToolBar() != null) {
            list.add(part.getToolBar());
        }
        if (part.getControl() != null) {
            list.add(part.getControl());
        }
        return list.toArray(new Control[list.size()]);
    }

    public void removePart(IPresentablePart oldPart) {
        Object listener;
        Object object = this.buttonPartMap.get(oldPart);
        if (this.toolBarLayer != null) {
            this.toolBarLayer.setVisible(false);
        }
        if ((listener = this.dirtyListenerMap.get(oldPart)) != null && listener instanceof IPropertyListener) {
            oldPart.removePropertyListener((IPropertyListener)listener);
        }
        this.buttonPartMap.remove(oldPart);
        this.buttonList.remove(object);
        ((Composite)object).dispose();
        this.partList.remove(oldPart);
        oldPart.setVisible(false);
        this.tabBg.layout();
    }

    public void selectPart(IPresentablePart toSelect) {
        if (toSelect != null) {
            toSelect.setVisible(true);
        }
        if (this.currentPart != null && this.currentPart instanceof PresentablePart && ((PresentablePart)this.currentPart).getPane() != null) {
            this.currentPart.setVisible(false);
        }
        this.makePartButtonInactive(this.currentPart);
        this.currentPart = toSelect;
        this.makePartButtonActive(this.currentPart);
        this.activePart(this.currentPart);
        this.layoutToolBar();
    }

    public void setActive(int newState) {
        this.state = newState;
        Image confBg = null;
        Image cornerImage = null;
        Image confImage = null;
        if (newState == 1) {
            if (!this.isStandalone()) {
                this.changeSelectedActiveButton(true);
            }
            confBg = this.stackBuilder.getImage("stack.conf.bg.active");
            cornerImage = this.stackBuilder.getImage("stack.tab.inactive.right.active");
            confImage = this.stackBuilder.getImage("stack.conf.active");
        } else {
            if (!this.isStandalone()) {
                this.changeSelectedActiveButton(false);
            }
            confBg = this.stackBuilder.getImage("stack.conf.bg.inactive");
            cornerImage = this.stackBuilder.getImage("stack.corner.inactive");
            confImage = this.stackBuilder.getImage("stack.conf.inactive");
        }
        if (this.confArea != null) {
            this.confArea.setBackgroundImage(confBg);
            if (this.confCorner != null) {
                this.confCorner.setImage(cornerImage);
            }
            if (this.confButton != null) {
                this.confButton.setImage(confImage);
            }
            this.confArea.getParent().layout(true);
            if (this.currentPart != null) {
                this.currentPart.setVisible(true);
            }
            this.confArea.layout(true);
        }
        this.setBounds(this.presentationControl.getBounds());
    }

    private void changeSelectedActiveButton(boolean selected) {
        Image buttonAreaBg = null;
        Image corner = null;
        String close = "";
        if (selected) {
            buttonAreaBg = this.stackBuilder.getImage("stack.tab.active.bg.act");
            corner = this.stackBuilder.getImage("stack.tab.active.right.active");
            close = "viewClose";
        } else {
            buttonAreaBg = this.stackBuilder.getImage("stack.conf.bg.inactive");
            corner = this.stackBuilder.getImage("stack.inactive.corner.inactive");
            close = "viewCloseInactive";
        }
        Object object = this.buttonPartMap.get(this.currentPart);
        if (object != null && object instanceof Composite) {
            Composite buttonArea = (Composite)object;
            buttonArea.setBackgroundImage(buttonAreaBg);
            Control[] children = buttonArea.getChildren();
            int i = 0;
            while (i < children.length) {
                Button button;
                Control child = children[i];
                if (child instanceof Composite) {
                    Composite cornerComp = (Composite)child;
                    cornerComp.setBackgroundImage(corner);
                } else if (child instanceof Button && (button = (Button)child).getData(BUTTON_ID) != null) {
                    button.setData("org.eclipse.rwt.themeVariant", (Object)close);
                }
                ++i;
            }
        }
    }

    public void setBounds(Rectangle bounds) {
        this.presentationControl.setBounds(bounds);
        Composite tabBar = this.getTabBar();
        if (this.currentPart != null && tabBar != null) {
            int newHeight = bounds.height - 16;
            int partBoundsY = bounds.y + 8;
            if (this.getTabBar().isVisible()) {
                newHeight -= tabBar.getBounds().height;
                partBoundsY += tabBar.getBounds().height;
            }
            Control toolBar = this.currentPart.getToolBar();
            if (this.toolbarBg != null && (this.toolbarBg.isVisible() || toolBar != null)) {
                int toolbarHeight = this.toolbarBg.getBounds().height;
                newHeight -= toolbarHeight;
                partBoundsY += toolbarHeight;
            }
            Rectangle partBounds = new Rectangle(bounds.x + 8, partBoundsY, bounds.width - 16, newHeight);
            this.currentPart.setBounds(partBounds);
        }
        this.layoutToolBar();
    }

    private Shell getToolBarLayer() {
        if (this.toolBarLayer == null && this.toolbarBg != null) {
            Display display = this.toolbarBg.getDisplay();
            this.toolBarLayer = new Shell(display, 16392);
            this.toolBarLayer.setData("org.eclipse.rwt.themeVariant", (Object)"toolbarLayer");
            this.toolBarLayer.setAlpha(200);
            this.toolBarLayer.open();
            this.toolBarLayer.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    ViewStackPresentation.this.activePart(ViewStackPresentation.this.currentPart);
                }
            });
        }
        return this.toolBarLayer;
    }

    private Composite getTabBar() {
        Composite result = null;
        Object adapter = this.stackBuilder.getAdapter(((Object)((Object)this)).getClass());
        if (adapter != null && adapter instanceof Composite) {
            result = (Composite)adapter;
        }
        return result;
    }

    public void setState(int state) {
    }

    public void setVisible(boolean isVisible) {
        if (this.currentPart != null) {
            this.currentPart.setVisible(isVisible);
            this.deactivated = !isVisible;
            this.layoutToolBar();
            if (this.toolBarLayer != null && !isVisible) {
                this.toolBarLayer.setVisible(false);
            }
            this.setBounds(this.presentationControl.getBounds());
        }
    }

    public void showPaneMenu() {
    }

    public void showSystemMenu() {
    }

    private class DirtyListener
    implements IPropertyListener {
        private IPresentablePart part;

        public DirtyListener(IPresentablePart part) {
            this.part = part;
        }

        public void propertyChanged(Object source, int propId) {
            Button partButton;
            if (propId == 257 && (partButton = this.getPartButton(this.part)) != null) {
                String text = partButton.getText();
                char lastCharacter = this.getLastCharacter(text);
                if (this.part.isDirty()) {
                    if (lastCharacter != '*') {
                        text = String.valueOf(text) + "*";
                    }
                } else if (lastCharacter == '*') {
                    text = text.substring(0, text.length() - 1);
                }
                partButton.setText(text);
            }
        }

        private Button getPartButton(IPresentablePart part) {
            Control[] children;
            Button result = null;
            Object object = ViewStackPresentation.this.buttonPartMap.get(part);
            if (object instanceof Composite && (children = ((Composite)object).getChildren()).length > 0 && children[0] instanceof Button) {
                result = (Button)children[0];
            }
            return result;
        }

        private char getLastCharacter(String text) {
            char[] starArray = new char[1];
            text.getChars(text.length() - 1, text.length(), starArray, 0);
            return starArray[0];
        }
    }
}

