/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.business.popups;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.rap.internal.design.example.business.builder.DummyBuilder;
import org.eclipse.rap.internal.design.example.business.builder.MenuBarPopupBilder;
import org.eclipse.rap.ui.interactiondesign.layout.LayoutRegistry;
import org.eclipse.rap.ui.interactiondesign.layout.model.LayoutSet;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.internal.ShowViewMenu;
import org.eclipse.ui.menus.CommandContributionItem;

public class MenuBarPopup
extends PopupDialog {
    private IContributionItem[] items;
    private LayoutSet layoutSet;
    private MenuBarPopup parentPopup;
    private Listener closeListener = new Listener(){

        public void handleEvent(Event event) {
            if (MenuBarPopup.this.getShell() != null) {
                MenuBarPopup.this.getShell().removeListener(21, (Listener)this);
                MenuBarPopup.this.getShell().removeListener(27, (Listener)this);
                MenuBarPopup.this.getShell().removeListener(12, (Listener)this);
                MenuBarPopup.this.getShell().removeListener(16, (Listener)this);
                MenuBarPopup.this.close();
            }
        }
    };

    public MenuBarPopup(Shell parent, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText, MenuManager manager, MenuBarPopup parentPopup) {
        super(parent, shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
        this.items = manager.getItems();
        this.parentPopup = parentPopup;
        LayoutRegistry registry = LayoutRegistry.getInstance();
        org.eclipse.rap.ui.interactiondesign.layout.model.Layout activeLayout = registry.getActiveLayout();
        this.layoutSet = activeLayout.getLayoutSet("org.eclipse.rap.design.example.business.layoutset.menubar");
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setData("org.eclipse.rwt.themeVariant", (Object)"menuBarPopup");
        this.getShell().setAlpha(210);
        this.addListeners();
        MenuBarPopupBilder popupBuilder = new MenuBarPopupBilder(parent, "org.eclipse.rap.design.example.business.layoutset.menubar");
        popupBuilder.build();
        Composite content = (Composite)popupBuilder.getControl();
        RowLayout layout = new RowLayout(512);
        layout.marginLeft = 11;
        layout.marginRight = 16;
        layout.marginTop = 2;
        layout.spacing = 1;
        layout.marginBottom = 0;
        content.setLayout((Layout)layout);
        int i = 0;
        while (i < this.items.length) {
            IContributionItem item = this.items[i];
            if (item.isVisible()) {
                if (item instanceof ActionContributionItem) {
                    ActionContributionItem actionItem = (ActionContributionItem)item;
                    this.makeActionEntry(actionItem.getAction(), content);
                } else if (item instanceof MenuManager) {
                    MenuManager manager = (MenuManager)item;
                    this.makeMenuManagerEntry(manager, content);
                } else if (item instanceof CommandContributionItem) {
                    CommandContributionItem command = (CommandContributionItem)item;
                    this.makeCommandEntry(command, content);
                } else if (item instanceof ShowViewMenu) {
                    this.makeViewEntries(content);
                }
            }
            ++i;
        }
        return content;
    }

    private void makeViewEntries(Composite content) {
        final Menu menu = new Menu((Control)content);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        ContributionItemFactory factory = ContributionItemFactory.VIEWS_SHORTLIST;
        final IContributionItem viewItem = factory.create(window);
        viewItem.fill(menu, 0);
        menu.setVisible(false);
        content.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                menu.dispose();
                viewItem.dispose();
            }
        });
        MenuItem[] menuItems = menu.getItems();
        int i = 0;
        while (i < menuItems.length) {
            final MenuItem item = menuItems[i];
            if (!item.getText().equals("")) {
                Button button = new Button(content, 0x800008);
                button.setData("org.eclipse.rwt.themeVariant", (Object)"menuBar");
                button.setText(item.getText());
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        Event ev = new Event();
                        ev.widget = (Button)e.getSource();
                        item.notifyListeners(13, ev);
                        menu.dispose();
                        MenuBarPopup.this.destroyItem(item);
                        MenuBarPopup.this.close();
                    }
                });
            }
            ++i;
        }
    }

    private void addListeners() {
        this.getShell().addListener(27, this.closeListener);
        this.getShell().addListener(21, this.closeListener);
        this.getShell().addListener(12, this.closeListener);
        this.getShell().addListener(16, this.closeListener);
        this.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (MenuBarPopup.this.getShell() != null) {
                    MenuBarPopup.this.getShell().pack(true);
                }
            }
        });
    }

    private void makeMenuManagerEntry(final MenuManager manager, Composite content) {
        Composite buttonArea = new Composite(content, 0);
        buttonArea.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
        buttonArea.setLayout((Layout)new FormLayout());
        Button button = new Button(buttonArea, 0x800008);
        button.setData("org.eclipse.rwt.themeVariant", (Object)"menuBar");
        button.setText(manager.getMenuText());
        FormData fdButton = new FormData();
        button.setLayoutData((Object)fdButton);
        fdButton.left = new FormAttachment(0);
        fdButton.top = new FormAttachment(0);
        fdButton.bottom = new FormAttachment(100);
        final Button expand = new Button(buttonArea, 0x800008);
        expand.setData("org.eclipse.rwt.themeVariant", (Object)"menuBar");
        DummyBuilder dummy = new DummyBuilder(buttonArea, this.layoutSet.getId());
        String imageID = "menubar.popup.secondlayer";
        Image expandImage = dummy.getImage(imageID);
        expand.setImage(expandImage);
        FormData fdExpand = new FormData();
        expand.setLayoutData((Object)fdExpand);
        fdExpand.top = new FormAttachment(38);
        fdExpand.right = new FormAttachment(100);
        fdExpand.height = expandImage.getBounds().height;
        fdExpand.width = expandImage.getBounds().width;
        fdButton.right = new FormAttachment((Control)expand, -5);
        final MenuBarPopup parentPopup = this;
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuBarPopup.this.getShell().removeListener(27, MenuBarPopup.this.closeListener);
                MenuBarPopup.this.getShell().removeListener(16, MenuBarPopup.this.closeListener);
                IContributionItem[] menuItems = manager.getItems();
                if (menuItems.length > 0) {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    Shell shell = workbench.getActiveWorkbenchWindow().getShell();
                    MenuBarPopup popup = new MenuBarPopup(shell, 16384, false, false, false, false, false, null, null, manager, parentPopup);
                    popup.open();
                    Display display = shell.getDisplay();
                    Point pos = display.map((Control)expand, null, 0, expand.getSize().y);
                    Shell popupShell = popup.getShell();
                    popupShell.setLocation(pos);
                    popupShell.setActive();
                }
            }
        };
        expand.addSelectionListener((SelectionListener)adapter);
        button.addSelectionListener((SelectionListener)adapter);
    }

    private void makeCommandEntry(CommandContributionItem command, Composite content) {
        final Menu menu = new Menu((Control)content);
        menu.setVisible(false);
        command.fill(menu, 0);
        MenuItem[] menuItems = menu.getItems();
        int j = 0;
        while (j < menuItems.length) {
            final MenuItem item = menuItems[j];
            Button button = new Button(content, 0x800008);
            button.setData("org.eclipse.rwt.themeVariant", (Object)"menuBar");
            button.setText(item.getText());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Event ev = new Event();
                    ev.widget = (Button)e.getSource();
                    item.notifyListeners(13, ev);
                    menu.dispose();
                    MenuBarPopup.this.destroyItem(item);
                    MenuBarPopup.this.close();
                }
            });
            content.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    MenuBarPopup.this.destroyItem(item);
                }
            });
            ++j;
        }
    }

    private void destroyItem(MenuItem item) {
        item.dispose();
        item = null;
    }

    private void makeActionEntry(final IAction action, Composite content) {
        Button button = new Button(content, 0x800008);
        button.setData("org.eclipse.rwt.themeVariant", (Object)"menuBar");
        button.setText(action.getText());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuBarPopup.this.close();
                action.run();
            }
        });
    }

    protected Color getBackground() {
        return this.layoutSet.getColor("menubar.popup");
    }

    protected Color getForeground() {
        return this.layoutSet.getColor("menubar.popup.button");
    }

    public boolean close() {
        if (this.parentPopup != null) {
            this.parentPopup.close();
        }
        return super.close();
    }
}

