/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.business.stacks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.rap.internal.design.example.business.builder.DummyBuilder;
import org.eclipse.rap.internal.design.example.business.stacks.ConfigAction;
import org.eclipse.rap.ui.interactiondesign.ConfigurableStack;
import org.eclipse.rap.ui.interactiondesign.layout.ElementBuilder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class ConfigurationDialog
extends PopupDialog {
    private IStackPresentationSite site;
    private ConfigAction action;
    private HashMap actionButtonMap = new HashMap();
    private List actionList = new ArrayList();
    private ElementBuilder builder;
    private Button viewMenuBox;
    private boolean viewMenuVisChanged;
    private ControlAdapter resizeListener = new ControlAdapter(){

        public void controlResized(ControlEvent e) {
            ConfigurationDialog.this.adjustBounds();
        }
    };
    private Listener closeListener;

    public ConfigurationDialog(Shell parent, int shellStyle, IStackPresentationSite site, ConfigAction action) {
        super(parent, shellStyle, false, false, false, false, false, null, null);
        parent.setBackgroundMode(0);
        this.site = site;
        this.action = action;
        this.hookResizeListener(parent);
        this.builder = new DummyBuilder((Composite)parent, "org.eclipse.rap.design.example.business.layoutset.confdialog");
        this.viewMenuVisChanged = false;
    }

    private void hookResizeListener(Shell parent) {
        parent.addControlListener((ControlListener)this.resizeListener);
    }

    protected void adjustBounds() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        Rectangle bounds = window.getShell().getBounds();
        this.getShell().setBounds(bounds.x + bounds.width / 5, bounds.y + bounds.height / 4, bounds.width - bounds.width / 5 * 2, bounds.height - bounds.height / 4 * 2);
    }

    public boolean close() {
        this.saveViewMenuVisibility();
        this.saveViewActionVisibilities();
        this.getParentShell().removeControlListener((ControlListener)this.resizeListener);
        if (this.getShell() != null) {
            this.getShell().removeListener(27, this.closeListener);
            this.getShell().removeListener(21, this.closeListener);
        }
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite background = new Composite(parent, 0);
        background.setLayout((Layout)new FormLayout());
        Color white = this.builder.getColor("CONFIG_WHITE");
        Label desc = new Label(background, 0);
        desc.setForeground(white);
        desc.setText("Configuration for " + this.site.getSelectedPart().getName());
        FormData fdDesc = new FormData();
        desc.setLayoutData((Object)fdDesc);
        fdDesc.top = new FormAttachment(0, 10);
        Image titleImage = this.site.getSelectedPart().getTitleImage();
        if (titleImage != null) {
            Label image = new Label(background, 0);
            image.setImage(titleImage);
            FormData fdImage = new FormData();
            image.setLayoutData((Object)fdImage);
            fdImage.left = new FormAttachment(0, 10);
            fdImage.top = new FormAttachment(0, 8);
            fdDesc.left = new FormAttachment((Control)image, 5);
        } else {
            fdDesc.left = new FormAttachment(0, 10);
        }
        Button closeButton = new Button(background, 8);
        closeButton.setText("close");
        String imageId = "dialog.close";
        closeButton.setImage(this.builder.getImage(imageId));
        closeButton.setForeground(white);
        closeButton.setData("org.eclipse.rwt.themeVariant", (Object)"clearButton");
        FormData fdCloseButton = new FormData();
        fdCloseButton.bottom = new FormAttachment(0, 0);
        fdCloseButton.right = new FormAttachment(100, -10);
        fdCloseButton.top = new FormAttachment(0, 12);
        closeButton.setLayoutData((Object)fdCloseButton);
        closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigurationDialog.this.close();
            }
        });
        Composite configComposite = new Composite(background, 0);
        FormData fdConfigComposite = new FormData();
        fdConfigComposite.top = new FormAttachment((Control)closeButton, 40);
        fdConfigComposite.left = new FormAttachment(0, 10);
        fdConfigComposite.right = new FormAttachment(100, -10);
        fdConfigComposite.bottom = new FormAttachment(100, -10);
        configComposite.setLayoutData((Object)fdConfigComposite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        configComposite.setLayout((Layout)layout);
        this.hookViewMenuArea(white, configComposite);
        this.loadActionSettings(configComposite);
        return background;
    }

    private void hookViewMenuArea(Color white, Composite configComposite) {
        if (this.action.hasPartMenu()) {
            Label viewMenuLabel = new Label(configComposite, 0);
            viewMenuLabel.setForeground(white);
            viewMenuLabel.setText("viewmenu visibility");
            GridData gdViewMenu = new GridData(768);
            gdViewMenu.horizontalSpan = 2;
            viewMenuLabel.setLayoutData((Object)gdViewMenu);
            this.viewMenuBox = new Button(configComposite, 32);
            this.viewMenuBox.setForeground(white);
            this.viewMenuBox.setSelection(this.action.isPartMenuVisible());
            this.viewMenuVisChanged = this.viewMenuBox.getSelection();
        }
    }

    protected Color getBackground() {
        return this.builder.getColor("CONFIG_BLACK");
    }

    protected Color getForeground() {
        return this.builder.getColor("CONFIG_WHITE");
    }

    private void loadActionSettings(Composite container) {
        ConfigurableStack stackPresentation = (ConfigurableStack)this.action.getStackPresentation();
        IToolBarManager manager = stackPresentation.getPartToolBarManager();
        boolean showDesc = true;
        GridData data = new GridData();
        if (manager != null) {
            String paneId = stackPresentation.getPaneId(this.site);
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                if (!(items[i] instanceof Separator)) {
                    Object[] commandInfo;
                    ActionContributionItem item;
                    if (showDesc) {
                        Label actionDesc = new Label(container, 0);
                        actionDesc.setText("Action visibility");
                        data = new GridData(768);
                        data.horizontalSpan = 3;
                        actionDesc.setLayoutData((Object)data);
                        showDesc = false;
                    }
                    String actionId = items[i].getId();
                    if (items[i] instanceof ActionContributionItem) {
                        item = (ActionContributionItem)items[i];
                        Label imageLabel = new Label(container, 0);
                        imageLabel.setImage(item.getAction().getImageDescriptor().createImage());
                        Label textLabel = new Label(container, 0);
                        if (item.getAction().getText() != null && !item.getAction().getText().equals("")) {
                            textLabel.setText(item.getAction().getText());
                        } else {
                            textLabel.setText(item.getAction().getToolTipText());
                        }
                        data = new GridData(768);
                        textLabel.setLayoutData((Object)data);
                        Button check = new Button(container, 32);
                        check.setLayoutData((Object)new GridData(768));
                        boolean selected = this.action.isViewActionVisibile(paneId, actionId);
                        check.setSelection(selected);
                        this.actionButtonMap.put(actionId, check);
                        this.actionList.add(actionId);
                    } else if (items[i] instanceof CommandContributionItem && (commandInfo = this.getCommandInfo((CommandContributionItem)(item = (CommandContributionItem)items[i]), container)) != null) {
                        Label imageLabel = new Label(container, 0);
                        imageLabel.setImage((Image)commandInfo[0]);
                        Label textLabel = new Label(container, 0);
                        if (commandInfo[1] != null && !commandInfo[1].equals("")) {
                            textLabel.setText((String)commandInfo[1]);
                        } else {
                            textLabel.setText((String)commandInfo[2]);
                        }
                        data = new GridData(768);
                        textLabel.setLayoutData((Object)data);
                        Button check = new Button(container, 32);
                        check.setLayoutData((Object)new GridData(768));
                        boolean selected = this.action.isViewActionVisibile(paneId, item.getId());
                        check.setSelection(selected);
                        this.actionButtonMap.put(item.getId(), check);
                        this.actionList.add(item.getId());
                    }
                }
                ++i;
            }
        }
    }

    private Object[] getCommandInfo(CommandContributionItem item, Composite container) {
        Object[] result = null;
        ToolBar toolbar = new ToolBar(container, 0);
        toolbar.setVisible(false);
        item.fill(toolbar, -1);
        ToolItem[] items = toolbar.getItems();
        int i = 0;
        while (i < items.length) {
            result = new Object[]{items[i].getImage(), items[i].getText(), items[i].getToolTipText()};
            ++i;
        }
        toolbar.dispose();
        return result;
    }

    public int open() {
        int result = super.open();
        this.closeListener = new Listener(){

            public void handleEvent(Event event) {
                ConfigurationDialog.this.close();
            }
        };
        this.getShell().addListener(27, this.closeListener);
        this.getShell().addListener(21, this.closeListener);
        this.getShell().setAlpha(180);
        this.getShell().setBackgroundMode(0);
        Color black = this.builder.getColor("CONFIG_BLACK");
        this.getShell().setBackground(black);
        this.getShell().setActive();
        this.getShell().setFocus();
        this.getContents().setBackground(black);
        return result;
    }

    private void saveViewActionVisibilities() {
        ConfigurableStack stackPresentation = (ConfigurableStack)this.action.getStackPresentation();
        String paneId = stackPresentation.getPaneId(this.site);
        int i = 0;
        while (i < this.actionList.size()) {
            String actionId = (String)this.actionList.get(i);
            Button check = (Button)this.actionButtonMap.get(actionId);
            this.action.saveViewActionVisibility(paneId, actionId, check.getSelection());
            ++i;
        }
        this.action.fireToolBarChange();
    }

    private void saveViewMenuVisibility() {
        boolean selection;
        if (this.viewMenuBox != null && (selection = this.viewMenuBox.getSelection()) != this.viewMenuVisChanged) {
            this.action.savePartMenuVisibility(selection);
            this.action.fireToolBarChange();
        }
    }
}

