/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.internal.JFaceActivator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.DeviceResourceManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class JFaceResources {
    private static final String ICONS_PATH = "$nl$/icons/full/";
    public static final String BANNER_FONT = "org.eclipse.jface.bannerfont";
    public static final String DEFAULT_FONT = "org.eclipse.jface.defaultfont";
    public static final String DIALOG_FONT = "org.eclipse.jface.dialogfont";
    public static final String HEADER_FONT = "org.eclipse.jface.headerfont";
    public static final String TEXT_FONT = "org.eclipse.jface.textfont";
    public static final String VIEWER_FONT = "org.eclipse.jface.viewerfont";
    public static final String WINDOW_FONT = "org.eclipse.jface.windowfont";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    public static String format(String key, Object[] args) {
        return MessageFormat.format(JFaceResources.getString(key), args);
    }

    public static Font getBannerFont() {
        return JFaceResources.getFontRegistry().get(BANNER_FONT);
    }

    public static ResourceBundle getBundle() {
        ResourceBundle result = null;
        String baseName = "org.eclipse.jface.messages";
        try {
            Class<?> clazz = class$9;
            if (clazz == null) {
                try {
                    clazz = class$9 = Class.forName("org.eclipse.jface.resource.JFaceResources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ClassLoader loader = clazz.getClassLoader();
            result = ResourceBundle.getBundle(baseName, RWT.getLocale(), loader);
        }
        catch (RuntimeException runtimeException) {
            String msg = "Warning: could not retrieve resource bundle - loading system default";
            System.out.println(msg);
            result = ResourceBundle.getBundle(baseName);
        }
        return result;
    }

    public static ColorRegistry getColorRegistry() {
        return ColorRegistryStore.getInstance().getColorRegistry();
    }

    public static ResourceManager getResources(Display toQuery) {
        Map registries = Registries.getInstance().getMap();
        ResourceManager reg = (ResourceManager)registries.get(toQuery);
        if (reg == null) {
            DeviceResourceManager mgr = new DeviceResourceManager((Device)toQuery);
            reg = mgr;
            registries.put(toQuery, reg);
        }
        return reg;
    }

    public static ResourceManager getResources() {
        return JFaceResources.getResources(Display.getCurrent());
    }

    public static Font getDefaultFont() {
        return JFaceResources.getFontRegistry().defaultFont();
    }

    public static FontDescriptor getDefaultFontDescriptor() {
        return JFaceResources.getFontRegistry().defaultFontDescriptor();
    }

    public static Font getDialogFont() {
        return JFaceResources.getFontRegistry().get(DIALOG_FONT);
    }

    public static FontDescriptor getDialogFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(DIALOG_FONT);
    }

    public static Font getFont(String symbolicName) {
        return JFaceResources.getFontRegistry().get(symbolicName);
    }

    public static FontDescriptor getFontDescriptor(String symbolicName) {
        return JFaceResources.getFontRegistry().getDescriptor(symbolicName);
    }

    public static FontRegistry getFontRegistry() {
        return FontRegistryStore.getInstance().getFontRegistry();
    }

    public static Font getHeaderFont() {
        return JFaceResources.getFontRegistry().get(HEADER_FONT);
    }

    public static FontDescriptor getHeaderFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(HEADER_FONT);
    }

    public static Image getImage(String key) {
        return ImageRegistryStore.getInstance().getImageRegistry().get(key);
    }

    public static ImageRegistry getImageRegistry() {
        return ImageRegistryStore.getInstance().getImageRegistry();
    }

    public static String getString(String key) {
        try {
            return JFaceResources.getBundle().getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static String[] getStrings(String[] keys) {
        Assert.isNotNull((Object)keys);
        int length = keys.length;
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            result[i] = JFaceResources.getString(keys[i]);
            ++i;
        }
        return result;
    }

    public static Font getTextFont() {
        return JFaceResources.getFontRegistry().get(TEXT_FONT);
    }

    public static FontDescriptor getTextFontDescriptor() {
        return JFaceResources.getFontRegistry().getDescriptor(TEXT_FONT);
    }

    public static Font getViewerFont() {
        return JFaceResources.getFontRegistry().get(VIEWER_FONT);
    }

    public static void setFontRegistry(FontRegistry registry) {
        FontRegistryStore.getInstance().setFontRegistry(registry);
    }

    private JFaceResources() {
    }

    private static final class ColorRegistryStore
    extends SessionSingletonBase {
        private final ColorRegistry colorRegistry = new ColorRegistry();

        private ColorRegistryStore() {
            this.initializeDefaultColors();
        }

        public static ColorRegistryStore getInstance() {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jface.resource.JFaceResources$ColorRegistryStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            return (ColorRegistryStore)((Object)ColorRegistryStore.getInstance((Class)clazz2));
        }

        public ColorRegistry getColorRegistry() {
            return this.colorRegistry;
        }

        private void initializeDefaultColors() {
            Display display = Display.getCurrent();
            this.colorRegistry.put("CONTENT_ASSIST_BACKGROUND_COLOR", display.getSystemColor(25).getRGB());
            this.colorRegistry.put("CONTENT_ASSIST_FOREGROUND_COLOR", display.getSystemColor(24).getRGB());
            this.colorRegistry.put("CONTENT_ASSIST_INFO_BACKGROUND_COLOR", display.getSystemColor(29).getRGB());
            this.colorRegistry.put("CONTENT_ASSIST_INFO_FOREGROUND_COLOR", display.getSystemColor(28).getRGB());
        }
    }

    private static final class FontRegistryStore
    extends SessionSingletonBase {
        private FontRegistry fontRegistry;

        private FontRegistryStore() {
        }

        public static FontRegistryStore getInstance() {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.jface.resource.JFaceResources$FontRegistryStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            return (FontRegistryStore)((Object)FontRegistryStore.getInstance((Class)clazz2));
        }

        public FontRegistry getFontRegistry() {
            if (this.fontRegistry == null) {
                this.fontRegistry = new FontRegistry("org.eclipse.jface.resource.jfacefonts");
            }
            return this.fontRegistry;
        }

        public void setFontRegistry(FontRegistry fontRegistry) {
            Assert.isTrue((this.fontRegistry == null ? 1 : 0) != 0, (String)"Font registry can only be set once.");
            this.fontRegistry = fontRegistry;
        }
    }

    private static final class ImageRegistryStore
    extends SessionSingletonBase {
        private final ImageRegistry imageRegistry = new ImageRegistry();

        private ImageRegistryStore() {
            this.initializeDefaultImages();
        }

        public static ImageRegistryStore getInstance() {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("org.eclipse.jface.resource.JFaceResources$ImageRegistryStore");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            return (ImageRegistryStore)((Object)ImageRegistryStore.getInstance((Class)clazz2));
        }

        public ImageRegistry getImageRegistry() {
            return this.imageRegistry;
        }

        private void initializeDefaultImages() {
            Class<?> clazz;
            Bundle bundle = null;
            try {
                bundle = JFaceActivator.getBundle();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            if ((clazz = class$4) == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.jface.wizard.Wizard");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declareImage(bundle, "org.eclipse.jface.wizard.Wizard.pageImage", "$nl$/icons/full/page.gif", clazz, "images/page.gif");
            Class<?> clazz2 = class$5;
            if (clazz2 == null) {
                try {
                    clazz2 = class$5 = Class.forName("org.eclipse.jface.dialogs.Dialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declareImage(bundle, "dialog_messasge_info_image", "$nl$/icons/full/message_info.gif", clazz2, "images/message_info.gif");
            Class<?> clazz3 = class$5;
            if (clazz3 == null) {
                try {
                    clazz3 = class$5 = Class.forName("org.eclipse.jface.dialogs.Dialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declareImage(bundle, "dialog_messasge_warning_image", "$nl$/icons/full/message_warning.gif", clazz3, "images/message_warning.gif");
            Class<?> clazz4 = class$5;
            if (clazz4 == null) {
                try {
                    clazz4 = class$5 = Class.forName("org.eclipse.jface.dialogs.Dialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declareImage(bundle, "dialog_message_error_image", "$nl$/icons/full/message_error.gif", clazz4, "images/message_error.gif");
            Class<?> clazz5 = class$5;
            if (clazz5 == null) {
                try {
                    clazz5 = class$5 = Class.forName("org.eclipse.jface.dialogs.Dialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declareImage(bundle, "dialog_help_image", "$nl$/icons/full/help.gif", clazz5, "images/help.gif");
            Class<?> clazz6 = class$6;
            if (clazz6 == null) {
                try {
                    clazz6 = class$6 = Class.forName("org.eclipse.jface.dialogs.TitleAreaDialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declareImage(bundle, "dialog_title_banner_image", "$nl$/icons/full/title_banner.png", clazz6, "images/title_banner.gif");
            Class<?> clazz7 = class$7;
            if (clazz7 == null) {
                try {
                    clazz7 = class$7 = Class.forName("org.eclipse.jface.preference.PreferenceDialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declareImage(bundle, "preference_dialog_title_image", "$nl$/icons/full/pref_dialog_title.gif", clazz7, "images/pref_dialog_title.gif");
            Class<?> clazz8 = class$8;
            if (clazz8 == null) {
                try {
                    clazz8 = class$8 = Class.forName("org.eclipse.jface.dialogs.PopupDialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declareImage(bundle, "popup_menu_image", "$nl$/icons/full/popup_menu.gif", clazz8, "images/popup_menu.gif");
            Class<?> clazz9 = class$8;
            if (clazz9 == null) {
                try {
                    clazz9 = class$8 = Class.forName("org.eclipse.jface.dialogs.PopupDialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.declareImage(bundle, "popup_menu_image_diabled", "$nl$/icons/full/popup_menu_disabled.gif", clazz9, "images/popup_menu_disabled.gif");
        }

        private final void declareImage(Object bundle, String key, String path, Class fallback, String fallbackPath) {
            URL url;
            ImageDescriptor descriptor = null;
            if (bundle != null && (url = FileLocator.find((Bundle)((Bundle)bundle), (IPath)new Path(path), null)) != null) {
                descriptor = ImageDescriptor.createFromURL(url);
            }
            if (descriptor == null) {
                descriptor = ImageDescriptor.createFromFile(fallback, fallbackPath);
            }
            this.imageRegistry.put(key, descriptor);
        }
    }

    private static final class Registries
    extends SessionSingletonBase {
        private final Map registries = new HashMap();

        private Registries() {
        }

        public static Registries getInstance() {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.resource.JFaceResources$Registries");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            return (Registries)((Object)Registries.getInstance((Class)clazz2));
        }

        public Map getMap() {
            return this.registries;
        }
    }
}

