/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class FocusCellOwnerDrawHighlighter
extends FocusCellHighlighter {
    private final ColumnViewer viewer;

    public FocusCellOwnerDrawHighlighter(ColumnViewer viewer) {
        super(viewer);
        this.viewer = viewer;
        this.hookListener(viewer);
        viewer.getControl().setData(Table.HIDE_SELECTION, (Object)Boolean.TRUE);
    }

    private void markFocusedCell(Event event, ViewerCell cell) {
        Color foreground;
        Color background = cell.getControl().isFocusControl() ? this.getSelectedCellBackgroundColor(cell) : this.getSelectedCellBackgroundColorNoFocus(cell);
        Color color = foreground = cell.getControl().isFocusControl() ? this.getSelectedCellForegroundColor(cell) : this.getSelectedCellForegroundColorNoFocus(cell);
        if (foreground != null || background != null || this.onlyTextHighlighting(cell)) {
            if (background == null) {
                background = cell.getItem().getDisplay().getSystemColor(26);
            }
            if (foreground == null) {
                foreground = cell.getItem().getDisplay().getSystemColor(27);
            }
            cell.setBackground(background);
            cell.setForeground(foreground);
        }
    }

    private void removeSelectionInformation(Event event, ViewerCell cell) {
        cell.setBackground(null);
        cell.setForeground(null);
    }

    private void hookListener(final ColumnViewer viewer) {
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){
            private Widget[] oldSelection = this.getSelectedItems();
            private ViewerCell oldFocusCell;
            {
                this.oldFocusCell = FocusCellOwnerDrawHighlighter.this.getFocusCell();
            }

            public void selectionChanged(SelectionChangedEvent event) {
                int i = 0;
                while (i < this.oldSelection.length) {
                    Widget item = this.oldSelection[i];
                    ViewerRow row = viewer.getViewerRowFromItem(item);
                    int count = row.getColumnCount();
                    int j = 0;
                    while (j < count) {
                        ViewerCell cell = row.getCell(j);
                        FocusCellOwnerDrawHighlighter.this.removeSelectionInformation(null, cell);
                        ++j;
                    }
                    ++i;
                }
                if (this.oldFocusCell != null) {
                    FocusCellOwnerDrawHighlighter.this.removeSelectionInformation(null, this.oldFocusCell);
                }
                Widget[] selection = this.getSelectedItems();
                ViewerCell focusCell = FocusCellOwnerDrawHighlighter.this.getFocusCell();
                int index = 0;
                if (focusCell != null) {
                    index = focusCell.getColumnIndex();
                } else if (this.oldFocusCell != null) {
                    index = this.oldFocusCell.getColumnIndex();
                }
                int i2 = 0;
                while (i2 < selection.length) {
                    Widget item = selection[i2];
                    ViewerRow row = viewer.getViewerRowFromItem(item);
                    ViewerCell cell = row.getCell(index);
                    FocusCellOwnerDrawHighlighter.this.markFocusedCell(null, cell);
                    ++i2;
                }
                this.oldSelection = selection;
                this.oldFocusCell = focusCell;
            }

            private Widget[] getSelectedItems() {
                Control control = viewer.getControl();
                Widget[] result = null;
                if (control instanceof Table) {
                    result = ((Table)control).getSelection();
                } else if (control instanceof Tree) {
                    result = ((Tree)control).getSelection();
                }
                return result;
            }
        });
    }

    protected Color getSelectedCellBackgroundColor(ViewerCell cell) {
        return null;
    }

    protected Color getSelectedCellForegroundColor(ViewerCell cell) {
        return null;
    }

    protected Color getSelectedCellForegroundColorNoFocus(ViewerCell cell) {
        return null;
    }

    protected Color getSelectedCellBackgroundColorNoFocus(ViewerCell cell) {
        return null;
    }

    protected boolean onlyTextHighlighting(ViewerCell cell) {
        return true;
    }

    protected void init() {
        ColumnViewerEditorActivationListener listener = new ColumnViewerEditorActivationListener(){

            public void afterEditorActivated(ColumnViewerEditorActivationEvent e) {
            }

            public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent e) {
                FocusCellOwnerDrawHighlighter.this.focusCellChanged(FocusCellOwnerDrawHighlighter.this.getFocusCell(), null);
            }

            public void beforeEditorActivated(ColumnViewerEditorActivationEvent e) {
            }

            public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent e) {
            }
        };
        ColumnViewerEditor editor = this.viewer.getColumnViewerEditor();
        editor.addEditorActivationListener(listener);
    }

    protected void focusCellChanged(ViewerCell newCell, ViewerCell oldCell) {
        if (oldCell != null) {
            oldCell.setBackground(null);
            oldCell.setForeground(null);
            this.viewer.updateItem(oldCell.getItem(), oldCell.getElement());
        }
        if (newCell != null) {
            this.markFocusedCell(null, newCell);
        }
    }
}

