/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;

class URLImageDescriptor
extends ImageDescriptor {
    private URL url;

    URLImageDescriptor(URL url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (!(o instanceof URLImageDescriptor)) {
            return false;
        }
        return ((URLImageDescriptor)o).url.equals(this.url);
    }

    protected InputStream getStream() {
        try {
            return new BufferedInputStream(this.url.openStream());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return "URLImageDescriptor(" + this.url + ")";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image createImage(boolean returnMissingImageOnError, Device device) {
        Image image;
        String schema;
        String path = this.url.toString();
        int pos = path.indexOf(schema = "bundleentry://");
        if (pos != -1) {
            path = path.substring(pos + schema.length());
        }
        if ((pos = path.indexOf(schema = "bundleresource://")) != -1) {
            path = path.substring(pos + schema.length());
        }
        if ((pos = path.indexOf(schema = "platform:/")) != -1) {
            path = path.substring(pos + schema.length());
        }
        InputStream stream = this.getStream();
        try {
            image = Graphics.getImage((String)path, (InputStream)stream);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (IOException iOException) {
            return image;
        }
        stream.close();
        return image;
    }
}

