/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.clabelkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class CLabelLCA
extends AbstractWidgetLCA {
    private static final String PROP_TEXT = "text";
    private static final String PROP_ALIGNMENT = "alignment";
    private static final String PROP_IMAGE = "image";
    private static final Integer DEFAULT_ALIGNMENT = new Integer(16384);

    public void preserveValues(Widget widget) {
        CLabel label = (CLabel)widget;
        ControlLCAUtil.preserveValues((Control)label);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)label);
        adapter.preserve(PROP_TEXT, (Object)label.getText());
        adapter.preserve(PROP_IMAGE, (Object)label.getImage());
        adapter.preserve(PROP_ALIGNMENT, (Object)new Integer(label.getAlignment()));
        WidgetLCAUtil.preserveCustomVariant((Widget)label);
    }

    public void readData(Widget widget) {
        ControlLCAUtil.processMouseEvents((Control)((CLabel)widget));
        ControlLCAUtil.processKeyEvents((Control)((CLabel)widget));
    }

    public void renderInitialization(Widget widget) throws IOException {
        CLabel label = (CLabel)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)label);
        writer.newWidget("qx.ui.basic.Atom");
        if ((widget.getStyle() & 4) != 0) {
            writer.call("addState", new Object[]{"rwt_SHADOW_IN"});
        } else if ((widget.getStyle() & 8) != 0) {
            writer.call("addState", new Object[]{"rwt_SHADOW_OUT"});
        }
        ControlLCAUtil.writeStyleFlags((Control)label);
        Object[] args = new Object[]{label};
        writer.callStatic("org.eclipse.swt.CLabelUtil.initialize", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        CLabel label = (CLabel)widget;
        ControlLCAUtil.writeChanges((Control)label);
        CLabelLCA.writeText(label);
        CLabelLCA.writeImage(label);
        CLabelLCA.writeAlignment(label);
        WidgetLCAUtil.writeCustomVariant((Widget)label);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static void writeText(CLabel label) throws IOException {
        if (WidgetLCAUtil.hasChanged((Widget)label, PROP_TEXT, label.getText(), "")) {
            JSWriter writer = JSWriter.getWriterFor((Widget)label);
            writer.set("label", label.getText());
        }
    }

    private static void writeImage(CLabel label) throws IOException {
        Image image = label.getImage();
        if (WidgetLCAUtil.hasChanged((Widget)label, PROP_IMAGE, image, null)) {
            String imagePath = image == null ? null : ResourceFactory.getImagePath((Image)image);
            JSWriter writer = JSWriter.getWriterFor((Widget)label);
            writer.set("icon", imagePath);
        }
    }

    private static void writeAlignment(CLabel label) throws IOException {
        Integer defValue;
        Integer alignment = new Integer(label.getAlignment());
        if (WidgetLCAUtil.hasChanged((Widget)label, PROP_ALIGNMENT, alignment, defValue = DEFAULT_ALIGNMENT)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)label);
            Object[] args = new Object[]{label, CLabelLCA.getAlignment(label.getAlignment())};
            writer.callStatic("org.eclipse.swt.LabelUtil.setAlignment", args);
        }
    }

    private static String getAlignment(int alignment) {
        String result = (alignment & 0x4000) != 0 ? "left" : ((alignment & 0x1000000) != 0 ? "center" : ((alignment & 0x20000) != 0 ? "right" : "left"));
        return result;
    }
}

