/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.buttonkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

final class ButtonLCAUtil {
    private static final String JS_PROP_SELECTION = "selection";
    private static final String JS_PROP_HORIZONTAL_CHILDREN_ALIGN = "horizontalChildrenAlign";
    static final String PROP_SELECTION = "selection";
    static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_DEFAULT = "defaultButton";
    private static final String PARAM_SELECTION = "selection";
    private static final Integer DEFAULT_ALIGNMENT = new Integer(0x1000000);

    private ButtonLCAUtil() {
    }

    static boolean readSelection(Button button) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)button, "selection");
        if (value != null) {
            button.setSelection(Boolean.valueOf(value).booleanValue());
        }
        return value != null;
    }

    static void preserveValues(Button button) {
        ControlLCAUtil.preserveValues((Control)button);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)button);
        adapter.preserve("text", (Object)button.getText());
        adapter.preserve("image", (Object)button.getImage());
        adapter.preserve("selection", (Object)button.getSelection());
        adapter.preserve("selectionListeners", (Object)SelectionEvent.hasListener((Adaptable)button));
        adapter.preserve(PROP_ALIGNMENT, (Object)new Integer(button.getAlignment()));
        adapter.preserve(PROP_DEFAULT, (Object)ButtonLCAUtil.isDefaultButton(button));
    }

    static void writeText(Button button) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)button);
        String text = button.getText();
        if (WidgetLCAUtil.hasChanged((Widget)button, "text", text, "")) {
            text = WidgetLCAUtil.escapeText(text, true);
            writer.set("label", text);
        }
    }

    static void resetText() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.set("label", "");
    }

    static void writeImage(Button button) throws IOException {
        Image image = button.getImage();
        if (WidgetLCAUtil.hasChanged((Widget)button, "image", image, null)) {
            String imagePath = image == null ? "" : ResourceFactory.getImagePath((Image)image);
            JSWriter writer = JSWriter.getWriterFor((Widget)button);
            writer.set("icon", imagePath);
        }
    }

    static void resetImage() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset("icon");
    }

    static void writeAlignment(Button button) throws IOException {
        Integer defValue;
        Integer newValue;
        if ((button.getStyle() & 4) == 0 && WidgetLCAUtil.hasChanged((Widget)button, PROP_ALIGNMENT, newValue = new Integer(button.getAlignment()), defValue = DEFAULT_ALIGNMENT)) {
            String value;
            JSWriter writer = JSWriter.getWriterFor((Widget)button);
            switch (newValue) {
                case 16384: {
                    value = "left";
                    break;
                }
                case 0x1000000: {
                    value = "center";
                    break;
                }
                case 131072: {
                    value = "right";
                    break;
                }
                default: {
                    value = "left";
                }
            }
            writer.set(JS_PROP_HORIZONTAL_CHILDREN_ALIGN, value);
        }
    }

    static void resetAlignment() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset(JS_PROP_HORIZONTAL_CHILDREN_ALIGN);
    }

    static void writeSelection(Button button) throws IOException {
        Boolean newValue = button.getSelection();
        JSWriter writer = JSWriter.getWriterFor((Widget)button);
        writer.set("selection", "selection", newValue, Boolean.FALSE);
    }

    static void resetSelection() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.set("selection", Boolean.FALSE);
    }

    static void writeDefault(Button button) throws IOException {
        boolean isDefault = ButtonLCAUtil.isDefaultButton(button);
        Boolean defValue = false;
        Boolean actValue = isDefault;
        if (WidgetLCAUtil.hasChanged((Widget)button, PROP_DEFAULT, actValue, defValue) && isDefault) {
            JSWriter writer = JSWriter.getWriterFor((Widget)button.getShell());
            writer.set(PROP_DEFAULT, new Object[]{button});
        }
    }

    static void writeLabelMode(Button button) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)button);
        writer.callStatic("org.eclipse.swt.ButtonUtil.setLabelMode", new Object[]{button});
    }

    static boolean isDefaultButton(Button button) {
        return button.getShell().getDefaultButton() == button;
    }
}

