/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemDelegateLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemLCAUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

final class RadioMenuItemLCA
extends MenuItemDelegateLCA {
    private static final String PROP_SELECTION = "selection";
    private static final JSListenerInfo JS_LISTENER_INFO = new JSListenerInfo("execute", "org.eclipse.swt.MenuUtil.radioMenuItemSelected", JSListenerType.STATE_AND_ACTION);

    RadioMenuItemLCA() {
    }

    void preserveValues(MenuItem menuItem) {
        ItemLCAUtil.preserve((Item)menuItem);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)menuItem);
        boolean hasListener = SelectionEvent.hasListener((Adaptable)menuItem);
        adapter.preserve("selectionListeners", (Object)hasListener);
        adapter.preserve(PROP_SELECTION, (Object)menuItem.getSelection());
        MenuItemLCAUtil.preserveEnabled(menuItem);
        WidgetLCAUtil.preserveCustomVariant((Widget)menuItem);
    }

    void readData(MenuItem menuItem) {
        String paramValue = WidgetLCAUtil.readPropertyValue((Widget)menuItem, PROP_SELECTION);
        if (paramValue != null) {
            boolean selection = Boolean.valueOf(paramValue);
            if (selection) {
                RadioMenuItemLCA.deselectRadioItems(menuItem);
            }
            menuItem.setSelection(selection);
        }
        ControlLCAUtil.processSelection((Widget)menuItem, null, false);
    }

    void renderInitialization(MenuItem menuItem) throws IOException {
        MenuItemLCAUtil.newItem(menuItem, "qx.ui.menu.RadioButton", true);
        MenuItem firstSiblingItem = RadioMenuItemLCA.getFirstSiblingRadioItem(menuItem);
        JSWriter writer = JSWriter.getWriterFor((Widget)menuItem);
        if (firstSiblingItem == menuItem) {
            writer.callStatic("org.eclipse.swt.MenuUtil.createRadioManager", new Object[]{menuItem});
        } else {
            writer.callStatic("org.eclipse.swt.MenuUtil.assignRadioManager", new Object[]{firstSiblingItem, menuItem});
        }
    }

    void renderChanges(MenuItem menuItem) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)menuItem);
        MenuItemLCAUtil.writeImageAndText(menuItem);
        writer.updateListener(JS_LISTENER_INFO, "selectionListeners", SelectionEvent.hasListener((Adaptable)menuItem));
        writer.set(PROP_SELECTION, "checked", menuItem.getSelection(), Boolean.FALSE);
        MenuItemLCAUtil.writeEnabled(menuItem);
        WidgetLCAUtil.writeCustomVariant((Widget)menuItem);
    }

    void renderDispose(MenuItem menuItem) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)menuItem);
        writer.callStatic("org.eclipse.swt.MenuUtil.disposeRadioMenuItem", new Object[]{menuItem});
    }

    private static void deselectRadioItems(MenuItem menuItem) {
        MenuItem[] items = RadioMenuItemLCA.getSiblingRadioItems(menuItem);
        int i = 0;
        while (i < items.length) {
            items[i].setSelection(false);
            ++i;
        }
    }

    private static MenuItem[] getSiblingRadioItems(MenuItem menuItem) {
        MenuItem item;
        ArrayList<MenuItem> radioItems = new ArrayList<MenuItem>();
        MenuItem[] siblingMenuItems = menuItem.getParent().getItems();
        int index = menuItem.getParent().indexOf(menuItem) - 1;
        boolean isRadioItem = true;
        while (index >= 0 && isRadioItem) {
            item = siblingMenuItems[index];
            if ((item.getStyle() & 0x10) != 0) {
                radioItems.add(item);
            } else {
                isRadioItem = false;
            }
            --index;
        }
        index = menuItem.getParent().indexOf(menuItem) + 1;
        isRadioItem = true;
        while (index < siblingMenuItems.length && isRadioItem) {
            item = siblingMenuItems[index];
            if ((item.getStyle() & 0x10) != 0) {
                radioItems.add(item);
            } else {
                isRadioItem = false;
            }
            ++index;
        }
        MenuItem[] result = new MenuItem[radioItems.size()];
        radioItems.toArray(result);
        return result;
    }

    private static MenuItem getFirstSiblingRadioItem(MenuItem menuItem) {
        MenuItem result = menuItem;
        MenuItem[] siblingMenuItems = menuItem.getParent().getItems();
        int index = menuItem.getParent().indexOf(menuItem) - 1;
        while (index >= 0) {
            if ((siblingMenuItems[index].getStyle() & 0x10) != 0) {
                result = siblingMenuItems[index];
            }
            --index;
        }
        return result;
    }
}

