/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.shellkit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.ActivateEvent;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.EventUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class ShellLCA
extends AbstractWidgetLCA {
    private static final String QX_TYPE = "org.eclipse.swt.widgets.Shell";
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_ALPHA = "alpha";
    static final String PROP_ACTIVE_CONTROL = "activeControl";
    static final String PROP_ACTIVE_SHELL = "activeShell";
    static final String PROP_MODE = "mode";
    static final String PROP_SHELL_LISTENER = "shellListener";
    private static final String PROP_SHELL_MENU = "menuBar";
    private static final String PROP_SHELL_MENU_BOUNDS = "menuBarShellClientArea";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void preserveValues(Widget widget) {
        ControlLCAUtil.preserveValues((Control)widget);
        Shell shell = (Shell)widget;
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)shell);
        adapter.preserve(PROP_ACTIVE_CONTROL, (Object)ShellLCA.getActiveControl(shell));
        adapter.preserve(PROP_ACTIVE_SHELL, (Object)shell.getDisplay().getActiveShell());
        adapter.preserve(PROP_TEXT, (Object)shell.getText());
        adapter.preserve(PROP_IMAGE, (Object)shell.getImage());
        adapter.preserve(PROP_ALPHA, (Object)new Integer(shell.getAlpha()));
        adapter.preserve(PROP_MODE, (Object)ShellLCA.getMode(shell));
        adapter.preserve(PROP_SHELL_LISTENER, (Object)ShellEvent.hasListener((Adaptable)shell));
        adapter.preserve(PROP_SHELL_MENU, (Object)shell.getMenuBar());
        WidgetLCAUtil.preserveCustomVariant((Widget)shell);
    }

    public void readData(Widget widget) {
        Shell shell = (Shell)widget;
        ShellLCA.preserveMenuBounds(shell);
        ControlLCAUtil.readBounds((Control)shell);
        ShellLCA.readMode(shell);
        if (WidgetLCAUtil.wasEventSent((Widget)shell, "org.eclipse.swt.widgets.Shell_close")) {
            shell.close();
        }
        ShellLCA.processActiveShell(shell);
        ShellLCA.processActivate(shell);
        ControlLCAUtil.processMouseEvents((Control)shell);
        ControlLCAUtil.processKeyEvents((Control)shell);
    }

    public void renderInitialization(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        Shell shell = (Shell)widget;
        writer.newWidget(QX_TYPE);
        ControlLCAUtil.writeStyleFlags((Control)shell);
        int style = widget.getStyle();
        if ((style & 0x10000) != 0) {
            writer.call("addState", new Object[]{"rwt_APPLICATION_MODAL"});
        }
        if ((style & 0x4000) != 0) {
            writer.call("addState", new Object[]{"rwt_ON_TOP"});
        }
        if ((style & 0x20) != 0) {
            writer.call("addState", new Object[]{"rwt_TITLE"});
        }
        writer.set("showMinimize", (style & 0x80) != 0);
        writer.set("allowMinimize", (style & 0x80) != 0);
        writer.set("showMaximize", (style & 0x400) != 0);
        writer.set("allowMaximize", (style & 0x400) != 0);
        writer.set("showClose", (style & 0x40) != 0);
        writer.set("allowClose", (style & 0x40) != 0);
        Boolean resizable = (style & 0x10) != 0;
        writer.set("resizable", new Object[]{resizable, resizable, resizable, resizable});
        Composite parent = shell.getParent();
        if (parent instanceof Shell) {
            writer.set("parentShell", parent);
        }
        writer.call("initialize", null);
        ControlLCAUtil.writeResizeNotificator(widget);
        ControlLCAUtil.writeMoveNotificator(widget);
    }

    public void renderChanges(Widget widget) throws IOException {
        Shell shell = (Shell)widget;
        ControlLCAUtil.writeChanges((Control)shell);
        ShellLCA.writeImage(shell);
        ShellLCA.writeText(shell);
        this.writeAlpha(shell);
        ShellLCA.writeOpen(shell);
        ShellLCA.writeActiveShell(shell);
        ShellLCA.writeMode(shell);
        ShellLCA.writeCloseListener(shell);
        WidgetLCAUtil.writeCustomVariant((Widget)shell);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.call("doClose", null);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.call("removeState", new Object[]{"rwt_TITLE"});
        writer.set("parentShell", (Object)null);
        ControlLCAUtil.resetStyleFlags();
        ControlLCAUtil.resetResizeNotificator();
        ControlLCAUtil.resetMoveNotificator();
        ControlLCAUtil.resetBounds();
        ControlLCAUtil.resetZIndex();
        ControlLCAUtil.resetToolTip();
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static void writeText(Shell shell) throws IOException {
        String text = shell.getText();
        if (WidgetLCAUtil.hasChanged((Widget)shell, PROP_TEXT, text, "")) {
            JSWriter writer = JSWriter.getWriterFor((Widget)shell);
            text = WidgetLCAUtil.escapeText(text, false);
            writer.set("caption", text);
        }
    }

    private void writeAlpha(Shell shell) throws IOException {
        int alpha = shell.getAlpha();
        if (WidgetLCAUtil.hasChanged((Widget)shell, PROP_ALPHA, new Integer(alpha), new Integer(255))) {
            JSWriter writer = JSWriter.getWriterFor((Widget)shell);
            float opacity = (float)((alpha & 0xFF) * 1000 / 255) / 1000.0f;
            writer.set("opacity", opacity);
        }
    }

    private static void writeOpen(Shell shell) throws IOException {
        Boolean defValue = Boolean.FALSE;
        Boolean actValue = shell.getVisible();
        if (WidgetLCAUtil.hasChanged((Widget)shell, "visible", actValue, defValue) && shell.getVisible()) {
            JSWriter writer = JSWriter.getWriterFor((Widget)shell);
            writer.call("open", null);
        }
    }

    private static void writeActiveShell(Shell shell) throws IOException {
        Shell activeShell = shell.getDisplay().getActiveShell();
        boolean hasChanged = WidgetLCAUtil.hasChanged((Widget)shell, PROP_ACTIVE_SHELL, activeShell, null);
        if (shell == activeShell && hasChanged) {
            JSWriter writer = JSWriter.getWriterFor((Widget)shell);
            writer.set("active", true);
        }
    }

    private static void processActiveShell(Shell shell) {
        if (WidgetLCAUtil.wasEventSent((Widget)shell, "org.eclipse.swt.events.shellActivated")) {
            ActivateEvent event;
            Shell lastActiveShell = shell.getDisplay().getActiveShell();
            ShellLCA.setActiveShell(shell);
            if (lastActiveShell != null) {
                event = new ActivateEvent((Control)lastActiveShell, 27);
                event.processEvent();
            }
            event = new ActivateEvent((Control)shell, 26);
            event.processEvent();
        }
    }

    private static void setActiveShell(Shell shell) {
        Display display = shell.getDisplay();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = display.getAdapter((Class)clazz);
        IDisplayAdapter displayAdapter = (IDisplayAdapter)adapter;
        displayAdapter.setActiveShell(shell);
    }

    public static void writeActiveControl(Shell shell) throws IOException {
        String prop = PROP_ACTIVE_CONTROL;
        Control activeControl = ShellLCA.getActiveControl(shell);
        if (WidgetLCAUtil.hasChanged((Widget)shell, prop, activeControl, null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)shell);
            writer.set(PROP_ACTIVE_CONTROL, new Object[]{activeControl});
        }
    }

    private static void processActivate(Shell shell) {
        HttpServletRequest request = ContextProvider.getRequest();
        String widgetId = request.getParameter("org.eclipse.swt.events.controlActivated");
        if (widgetId != null) {
            Widget widget = WidgetUtil.find((Composite)shell, (String)widgetId);
            if (widget != null) {
                ShellLCA.setActiveControl(shell, widget);
            }
        } else {
            String activeControlId = WidgetLCAUtil.readPropertyValue((Widget)shell, PROP_ACTIVE_CONTROL);
            Widget widget = WidgetUtil.find((Composite)shell, (String)activeControlId);
            if (widget != null) {
                ShellLCA.setActiveControl(shell, widget);
            }
        }
    }

    private static Control getActiveControl(Shell shell) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IShellAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = shell.getAdapter((Class)clazz);
        IShellAdapter shellAdapter = (IShellAdapter)adapter;
        Control activeControl = shellAdapter.getActiveControl();
        return activeControl;
    }

    private static void setActiveControl(Shell shell, Widget widget) {
        if (EventUtil.isAccessible((Widget)widget)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IShellAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = shell.getAdapter((Class)clazz);
            IShellAdapter shellAdapter = (IShellAdapter)adapter;
            shellAdapter.setActiveControl((Control)widget);
        }
    }

    private static void writeImage(Shell shell) throws IOException {
        Image image;
        if (ShellLCA.showImage(shell) && WidgetLCAUtil.hasChanged((Widget)shell, PROP_IMAGE, image = shell.getImage(), null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)shell);
            writer.set("icon", ResourceFactory.getImagePath((Image)image));
        }
    }

    private static boolean showImage(Shell shell) {
        return (shell.getStyle() & 0x4C0) != 0;
    }

    private static void readMode(Shell shell) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)shell, PROP_MODE);
        if (value != null) {
            if ("maximized".equals(value)) {
                shell.setMaximized(true);
            } else if ("minimized".equals(value)) {
                shell.setMinimized(true);
            } else {
                shell.setMinimized(false);
                shell.setMaximized(false);
            }
        }
    }

    private static void writeMode(Shell shell) throws IOException {
        Object defValue = null;
        String newValue = ShellLCA.getMode(shell);
        if (WidgetLCAUtil.hasChanged((Widget)shell, PROP_MODE, newValue, defValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)shell);
            writer.set(PROP_MODE, (Object)newValue);
        }
    }

    private static void writeCloseListener(Shell shell) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)shell);
        Boolean newValue = ShellEvent.hasListener((Adaptable)shell);
        Boolean defValue = Boolean.FALSE;
        writer.set(PROP_SHELL_LISTENER, "hasShellListener", newValue, defValue);
    }

    private static String getMode(Shell shell) {
        String result = null;
        if (shell.getMinimized()) {
            result = "minimized";
        } else if (shell.getMaximized()) {
            result = "maximized";
        }
        return result;
    }

    private static void preserveMenuBounds(Shell shell) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IShellAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = shell.getAdapter((Class)clazz);
        IShellAdapter shellAdapter = (IShellAdapter)adapter;
        Rectangle menuBounds = shellAdapter.getMenuBounds();
        IWidgetAdapter widgetAdapter = WidgetUtil.getAdapter((Widget)shell);
        widgetAdapter.preserve(PROP_SHELL_MENU_BOUNDS, (Object)menuBounds);
    }
}

