/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.toolitemkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.IToolItemAdapter;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

final class ToolItemLCAUtil {
    private static final String PROP_VISIBLE = "visible";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_HOT_IMAGE = "hotImage";
    private static final String PROP_SELECTION = "selection";
    static /* synthetic */ Class class$0;

    private ToolItemLCAUtil() {
    }

    static void preserveValues(ToolItem toolItem) {
        ItemLCAUtil.preserve((Item)toolItem);
        WidgetLCAUtil.preserveEnabled((Widget)toolItem, toolItem.getEnabled());
        WidgetLCAUtil.preserveToolTipText((Widget)toolItem, toolItem.getToolTipText());
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)toolItem);
        adapter.preserve(PROP_VISIBLE, (Object)ToolItemLCAUtil.isVisible(toolItem));
        boolean hasListener = SelectionEvent.hasListener((Adaptable)toolItem);
        adapter.preserve("selectionListeners", (Object)hasListener);
        adapter.preserve("bounds", (Object)toolItem.getBounds());
    }

    static void preserveSelection(ToolItem toolItem) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)toolItem);
        adapter.preserve(PROP_SELECTION, (Object)toolItem.getSelection());
    }

    static void writeSelection(ToolItem toolItem, boolean selection) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
        Boolean newValue = selection;
        Boolean defValue = Boolean.FALSE;
        writer.set(PROP_SELECTION, "checked", newValue, defValue);
    }

    static void processSelection(ToolItem toolItem) {
        if (WidgetLCAUtil.wasEventSent((Widget)toolItem, "org.eclipse.swt.events.widgetSelected")) {
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            SelectionEvent event = ToolItemLCAUtil.newSelectionEvent((Widget)toolItem, bounds, 0);
            event.processEvent();
        }
    }

    static SelectionEvent newSelectionEvent(Widget widget, Rectangle bounds, int detail) {
        return new SelectionEvent(widget, null, 13, bounds, null, true, detail);
    }

    static void writeVisible(ToolItem item) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IToolItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = item.getAdapter((Class)clazz);
        IToolItemAdapter tia = (IToolItemAdapter)adapter;
        Boolean newValue = tia.getVisible();
        Boolean defValue = Boolean.TRUE;
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        writer.set(PROP_VISIBLE, "visibility", newValue, defValue);
    }

    private static boolean isVisible(ToolItem toolItem) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IToolItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = toolItem.getAdapter((Class)clazz);
        IToolItemAdapter toolItemAdapter = (IToolItemAdapter)adapter;
        return toolItemAdapter.getVisible();
    }

    static void writeBounds(ToolItem toolItem) throws IOException {
        Rectangle bounds = toolItem.getBounds();
        if ((toolItem.getStyle() & 4) != 0) {
            bounds.width -= 15;
        }
        WidgetLCAUtil.writeBounds((Widget)toolItem, (Control)toolItem.getParent(), bounds);
    }

    static void preserveImages(ToolItem toolItem) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)toolItem);
        adapter.preserve(PROP_IMAGE, (Object)ToolItemLCAUtil.getImage(toolItem));
        adapter.preserve(PROP_HOT_IMAGE, (Object)toolItem.getHotImage());
    }

    static void writeImages(ToolItem toolItem) throws IOException {
        Image hotImage;
        Image image = ToolItemLCAUtil.getImage(toolItem);
        if (WidgetLCAUtil.hasChanged((Widget)toolItem, PROP_IMAGE, image, null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
            Object[] args = new Object[]{toolItem, ToolItemLCAUtil.getImagePath(image)};
            writer.callStatic("org.eclipse.swt.ToolItemUtil.setImage", args);
        }
        if (WidgetLCAUtil.hasChanged((Widget)toolItem, PROP_HOT_IMAGE, hotImage = toolItem.getHotImage(), null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
            Object[] args = new Object[]{toolItem, ToolItemLCAUtil.getImagePath(hotImage)};
            writer.callStatic("org.eclipse.swt.ToolItemUtil.setHotImage", args);
        }
    }

    static Image getImage(ToolItem toolItem) {
        Image result;
        if (toolItem.getEnabled() && toolItem.getParent().getEnabled()) {
            result = toolItem.getImage();
        } else {
            result = toolItem.getDisabledImage();
            if (result == null) {
                result = toolItem.getImage();
            }
        }
        return result;
    }

    private static String getImagePath(Image image) {
        return image == null ? null : ResourceFactory.getImagePath((Image)image);
    }
}

