/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.lifecycle;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.lifecycle.CommonPatterns;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;

public final class WidgetLCAUtil {
    private static final String JS_PROP_HEIGHT = "height";
    private static final String JS_PROP_WIDTH = "width";
    private static final String JS_PROP_CLIP_WIDTH = "clipWidth";
    private static final String JS_PROP_CLIP_HEIGHT = "clipHeight";
    private static final String PARAM_X = "bounds.x";
    private static final String PARAM_Y = "bounds.y";
    private static final String PARAM_WIDTH = "bounds.width";
    private static final String PARAM_HEIGHT = "bounds.height";
    private static final String PROP_TOOL_TIP_TEXT = "toolTip";
    private static final String PROP_FONT = "font";
    private static final String PROP_FOREGROUND = "foreground";
    private static final String PROP_BACKGROUND = "background";
    private static final String PROP_BACKGROUND_TRANSPARENCY = "backgroundTrans";
    private static final String PROP_ENABLED = "enabled";
    private static final String PROP_VARIANT = "variant";
    private static final String JS_PROP_SPACE = "space";
    private static final String JS_PROP_CONTEXT_MENU = "contextMenu";
    private static final String JS_FUNC_SET_TOOL_TIP = "setToolTip";
    private static final Pattern HTML_ESCAPE_PATTERN = Pattern.compile("&|<|>|\\\"");
    private static final Pattern FONT_NAME_FILTER_PATTERN = Pattern.compile("\"|\\\\");
    private static final Map parsedFonts = new HashMap();

    private WidgetLCAUtil() {
    }

    public static void preserveToolTipText(Widget widget, String toolTip) {
        String text = toolTip == null ? "" : toolTip;
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_TOOL_TIP_TEXT, (Object)text);
    }

    public static void preserveFont(Widget widget, Font font) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_FONT, (Object)font);
    }

    public static void preserveForeground(Widget widget, Color foreground) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_FOREGROUND, (Object)foreground);
    }

    public static void preserveBackground(Widget widget, Color background) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_BACKGROUND, (Object)background);
    }

    public static void preserveBackground(Widget widget, Color background, boolean transparency) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_BACKGROUND, (Object)background);
        adapter.preserve(PROP_BACKGROUND_TRANSPARENCY, (Object)transparency);
    }

    public static void preserveEnabled(Widget widget, boolean enabled) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_ENABLED, (Object)enabled);
    }

    public static void preserveCustomVariant(Widget widget) {
        String variant = WidgetUtil.getVariant((Widget)widget);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_VARIANT, (Object)variant);
    }

    public static boolean hasChanged(Widget widget, String property, Object newValue) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        Object oldValue = adapter.getPreserved(property);
        return !WidgetLCAUtil.equals(oldValue, newValue);
    }

    public static boolean hasChanged(Widget widget, String property, Object newValue, Object defaultValue) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        boolean result = adapter.isInitialized() ? WidgetLCAUtil.hasChanged(widget, property, newValue) : !WidgetLCAUtil.equals(newValue, defaultValue);
        return result;
    }

    public static String readPropertyValue(Widget widget, String propertyName) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer key = new StringBuffer();
        key.append(WidgetUtil.getId((Widget)widget));
        key.append(".");
        key.append(propertyName);
        return request.getParameter(key.toString());
    }

    public static boolean wasEventSent(Widget widget, String eventName) {
        HttpServletRequest request = ContextProvider.getRequest();
        String widgetId = request.getParameter(eventName);
        return WidgetUtil.getId((Widget)widget).equals(widgetId);
    }

    public static Rectangle readBounds(Widget widget, Rectangle defValue) {
        return WidgetLCAUtil.readBounds(WidgetUtil.getId((Widget)widget), defValue);
    }

    public static Rectangle readBounds(String widgetId, Rectangle defValue) {
        int x = WidgetLCAUtil.readBoundsX(widgetId, defValue.x);
        int y = WidgetLCAUtil.readBoundsY(widgetId, defValue.y);
        int width = WidgetLCAUtil.readBoundsWidth(widgetId, defValue.width);
        int height = WidgetLCAUtil.readBoundsHeight(widgetId, defValue.height);
        return new Rectangle(x, y, width, height);
    }

    public static void writeBounds(Widget widget, Control parent, Rectangle bounds) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        Rectangle oldBounds = (Rectangle)adapter.getPreserved("bounds");
        Rectangle newBounds = bounds;
        if (!adapter.isInitialized() || !newBounds.equals((Object)oldBounds)) {
            if (parent != null) {
                AbstractWidgetLCA parentLCA = WidgetUtil.getLCA((Widget)parent);
                newBounds = parentLCA.adjustCoordinates(widget, newBounds);
            }
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (parent instanceof ScrolledComposite || parent instanceof ToolBar) {
                writer.set(JS_PROP_WIDTH, newBounds.width);
                writer.set(JS_PROP_HEIGHT, newBounds.height);
            } else {
                Object[] args = new Integer[]{new Integer(newBounds.x), new Integer(newBounds.width), new Integer(newBounds.y), new Integer(newBounds.height)};
                writer.set(JS_PROP_SPACE, args);
            }
        }
    }

    public static void resetBounds() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset(JS_PROP_CLIP_WIDTH);
        writer.reset(JS_PROP_CLIP_HEIGHT);
        writer.set(JS_PROP_SPACE, new int[4]);
    }

    public static void writeMenu(Widget widget, Menu menu) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, "menu", menu, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            writer.set(JS_PROP_CONTEXT_MENU, menu);
            if (menu == null) {
                writer.removeListener("contextmenu", "org.eclipse.swt.MenuUtil.contextMenu");
            } else {
                writer.addListener("contextmenu", "org.eclipse.swt.MenuUtil.contextMenu");
            }
        }
    }

    public static void resetMenu() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset(JS_PROP_CONTEXT_MENU);
        writer.removeListener("contextmenu", "org.eclipse.swt.MenuUtil.contextMenu");
    }

    public static void writeToolTip(Widget widget, String toolTip) throws IOException {
        String text;
        String string = text = toolTip == null ? "" : toolTip;
        if (WidgetLCAUtil.hasChanged(widget, PROP_TOOL_TIP_TEXT, text, "")) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            text = WidgetLCAUtil.escapeText(text, false);
            text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            Object[] args = new Object[]{widget, text};
            writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_TOOL_TIP, args);
        }
    }

    public static void resetToolTip() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.call(JSWriter.WIDGET_MANAGER_REF, JS_FUNC_SET_TOOL_TIP, new Object[]{JSWriter.WIDGET_REF});
    }

    public static void writeImage(Widget widget, Image image) throws IOException {
        WidgetLCAUtil.writeImage(widget, "image", "icon", image);
    }

    public static void writeImage(Widget widget, String javaProperty, String jsProperty, Image image) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, javaProperty, image, null)) {
            WidgetLCAUtil.writeImage(widget, jsProperty, image);
        }
    }

    public static void writeImage(Widget widget, String jsProperty, Image image) throws IOException {
        String path = image == null ? null : ResourceFactory.getImagePath((Image)image);
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.set(jsProperty, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] parseFontName(String name) {
        Map map = parsedFonts;
        synchronized (map) {
            String[] result = (String[])parsedFonts.get(name);
            if (result == null) {
                result = name.split(",");
                int i = 0;
                while (i < result.length) {
                    result[i] = result[i].trim();
                    Matcher matcher = FONT_NAME_FILTER_PATTERN.matcher(result[i]);
                    result[i] = matcher.replaceAll("");
                    ++i;
                }
                parsedFonts.put(name, result);
            }
            return result;
        }
    }

    public static void writeFont(Widget widget, Font font) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FONT, font, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (font != null) {
                FontData fontData = font.getFontData()[0];
                String[] names = WidgetLCAUtil.parseFontName(fontData.getName());
                Object[] args = new Object[]{widget, names, new Integer(fontData.getHeight()), (fontData.getStyle() & 1) != 0, (fontData.getStyle() & 2) != 0};
                writer.call(JSWriter.WIDGET_MANAGER_REF, "setFont", args);
            } else {
                writer.reset(PROP_FONT);
            }
        }
    }

    public static void resetFont() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset(PROP_FONT);
    }

    public static void writeForeground(Widget widget, Color newColor) throws IOException {
        if (WidgetLCAUtil.hasChanged(widget, PROP_FOREGROUND, newColor, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            if (newColor != null) {
                writer.set("textColor", newColor);
            } else {
                writer.reset("textColor");
            }
        }
    }

    public static void resetForeground() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset("textColor");
        String listener = "org.eclipse.swt.WidgetManager._onAppearSetForeground";
        writer.removeListener("appear", listener);
    }

    public static void writeBackground(Widget widget, Color newColor) throws IOException {
        WidgetLCAUtil.writeBackground(widget, newColor, false);
    }

    public static void writeBackground(Widget widget, Color background, boolean transparency) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        boolean changed = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND_TRANSPARENCY, transparency, Boolean.FALSE);
        if (!changed && !transparency) {
            changed = WidgetLCAUtil.hasChanged(widget, PROP_BACKGROUND, background, null);
        }
        if (changed) {
            if (transparency) {
                writer.set("backgroundColor", (Object)null);
            } else if (background != null) {
                writer.set("backgroundColor", background);
            } else {
                writer.reset("backgroundColor");
            }
        }
    }

    public static void resetBackground() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset("backgroundColor");
    }

    public static void writeEnabled(Widget widget, boolean enabled) throws IOException {
        Boolean newValue = enabled;
        JSWriter writer = JSWriter.getWriterFor(widget);
        Boolean defValue = Boolean.TRUE;
        writer.set(PROP_ENABLED, PROP_ENABLED, newValue, defValue);
    }

    public static void resetEnabled() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.set(PROP_ENABLED, true);
    }

    public static String replaceNewLines(String input, String replacement) {
        return CommonPatterns.replaceNewLines((String)input, (String)replacement);
    }

    public static void writeCustomVariant(Widget widget) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        String oldValue = (String)adapter.getPreserved(PROP_VARIANT);
        String newValue = WidgetUtil.getVariant((Widget)widget);
        if (WidgetLCAUtil.hasChanged(widget, PROP_VARIANT, newValue, null)) {
            JSWriter writer = JSWriter.getWriterFor(widget);
            Object[] args = new Object[]{"variant_" + oldValue};
            if (oldValue != null) {
                writer.call("removeState", args);
            }
            if (newValue != null) {
                args = new Object[]{"variant_" + newValue};
                writer.call("addState", args);
            }
        }
    }

    public static void writeStyleFlag(Widget widget, int style, String styleName) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        if ((widget.getStyle() & style) != 0) {
            writer.call("addState", new Object[]{"rwt_" + styleName});
        }
    }

    private static String readPropertyValue(String widgetId, String propertyName) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer key = new StringBuffer();
        key.append(widgetId);
        key.append(".");
        key.append(propertyName);
        return request.getParameter(key.toString());
    }

    private static int readBoundsY(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_Y);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsX(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_X);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsWidth(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_WIDTH);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsHeight(String widgetId, int defValue) {
        String value = WidgetLCAUtil.readPropertyValue(widgetId, PARAM_HEIGHT);
        return WidgetLCAUtil.readBoundsValue(value, defValue);
    }

    private static int readBoundsValue(String value, int current) {
        int result = value != null && !"null".equals(value) ? Integer.parseInt(value) : current;
        return result;
    }

    static boolean equals(Object object1, Object object2) {
        boolean result = object1 == object2 ? true : (object1 == null ? false : (object1 instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object1, (boolean[])object2) : (object1 instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object1, (int[])object2) : (object1 instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object1, (long[])object2) : (object1 instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object1, (float[])object2) : (object1 instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object1, (double[])object2) : (object1 instanceof Object[] && object2 instanceof Object[] ? Arrays.equals((Object[])object1, (Object[])object2) : object1.equals(object2))))))));
        return result;
    }

    public static String escapeText(String text, boolean mnemonics) {
        int offset = 0;
        boolean insertAmp = false;
        StringBuffer sb = new StringBuffer();
        Matcher matcher = HTML_ESCAPE_PATTERN.matcher(text);
        while (matcher.find()) {
            int index = matcher.start();
            char ch = text.charAt(index);
            if (ch == '&') {
                if (!mnemonics || insertAmp) {
                    insertAmp = false;
                    matcher.appendReplacement(sb, "&amp;");
                    offset += 4;
                    continue;
                }
                if (index + 1 < text.length() && text.charAt(index + 1) == '&') {
                    insertAmp = true;
                }
                matcher.appendReplacement(sb, "");
                --offset;
                continue;
            }
            if (ch == '<') {
                matcher.appendReplacement(sb, "&lt;");
                offset += 3;
                continue;
            }
            if (ch == '>') {
                matcher.appendReplacement(sb, "&gt;");
                offset += 3;
                continue;
            }
            if (ch != '\"') continue;
            matcher.appendReplacement(sb, "&quot;");
            offset += 5;
        }
        matcher.appendTail(sb);
        String result = sb.toString();
        int index = result.indexOf(0);
        if (index != -1) {
            result = result.substring(0, index);
        }
        return result;
    }
}

