/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.scrolledcompositekit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public final class ScrolledCompositeLCA
extends AbstractWidgetLCA {
    private static final String QX_TYPE = "org.eclipse.swt.custom.ScrolledComposite";
    private static final Integer ZERO = new Integer(0);
    private static final String PARAM_H_BAR_SELECTION = "horizontalBar.selection";
    private static final String PARAM_V_BAR_SELECTION = "verticalBar.selection";
    static final String PROP_BOUNDS = "clientArea";
    static final String PROP_OVERFLOW = "overflow";
    private static final String PROP_H_BAR_SELECTION = "hBarSelection";
    private static final String PROP_V_BAR_SELECTION = "vBarSelection";

    public void preserveValues(Widget widget) {
        ScrolledComposite composite = (ScrolledComposite)widget;
        ControlLCAUtil.preserveValues((Control)composite);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)composite);
        adapter.preserve(PROP_BOUNDS, (Object)composite.getBounds());
        adapter.preserve(PROP_OVERFLOW, (Object)ScrolledCompositeLCA.getOverflow(composite));
        adapter.preserve(PROP_H_BAR_SELECTION, (Object)ScrolledCompositeLCA.getBarSelection(composite.getHorizontalBar()));
        adapter.preserve(PROP_V_BAR_SELECTION, (Object)ScrolledCompositeLCA.getBarSelection(composite.getVerticalBar()));
        WidgetLCAUtil.preserveCustomVariant((Widget)composite);
    }

    public void readData(Widget widget) {
        ScrolledComposite composite = (ScrolledComposite)widget;
        String value = WidgetLCAUtil.readPropertyValue(widget, PARAM_H_BAR_SELECTION);
        if (value != null && composite.getHorizontalBar() != null) {
            composite.getHorizontalBar().setSelection(Integer.parseInt(value));
        }
        if ((value = WidgetLCAUtil.readPropertyValue(widget, PARAM_V_BAR_SELECTION)) != null && composite.getVerticalBar() != null) {
            composite.getVerticalBar().setSelection(Integer.parseInt(value));
        }
        ControlLCAUtil.processMouseEvents((Control)composite);
        ControlLCAUtil.processKeyEvents((Control)composite);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ScrolledComposite scrolledComposite = (ScrolledComposite)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)scrolledComposite);
        writer.newWidget(QX_TYPE);
        ControlLCAUtil.writeStyleFlags((Control)scrolledComposite);
    }

    public void renderChanges(Widget widget) throws IOException {
        ScrolledComposite composite = (ScrolledComposite)widget;
        ControlLCAUtil.writeChanges((Control)composite);
        ScrolledCompositeLCA.writeClipBounds(composite);
        ScrolledCompositeLCA.writeScrollBars(composite);
        ScrolledCompositeLCA.writeBarSelection(composite);
        WidgetLCAUtil.writeCustomVariant((Widget)composite);
    }

    public void renderDispose(Widget widget) throws IOException {
        ScrolledComposite composite = (ScrolledComposite)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)composite);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
        ControlLCAUtil.resetChanges();
        ScrolledCompositeLCA.resetClipBounds();
        ScrolledCompositeLCA.resetScrollBars();
        ScrolledCompositeLCA.resetBarSelection();
        ControlLCAUtil.resetStyleFlags();
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static void writeScrollBars(ScrolledComposite composite) throws IOException {
        String overflow = ScrolledCompositeLCA.getOverflow(composite);
        JSWriter writer = JSWriter.getWriterFor((Widget)composite);
        writer.set(PROP_OVERFLOW, PROP_OVERFLOW, overflow, null);
    }

    private static void resetScrollBars() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset(PROP_OVERFLOW);
    }

    private static void writeBarSelection(ScrolledComposite composite) throws IOException {
        Integer vBarSelection;
        JSWriter writer = JSWriter.getWriterFor((Widget)composite);
        Integer hBarSelection = ScrolledCompositeLCA.getBarSelection(composite.getHorizontalBar());
        if (hBarSelection != null) {
            writer.set(PROP_H_BAR_SELECTION, PROP_H_BAR_SELECTION, hBarSelection, ZERO);
        }
        if ((vBarSelection = ScrolledCompositeLCA.getBarSelection(composite.getVerticalBar())) != null) {
            writer.set(PROP_V_BAR_SELECTION, PROP_V_BAR_SELECTION, vBarSelection, ZERO);
        }
    }

    private static void resetBarSelection() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.set(PROP_H_BAR_SELECTION, 0);
        writer.set(PROP_V_BAR_SELECTION, 0);
    }

    private static void writeClipBounds(ScrolledComposite composite) throws IOException {
        Rectangle bounds = composite.getBounds();
        if (WidgetLCAUtil.hasChanged((Widget)composite, PROP_BOUNDS, bounds, null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)composite);
            writer.set("clipWidth", bounds.width);
            writer.set("clipHeight", bounds.height);
        }
    }

    private static void resetClipBounds() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset("clipWidth");
        writer.reset("clipHeight");
    }

    private static String getOverflow(ScrolledComposite composite) {
        boolean scrollY;
        ScrollBar horizontalBar = composite.getHorizontalBar();
        boolean scrollX = horizontalBar != null && horizontalBar.getVisible();
        ScrollBar verticalBar = composite.getVerticalBar();
        boolean bl = scrollY = verticalBar != null && verticalBar.getVisible();
        String result = scrollX && scrollY ? "scroll" : (scrollX ? "scrollX" : (scrollY ? "scrollY" : "hidden"));
        return result;
    }

    private static Integer getBarSelection(ScrollBar scrollBar) {
        Integer result = scrollBar != null && scrollBar.getVisible() ? new Integer(scrollBar.getSelection()) : null;
        return result;
    }
}

