/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.coolitemkit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.lifecycle.JSConst;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ICoolBarAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Widget;

public class CoolItemLCA
extends AbstractWidgetLCA {
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        CoolItem coolItem = (CoolItem)widget;
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)coolItem);
        adapter.preserve("control", (Object)coolItem.getControl());
        adapter.preserve("bounds", (Object)coolItem.getBounds());
        WidgetLCAUtil.preserveCustomVariant((Widget)coolItem);
    }

    public void readData(Widget widget) {
        final CoolItem coolItem = (CoolItem)widget;
        HttpServletRequest request = ContextProvider.getRequest();
        String movedWidgetId = request.getParameter("org.eclipse.swt.events.widgetMoved");
        if (WidgetUtil.getId((Widget)coolItem).equals(movedWidgetId)) {
            String value = WidgetLCAUtil.readPropertyValue((Widget)coolItem, "bounds.x");
            final int x = Integer.parseInt(value);
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    CoolItemLCA.moveItem(coolItem, x);
                }
            });
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        CoolItem coolItem = (CoolItem)widget;
        JSWriter writer = JSWriter.getWriterFor(widget);
        Object[] args = new Object[]{CoolItemLCA.jsOrientation(coolItem)};
        writer.newWidget("org.eclipse.swt.widgets.CoolItem", args);
        writer.setParent(WidgetUtil.getId((Widget)coolItem.getParent()));
        writer.set("minWidth", 0);
        writer.set("minHeight", 0);
    }

    public void renderChanges(Widget widget) throws IOException {
        CoolItem coolItem = (CoolItem)widget;
        CoolItemLCA.writeBounds(coolItem);
        CoolItemLCA.setJSParent(coolItem);
        Control control = coolItem.getControl();
        if (control != null) {
            Point location = control.getLocation();
            location.x = 6;
            location.y = 0;
            control.setLocation(location);
        }
        CoolItemLCA.writeLocked(coolItem);
        WidgetLCAUtil.writeCustomVariant((Widget)coolItem);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static void writeBounds(CoolItem coolItem) throws IOException {
        Rectangle bounds = coolItem.getBounds();
        WidgetLCAUtil.writeBounds((Widget)coolItem, (Control)coolItem.getParent(), bounds);
        if (WidgetLCAUtil.hasChanged((Widget)coolItem, "bounds", bounds, null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)coolItem);
            writer.call("updateHandleBounds", null);
        }
    }

    private static void writeLocked(CoolItem coolItem) throws IOException {
        Boolean defValue;
        Boolean oldValue;
        JSWriter writer = JSWriter.getWriterFor((Widget)coolItem);
        CoolBar parent = coolItem.getParent();
        if (WidgetLCAUtil.hasChanged((Widget)parent, "locked", oldValue = Boolean.valueOf(parent.getLocked()), defValue = Boolean.FALSE)) {
            writer.set("locked", parent.getLocked());
        }
    }

    private static void setJSParent(CoolItem coolItem) {
        Control control = coolItem.getControl();
        if (control != null) {
            WidgetAdapter controlAdapter = (WidgetAdapter)WidgetUtil.getAdapter((Widget)control);
            controlAdapter.setJSParent(WidgetUtil.getId((Widget)coolItem));
        }
    }

    private static JSVar jsOrientation(CoolItem coolItem) {
        JSVar orientation = (coolItem.getStyle() & 0x200) != 0 ? JSConst.QX_CONST_VERTICAL_ORIENTATION : JSConst.QX_CONST_HORIZONTAL_ORIENTATION;
        return orientation;
    }

    private static void moveItem(CoolItem coolItem, int newX) {
        CoolItem[] items = coolItem.getParent().getItems();
        boolean changed = false;
        int newOrder = -1;
        int maxX = 0;
        int minX = 0;
        int i = 0;
        while (newOrder == -1 && i < items.length) {
            CoolItem item = items[i];
            Rectangle itemBounds = item.getBounds();
            if (item != coolItem && itemBounds.contains(newX, itemBounds.y)) {
                int[] itemOrder = coolItem.getParent().getItemOrder();
                newOrder = Math.min(itemOrder[i] + 1, itemOrder.length - 1);
                changed = CoolItemLCA.changeOrder(coolItem, newOrder);
            }
            maxX = Math.max(maxX, itemBounds.x + itemBounds.width);
            minX = Math.min(minX, itemBounds.x);
            ++i;
        }
        if (newOrder == -1 && newX > maxX) {
            changed = CoolItemLCA.changeOrder(coolItem, coolItem.getParent().getItemCount() - 1);
        } else if (newOrder == -1 && newX < minX) {
            changed = CoolItemLCA.changeOrder(coolItem, 0);
        }
        if (!changed) {
            IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)coolItem);
            adapter.preserve("bounds", null);
        }
    }

    private static boolean changeOrder(CoolItem coolItem, int newOrder) {
        boolean result;
        CoolBar coolBar = coolItem.getParent();
        int itemIndex = coolBar.indexOf(coolItem);
        int[] itemOrder = coolBar.getItemOrder();
        int oldOrder = itemOrder[itemIndex];
        if (oldOrder != newOrder) {
            CoolItem item;
            int i;
            if (newOrder < oldOrder) {
                i = 0;
                while (i < itemOrder.length) {
                    item = coolBar.getItem(i);
                    if (item != coolItem && itemOrder[i] >= newOrder && itemOrder[i] < itemOrder[itemIndex]) {
                        int n = i;
                        itemOrder[n] = itemOrder[n] + 1;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < itemOrder.length) {
                    item = coolBar.getItem(i);
                    if (item != coolItem && itemOrder[i] <= newOrder && itemOrder[i] > itemOrder[itemIndex]) {
                        int n = i;
                        itemOrder[n] = itemOrder[n] - 1;
                    }
                    ++i;
                }
            }
            boolean bl = result = itemOrder[itemIndex] != newOrder;
            if (result) {
                itemOrder[itemIndex] = newOrder;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ICoolBarAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Object adapter = coolBar.getAdapter((Class)clazz);
                ICoolBarAdapter cba = (ICoolBarAdapter)adapter;
                cba.setItemOrder(itemOrder);
            }
        } else {
            result = false;
        }
        return result;
    }
}

