/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemDelegateLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemLCAUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

final class CheckMenuItemLCA
extends MenuItemDelegateLCA {
    private static final String PROP_SELECTION = "selection";
    private static final JSListenerInfo JS_LISTENER_INFO = new JSListenerInfo("execute", "org.eclipse.swt.MenuUtil.checkMenuItemSelected", JSListenerType.STATE_AND_ACTION);

    CheckMenuItemLCA() {
    }

    void preserveValues(MenuItem menuItem) {
        ItemLCAUtil.preserve((Item)menuItem);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)menuItem);
        boolean hasListener = SelectionEvent.hasListener((Adaptable)menuItem);
        adapter.preserve("selectionListeners", (Object)hasListener);
        adapter.preserve(PROP_SELECTION, (Object)menuItem.getSelection());
        MenuItemLCAUtil.preserveEnabled(menuItem);
        WidgetLCAUtil.preserveCustomVariant((Widget)menuItem);
    }

    void readData(MenuItem menuItem) {
        String paramValue = WidgetLCAUtil.readPropertyValue((Widget)menuItem, PROP_SELECTION);
        if (paramValue != null) {
            menuItem.setSelection(Boolean.valueOf(paramValue).booleanValue());
        }
        ControlLCAUtil.processSelection((Widget)menuItem, null, false);
    }

    void renderInitialization(MenuItem menuItem) throws IOException {
        MenuItemLCAUtil.newItem(menuItem, "qx.ui.menu.CheckBox", true);
    }

    void renderChanges(MenuItem menuItem) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)menuItem);
        MenuItemLCAUtil.writeImageAndText(menuItem);
        writer.updateListener(JS_LISTENER_INFO, "selectionListeners", SelectionEvent.hasListener((Adaptable)menuItem));
        writer.set(PROP_SELECTION, "checked", menuItem.getSelection(), Boolean.FALSE);
        MenuItemLCAUtil.writeEnabled(menuItem);
        WidgetLCAUtil.writeCustomVariant((Widget)menuItem);
    }

    void renderDispose(MenuItem menuItem) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)menuItem);
        writer.dispose();
    }
}

