/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menukit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

final class MenuLCAUtil {
    private static final int MENU_PADDING = 1;
    private static final int MENU_BORDER = 1;
    private static final int ITEM_LEFT_PADDING = 2;
    private static final int ITEM_RIGHT_PADDING = 4;
    private static final int ITEM_SPACING = 2;
    private static final int ITEM_IMAGE = 16;
    static final String PROP_ENABLED = "enabled";
    static final String PROP_WIDTH = "width";
    static final String PROP_MENU_LISTENER = "menuListener";
    private static final String SET_MENU_LISTENER = "org.eclipse.swt.MenuUtil.setMenuListener";
    private static final String UNHIDE_MENU = "org.eclipse.swt.MenuUtil.unhideMenu";

    MenuLCAUtil() {
    }

    public static void preserveEnabled(Menu menu) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)menu);
        adapter.preserve(PROP_ENABLED, (Object)menu.getEnabled());
    }

    public static void writeEnabled(Menu menu) throws IOException {
        Boolean newValue = menu.getEnabled();
        Boolean defValue = Boolean.TRUE;
        JSWriter writer = JSWriter.getWriterFor((Widget)menu);
        writer.set(PROP_ENABLED, PROP_ENABLED, newValue, defValue);
    }

    public static void preserveMenuListener(Menu menu) {
        Boolean hasListener = MenuEvent.hasListener((Adaptable)menu);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)menu);
        adapter.preserve(PROP_MENU_LISTENER, (Object)hasListener);
    }

    public static void writeMenuListener(Menu menu) throws IOException {
        Boolean defValue;
        String prop = PROP_MENU_LISTENER;
        Boolean newValue = MenuEvent.hasListener((Adaptable)menu);
        if (WidgetLCAUtil.hasChanged((Widget)menu, prop, newValue, defValue = Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)menu);
            Object[] args = new Object[]{menu, newValue};
            writer.callStatic(SET_MENU_LISTENER, args);
        }
    }

    public static void readMenuEvent(Menu menu) {
        MenuEvent event;
        if (WidgetLCAUtil.wasEventSent((Widget)menu, "org.eclipse.swt.events.menuShown")) {
            event = new MenuEvent((Widget)menu, 22);
            event.processEvent();
        }
        if (WidgetLCAUtil.wasEventSent((Widget)menu, "org.eclipse.swt.events.menuHidden")) {
            event = new MenuEvent((Widget)menu, 23);
            event.processEvent();
        }
    }

    public static void writeUnhideMenu(Menu menu) throws IOException {
        String eventId = "org.eclipse.swt.events.menuShown";
        if (WidgetLCAUtil.wasEventSent((Widget)menu, eventId)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)menu);
            Boolean reveal = menu.getItemCount() > 0;
            Object[] args = new Object[]{menu, reveal};
            writer.callStatic(UNHIDE_MENU, args);
        }
    }

    static void preserveWidth(Menu menu) {
        int width = MenuLCAUtil.computeWidth(menu);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)menu);
        adapter.preserve(PROP_WIDTH, (Object)new Integer(width));
    }

    static void writeWidth(Menu menu) throws IOException {
        int width = MenuLCAUtil.computeWidth(menu);
        JSWriter writer = JSWriter.getWriterFor((Widget)menu);
        writer.set(PROP_WIDTH, PROP_WIDTH, new Integer(width), null);
    }

    static int computeWidth(Menu menu) {
        int maxItemWidth = 0;
        MenuItem[] items = menu.getItems();
        int i = 0;
        while (i < items.length) {
            int width = MenuLCAUtil.getMenuItemWidth(items[i]);
            maxItemWidth = Math.max(width, maxItemWidth);
            ++i;
        }
        return maxItemWidth + 2 + 2;
    }

    private static int getMenuItemWidth(MenuItem menuItem) {
        Font systemFont = menuItem.getDisplay().getSystemFont();
        int result = 20 + Graphics.stringExtent((Font)systemFont, (String)menuItem.getText()).x + 2 + 16 + 4;
        return result;
    }
}

