/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.spinnerkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public final class SpinnerLCA
extends AbstractWidgetLCA {
    private static final String QX_TYPE = "org.eclipse.swt.widgets.Spinner";
    private static final String PROP_SELECTION = "selection";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_INCREMENT = "increment";
    static final String PROP_PAGE_INCREMENT = "pageIncrement";
    static final String PROP_MODIFY_LISTENER = "modifyListener";
    static final String PROP_SELECTION_LISTENER = "selectionListener";

    public void preserveValues(Widget widget) {
        Spinner spinner = (Spinner)widget;
        ControlLCAUtil.preserveValues((Control)spinner);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_SELECTION, (Object)new Integer(spinner.getSelection()));
        adapter.preserve(PROP_MINIMUM, (Object)new Integer(spinner.getMinimum()));
        adapter.preserve(PROP_MAXIMUM, (Object)new Integer(spinner.getMaximum()));
        adapter.preserve(PROP_INCREMENT, (Object)new Integer(spinner.getIncrement()));
        adapter.preserve(PROP_PAGE_INCREMENT, (Object)new Integer(spinner.getPageIncrement()));
        adapter.preserve(PROP_MODIFY_LISTENER, (Object)ModifyEvent.hasListener((Adaptable)spinner));
        adapter.preserve(PROP_SELECTION_LISTENER, (Object)SelectionEvent.hasListener((Adaptable)spinner));
        WidgetLCAUtil.preserveCustomVariant((Widget)spinner);
    }

    public void readData(Widget widget) {
        Spinner spinner = (Spinner)widget;
        String value = WidgetLCAUtil.readPropertyValue(widget, PROP_SELECTION);
        if (value != null) {
            spinner.setSelection(Integer.parseInt(value));
        }
        ControlLCAUtil.processSelection(widget, null, false);
        ControlLCAUtil.processMouseEvents((Control)spinner);
        ControlLCAUtil.processKeyEvents((Control)spinner);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Spinner spinner = (Spinner)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        writer.newWidget(QX_TYPE);
        ControlLCAUtil.writeStyleFlags((Control)spinner);
        SpinnerLCA.writeReadOnly(spinner);
        SpinnerLCA.writeWrap(spinner);
    }

    public void renderChanges(Widget widget) throws IOException {
        Spinner spinner = (Spinner)widget;
        ControlLCAUtil.writeChanges((Control)spinner);
        SpinnerLCA.writeValues(spinner);
        SpinnerLCA.writeModifyListener(spinner);
        SpinnerLCA.writeSelectionListener(spinner);
        WidgetLCAUtil.writeCustomVariant((Widget)spinner);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
        ControlLCAUtil.resetStyleFlags();
        SpinnerLCA.resetReadOnly();
        SpinnerLCA.resetValues();
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static void writeValues(Spinner spinner) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        SpinnerLCA.writeSetInt(writer, PROP_MINIMUM, "min", spinner.getMinimum(), 0);
        SpinnerLCA.writeSetInt(writer, PROP_MAXIMUM, "max", spinner.getMaximum(), 100);
        SpinnerLCA.writeSetInt(writer, PROP_INCREMENT, "incrementAmount", spinner.getIncrement(), 1);
        SpinnerLCA.writeSetInt(writer, PROP_PAGE_INCREMENT, "pageIncrementAmount", spinner.getPageIncrement(), 10);
        SpinnerLCA.writeSetInt(writer, PROP_SELECTION, "value", spinner.getSelection(), 0);
    }

    private static void resetValues() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset("incrementAmount");
        writer.reset("pageIncrementAmount");
        writer.reset("value");
    }

    private static void writeSetInt(JSWriter writer, String javaProperty, String jsProperty, int newValue, int defValue) throws IOException {
        writer.set(javaProperty, jsProperty, new Integer(newValue), new Integer(defValue));
    }

    private static void writeReadOnly(Spinner spinner) throws IOException {
        boolean readOnly = (spinner.getStyle() & 8) != 0;
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        writer.set("editable", !readOnly);
    }

    private static void resetReadOnly() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset("editable");
    }

    private static void writeWrap(Spinner spinner) throws IOException {
        if ((spinner.getStyle() & 0x40) != 0) {
            JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
            writer.set("wrap", true);
        }
    }

    private static void writeModifyListener(Spinner spinner) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        String prop = PROP_MODIFY_LISTENER;
        Boolean newValue = ModifyEvent.hasListener((Adaptable)spinner);
        Boolean defValue = Boolean.FALSE;
        writer.set(prop, "hasModifyListener", newValue, defValue);
    }

    private static void writeSelectionListener(Spinner spinner) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        String prop = PROP_SELECTION_LISTENER;
        Boolean newValue = SelectionEvent.hasListener((Adaptable)spinner);
        Boolean defValue = Boolean.FALSE;
        writer.set(prop, "hasSelectionListener", newValue, defValue);
    }
}

