/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.toolitemkit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.toolitemkit.ToolItemDelegateLCA;
import org.eclipse.swt.internal.widgets.toolitemkit.ToolItemLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

final class DropDownToolItemLCA
extends ToolItemDelegateLCA {
    private static final String DROP_DOWN_SUFFIX = "_dropDown";
    private static final String CREATE_DROP_DOWN = "org.eclipse.swt.ToolItemUtil.createDropDown";
    private static final String UPDATE_DROP_DOWN_LISTENER = "org.eclipse.swt.ToolItemUtil.updateDropDownListener";
    private static final JSListenerInfo JS_BUTTON_LISTENER_INFO = new JSListenerInfo("execute", "org.eclipse.swt.EventUtil.widgetSelected", JSListenerType.ACTION);

    DropDownToolItemLCA() {
    }

    void preserveValues(ToolItem toolItem) {
        ToolItemLCAUtil.preserveValues(toolItem);
        ToolItemLCAUtil.preserveImages(toolItem);
        WidgetLCAUtil.preserveCustomVariant((Widget)toolItem);
    }

    void readData(ToolItem toolItem) {
        HttpServletRequest request = ContextProvider.getRequest();
        String widgetId = request.getParameter("org.eclipse.swt.events.widgetSelected");
        if (WidgetUtil.getId((Widget)toolItem).equals(widgetId)) {
            ToolItemLCAUtil.processSelection(toolItem);
        } else {
            String toolItemId = DropDownToolItemLCA.getDropDownId((Widget)toolItem);
            if (toolItemId.equals(widgetId)) {
                Rectangle defaultValue = new Rectangle(0, 0, 0, 0);
                Rectangle bounds = WidgetLCAUtil.readBounds(toolItemId, defaultValue);
                Display display = toolItem.getDisplay();
                Point coords = display.map(null, (Control)toolItem.getParent(), bounds.x, bounds.y);
                bounds.x = coords.x;
                bounds.y = coords.y;
                SelectionEvent event = ToolItemLCAUtil.newSelectionEvent((Widget)toolItem, bounds, 4);
                event.processEvent();
            }
        }
    }

    void renderInitialization(ToolItem toolItem) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
        Object[] args = new Object[]{WidgetUtil.getId((Widget)toolItem), toolItem.getParent(), (toolItem.getParent().getStyle() & 0x800000) != 0};
        writer.callStatic(CREATE_DROP_DOWN, args);
    }

    void renderChanges(ToolItem toolItem) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
        ItemLCAUtil.writeText((Item)toolItem, false);
        ToolItemLCAUtil.writeImages(toolItem);
        WidgetLCAUtil.writeMenu((Widget)toolItem, toolItem.getParent().getMenu());
        writer.updateListener(JS_BUTTON_LISTENER_INFO, "selectionListeners", SelectionEvent.hasListener((Adaptable)toolItem));
        DropDownToolItemLCA.writeDropDownListener(toolItem);
        WidgetLCAUtil.writeToolTip((Widget)toolItem, toolItem.getToolTipText());
        WidgetLCAUtil.writeEnabled((Widget)toolItem, toolItem.getEnabled());
        ToolItemLCAUtil.writeVisible(toolItem);
        ToolItemLCAUtil.writeBounds(toolItem);
        WidgetLCAUtil.writeCustomVariant((Widget)toolItem);
    }

    private static void writeDropDownListener(ToolItem toolItem) throws IOException {
        Boolean defValue;
        String prop = "selectionListeners";
        Boolean value = SelectionEvent.hasListener((Adaptable)toolItem);
        if (WidgetLCAUtil.hasChanged((Widget)toolItem, prop, value, defValue = Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)toolItem);
            Boolean remove = value == false;
            Object[] args = new Object[]{DropDownToolItemLCA.getDropDownId((Widget)toolItem), remove};
            writer.callStatic(UPDATE_DROP_DOWN_LISTENER, args);
        }
    }

    private static String getDropDownId(Widget widget) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(WidgetUtil.getId((Widget)widget));
        buffer.append(DROP_DOWN_SUFFIX);
        return buffer.toString();
    }
}

