/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.lifecycle;

import java.io.IOException;
import java.lang.reflect.Field;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSListenerInfo;
import org.eclipse.rwt.lifecycle.JSListenerType;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.rwt.service.IServiceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.ActivateEvent;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ControlLCAUtil {
    private static final Object[] PARAM_STYLE_BORDER = new Object[]{"rwt_BORDER"};
    private static final Object[] PARAM_STYLE_FLAT = new Object[]{"rwt_FLAT"};
    private static final JSListenerInfo FOCUS_GAINED_LISTENER_INFO = new JSListenerInfo("focusin", "org.eclipse.swt.EventUtil.focusGained", JSListenerType.ACTION);
    private static final JSListenerInfo FOCUS_LOST_LISTENER_INFO = new JSListenerInfo("focusout", "org.eclipse.swt.EventUtil.focusLost", JSListenerType.ACTION);
    private static final JSListenerInfo MOUSE_DOWN_LISTENER_INFO = new JSListenerInfo("mousedown", "org.eclipse.swt.EventUtil.mouseDown", JSListenerType.ACTION);
    private static final JSListenerInfo MOUSE_UP_LISTENER_INFO = new JSListenerInfo("mouseup", "org.eclipse.swt.EventUtil.mouseUp", JSListenerType.ACTION);
    private static final String JS_FUNC_ADD_ACTIVATE_LISTENER_WIDGET = "addActivateListenerWidget";
    private static final String JS_FUNC_REMOVE_ACTIVATE_LISTENER_WIDGET = "removeActivateListenerWidget";
    private static final String PROP_ACTIVATE_LISTENER = "activateListener";
    private static final String PROP_FOCUS_LISTENER = "focusListener";
    private static final String PROP_MOUSE_LISTENER = "mouseListener";
    private static final String PROP_KEY_LISTENER = "keyListener";
    private static final String PROP_TRAVERSE_LISTENER = "traverseListener";
    private static final String PROP_TAB_INDEX = "tabIndex";
    private static final String PROP_CURSOR = "cursor";
    private static final String PROP_BACKGROUND_IMAGE = "backgroundImage";
    private static final String USER_DATA_KEY_LISTENER = "keyListener";
    private static final String USER_DATA_TRAVERSE_LISTENER = "traverseListener";
    private static final String ATT_CANCEL_KEY_EVENT;
    private static final String ATT_ALLOW_KEY_EVENT;
    static final String JSFUNC_CANCEL_EVENT = "org.eclipse.rwt.AsyncKeyEventUtil.getInstance().cancelEvent";
    static final String JSFUNC_ALLOW_EVENT = "org.eclipse.rwt.AsyncKeyEventUtil.getInstance().allowEvent";
    static final int MAX_STATIC_ZORDER = 300;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.lifecycle.ControlLCAUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ATT_CANCEL_KEY_EVENT = String.valueOf(clazz.getName()) + "#cancelKeyEvent";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rwt.lifecycle.ControlLCAUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ATT_ALLOW_KEY_EVENT = String.valueOf(clazz2.getName()) + "#allowKeyEvent";
    }

    private ControlLCAUtil() {
    }

    public static void preserveValues(Control control) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)control);
        adapter.preserve("bounds", (Object)control.getBounds());
        if (!(control instanceof Shell)) {
            adapter.preserve("zindex", (Object)new Integer(ControlLCAUtil.getZIndex(control)));
        }
        adapter.preserve(PROP_TAB_INDEX, (Object)new Integer(ControlLCAUtil.getTabIndex(control)));
        WidgetLCAUtil.preserveToolTipText((Widget)control, control.getToolTipText());
        adapter.preserve("menu", (Object)control.getMenu());
        adapter.preserve("visible", (Object)control.getVisible());
        WidgetLCAUtil.preserveEnabled((Widget)control, control.getEnabled());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IControlAdapter controlAdapter = (IControlAdapter)control.getAdapter((Class)clazz);
        WidgetLCAUtil.preserveForeground((Widget)control, controlAdapter.getUserForeground());
        WidgetLCAUtil.preserveBackground((Widget)control, controlAdapter.getUserBackground(), controlAdapter.getBackgroundTransparency());
        ControlLCAUtil.preserveBackgroundImage(control);
        WidgetLCAUtil.preserveFont((Widget)control, controlAdapter.getUserFont());
        adapter.preserve(PROP_CURSOR, (Object)control.getCursor());
        adapter.preserve("hasControlListeners", (Object)ControlEvent.hasListener((Adaptable)control));
        adapter.preserve(PROP_ACTIVATE_LISTENER, (Object)ActivateEvent.hasListener((Adaptable)control));
        adapter.preserve(PROP_MOUSE_LISTENER, (Object)MouseEvent.hasListener((Adaptable)control));
        if ((control.getStyle() & 0x80000) == 0) {
            adapter.preserve(PROP_FOCUS_LISTENER, (Object)FocusEvent.hasListener((Adaptable)control));
        }
        adapter.preserve("keyListener", (Object)KeyEvent.hasListener((Adaptable)control));
        adapter.preserve("traverseListener", (Object)TraverseEvent.hasListener((Adaptable)control));
    }

    public static void readBounds(Control control) {
        Rectangle current = control.getBounds();
        Rectangle newBounds = WidgetLCAUtil.readBounds((Widget)control, current);
        control.setBounds(newBounds);
    }

    public static void writeBounds(Control control) throws IOException {
        Composite parent = control.getParent();
        WidgetLCAUtil.writeBounds((Widget)control, (Control)parent, control.getBounds());
    }

    public static void resetBounds() throws IOException {
        WidgetLCAUtil.resetBounds();
    }

    public static void writeZIndex(Control control) throws IOException {
        if (!(control instanceof Shell)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            Integer newValue = new Integer(ControlLCAUtil.getZIndex(control));
            writer.set("zindex", "zIndex", newValue, null);
        }
    }

    public static void resetZIndex() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset("zIndex");
    }

    public static void writeVisible(Control control) throws IOException {
        Boolean newValue = control.getVisible();
        Boolean defValue = control instanceof Shell ? Boolean.FALSE : Boolean.TRUE;
        JSWriter writer = JSWriter.getWriterFor((Widget)control);
        writer.set("visible", "visibility", newValue, defValue);
    }

    public static void resetVisible() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.set("visibility", true);
    }

    public static void writeEnabled(Control control) throws IOException {
        WidgetLCAUtil.writeEnabled((Widget)control, control.getEnabled());
    }

    public static void resetEnabled() throws IOException {
        WidgetLCAUtil.resetEnabled();
    }

    public static void writeChanges(Control control) throws IOException {
        ControlLCAUtil.writeBounds(control);
        ControlLCAUtil.writeZIndex(control);
        ControlLCAUtil.writeTabIndex(control);
        ControlLCAUtil.writeToolTip(control);
        ControlLCAUtil.writeMenu(control);
        ControlLCAUtil.writeVisible(control);
        ControlLCAUtil.writeEnabled(control);
        ControlLCAUtil.writeForeground(control);
        ControlLCAUtil.writeBackground(control);
        ControlLCAUtil.writeBackgroundImage(control);
        ControlLCAUtil.writeFont(control);
        ControlLCAUtil.writeCursor(control);
        ControlLCAUtil.writeActivateListener(control);
        ControlLCAUtil.writeFocusListener(control);
        ControlLCAUtil.writeMouseListener(control);
        ControlLCAUtil.writeKeyListener(control);
        ControlLCAUtil.writeTraverseListener(control);
        ControlLCAUtil.writeKeyEventResponse(control);
    }

    public static void resetChanges() throws IOException {
        ControlLCAUtil.resetFocusListener();
        ControlLCAUtil.resetMenu();
        ControlLCAUtil.resetToolTip();
        ControlLCAUtil.resetFont();
        ControlLCAUtil.resetBackground();
        ControlLCAUtil.resetForeground();
        ControlLCAUtil.resetEnabled();
        ControlLCAUtil.resetVisible();
        ControlLCAUtil.resetTabIndex();
        ControlLCAUtil.resetZIndex();
        ControlLCAUtil.resetBounds();
    }

    public static void writeResizeNotificator(Widget control) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(control);
        writer.addListener("changeWidth", "org.eclipse.swt.EventUtil.widgetResized");
        writer.addListener("changeHeight", "org.eclipse.swt.EventUtil.widgetResized");
    }

    public static void resetResizeNotificator() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.removeListener("changeWidth", "org.eclipse.swt.EventUtil.widgetResized");
        writer.removeListener("changeHeight", "org.eclipse.swt.EventUtil.widgetResized");
    }

    public static void writeMoveNotificator(Widget control) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(control);
        writer.addListener("changeLeft", "org.eclipse.swt.EventUtil.widgetMoved");
        writer.addListener("changeTop", "org.eclipse.swt.EventUtil.widgetMoved");
    }

    public static void resetMoveNotificator() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.removeListener("changeLeft", "org.eclipse.swt.EventUtil.widgetMoved");
        writer.removeListener("changeTop", "org.eclipse.swt.EventUtil.widgetMoved");
    }

    public static void writeMenu(Control control) throws IOException {
        WidgetLCAUtil.writeMenu((Widget)control, control.getMenu());
    }

    public static void resetMenu() throws IOException {
        WidgetLCAUtil.resetMenu();
    }

    public static void writeToolTip(Control control) throws IOException {
        WidgetLCAUtil.writeToolTip((Widget)control, control.getToolTipText());
    }

    public static void resetToolTip() throws IOException {
        WidgetLCAUtil.resetToolTip();
    }

    public static void writeForeground(Control control) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IControlAdapter controlAdapter = (IControlAdapter)control.getAdapter((Class)clazz);
        WidgetLCAUtil.writeForeground((Widget)control, controlAdapter.getUserForeground());
    }

    public static void resetForeground() throws IOException {
        WidgetLCAUtil.resetForeground();
    }

    public static void writeBackground(Control control) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IControlAdapter controlAdapter = (IControlAdapter)control.getAdapter((Class)clazz);
        WidgetLCAUtil.writeBackground((Widget)control, controlAdapter.getUserBackground(), controlAdapter.getBackgroundTransparency());
    }

    public static void preserveBackgroundImage(Control control) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IControlAdapter controlAdapter = (IControlAdapter)control.getAdapter((Class)clazz);
        Image image = controlAdapter.getUserBackgroundImage();
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)control);
        adapter.preserve(PROP_BACKGROUND_IMAGE, (Object)image);
    }

    public static void writeBackgroundImage(Control control) throws IOException {
        IControlAdapter controlAdapter;
        Image image;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (WidgetLCAUtil.hasChanged((Widget)control, PROP_BACKGROUND_IMAGE, image = (controlAdapter = (IControlAdapter)control.getAdapter((Class)clazz)).getUserBackgroundImage(), null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            if (image != null) {
                String imagePath = ResourceFactory.getImagePath((Image)image);
                writer.set(PROP_BACKGROUND_IMAGE, imagePath);
            } else {
                writer.reset(PROP_BACKGROUND_IMAGE);
            }
        }
    }

    public static void resetBackground() throws IOException {
        WidgetLCAUtil.resetBackground();
    }

    public static void writeStyleFlags(Control control) throws IOException {
        WidgetLCAUtil.writeStyleFlag((Widget)control, 2048, "BORDER");
        WidgetLCAUtil.writeStyleFlag((Widget)control, 0x800000, "FLAT");
    }

    public static void resetStyleFlags() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.call("removeState", PARAM_STYLE_BORDER);
        writer.call("removeState", PARAM_STYLE_FLAT);
    }

    public static void writeFont(Control control) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = control.getAdapter((Class)clazz);
        IControlAdapter controlAdapter = (IControlAdapter)adapter;
        Font newValue = controlAdapter.getUserFont();
        WidgetLCAUtil.writeFont((Widget)control, newValue);
    }

    public static void resetFont() throws IOException {
        WidgetLCAUtil.resetFont();
    }

    static void writeCursor(Control control) throws IOException {
        Cursor newValue = control.getCursor();
        if (WidgetLCAUtil.hasChanged((Widget)control, PROP_CURSOR, newValue, null)) {
            String qxCursor = ControlLCAUtil.getQxCursor(newValue);
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            if (qxCursor == null) {
                writer.reset(PROP_CURSOR);
            } else {
                writer.set(PROP_CURSOR, qxCursor);
            }
        }
    }

    static void resetCursor() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset(PROP_CURSOR);
    }

    public static void writeActivateListener(Control control) throws IOException {
        Boolean newValue = ActivateEvent.hasListener((Adaptable)control);
        Boolean defValue = Boolean.FALSE;
        String prop = PROP_ACTIVATE_LISTENER;
        Shell shell = control.getShell();
        if (!shell.isDisposed() && WidgetLCAUtil.hasChanged((Widget)control, prop, newValue, defValue)) {
            String function = newValue != false ? JS_FUNC_ADD_ACTIVATE_LISTENER_WIDGET : JS_FUNC_REMOVE_ACTIVATE_LISTENER_WIDGET;
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            Object[] args = new Object[]{control};
            writer.call((Widget)shell, function, args);
        }
    }

    static void resetActivateListener(Control control) throws IOException {
        Shell shell = control.getShell();
        if (!shell.isDisposed() && ActivateEvent.hasListener((Adaptable)control)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            writer.call((Widget)shell, JS_FUNC_REMOVE_ACTIVATE_LISTENER_WIDGET, new Object[]{control});
        }
    }

    private static void writeFocusListener(Control control) throws IOException {
        if ((control.getStyle() & 0x80000) == 0) {
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            boolean hasListener = FocusEvent.hasListener((Adaptable)control);
            writer.updateListener(FOCUS_GAINED_LISTENER_INFO, PROP_FOCUS_LISTENER, hasListener);
            writer.updateListener(FOCUS_LOST_LISTENER_INFO, PROP_FOCUS_LISTENER, hasListener);
        }
    }

    private static void resetFocusListener() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.removeListener(FOCUS_GAINED_LISTENER_INFO.getEventType(), FOCUS_GAINED_LISTENER_INFO.getJSListener());
        writer.removeListener(FOCUS_LOST_LISTENER_INFO.getEventType(), FOCUS_LOST_LISTENER_INFO.getJSListener());
    }

    private static void writeMouseListener(Control control) throws IOException {
        boolean hasListener = MouseEvent.hasListener((Adaptable)control);
        JSWriter writer = JSWriter.getWriterFor((Widget)control);
        writer.updateListener(MOUSE_UP_LISTENER_INFO, PROP_MOUSE_LISTENER, hasListener);
        writer.updateListener(MOUSE_DOWN_LISTENER_INFO, PROP_MOUSE_LISTENER, hasListener);
    }

    static void writeKeyListener(Control control) throws IOException {
        Boolean defValue;
        String prop = "keyListener";
        Boolean hasListener = KeyEvent.hasListener((Adaptable)control);
        if (WidgetLCAUtil.hasChanged((Widget)control, prop, hasListener, defValue = Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            if (hasListener.booleanValue()) {
                Object[] args = new Object[]{"keyListener", hasListener};
                writer.call("setUserData", args);
            } else {
                Object[] objectArray = new Object[2];
                objectArray[0] = "keyListener";
                Object[] args = objectArray;
                writer.call("setUserData", args);
            }
        }
    }

    static void writeTraverseListener(Control control) throws IOException {
        Boolean defValue;
        String prop = "traverseListener";
        Boolean hasListener = TraverseEvent.hasListener((Adaptable)control);
        if (WidgetLCAUtil.hasChanged((Widget)control, prop, hasListener, defValue = Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            if (hasListener.booleanValue()) {
                Object[] args = new Object[]{"traverseListener", hasListener};
                writer.call("setUserData", args);
            } else {
                Object[] objectArray = new Object[2];
                objectArray[0] = "traverseListener";
                Object[] args = objectArray;
                writer.call("setUserData", args);
            }
        }
    }

    public static int getZIndex(Control control) {
        Class<?> clazz;
        int max = 300;
        if (control.getParent() != null) {
            max = Math.max(control.getParent().getChildren().length, max);
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = control.getAdapter((Class)clazz);
        IControlAdapter controlAdapter = (IControlAdapter)adapter;
        return max - controlAdapter.getZIndex();
    }

    private static void writeTabIndex(Control control) throws IOException {
        if (control instanceof Shell) {
            ControlLCAUtil.computeTabIndices((Composite)((Shell)control), 1);
        }
        int tabIndex = ControlLCAUtil.getTabIndex(control);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)control);
        if (tabIndex > -1 || adapter.isInitialized()) {
            Integer newValue = new Integer(tabIndex);
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            writer.set(PROP_TAB_INDEX, PROP_TAB_INDEX, newValue);
        }
    }

    private static void resetTabIndex() throws IOException {
        JSWriter writer = JSWriter.getWriterForResetHandler();
        writer.reset(PROP_TAB_INDEX);
    }

    private static int computeTabIndices(Composite comp, int index) {
        Control[] children = comp.getChildren();
        int i = 0;
        while (i < children.length) {
            Control control = children[i];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = control.getAdapter((Class)clazz);
            IControlAdapter controlAdapter = (IControlAdapter)adapter;
            controlAdapter.setTabIndex(-1);
            ++i;
        }
        Control[] tabList = comp.getTabList();
        int nextIndex = index;
        int i2 = 0;
        while (i2 < tabList.length) {
            Control control = tabList[i2];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = control.getAdapter((Class)clazz);
            IControlAdapter controlAdapter = (IControlAdapter)adapter;
            controlAdapter.setTabIndex(nextIndex);
            nextIndex = control instanceof Link ? (nextIndex += 300) : ++nextIndex;
            if (control instanceof Composite) {
                nextIndex = ControlLCAUtil.computeTabIndices((Composite)control, nextIndex);
            }
            ++i2;
        }
        return nextIndex;
    }

    private static int getTabIndex(Control control) {
        int result = -1;
        if (ControlLCAUtil.takesFocus(control)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = control.getAdapter((Class)clazz);
            IControlAdapter controlAdapter = (IControlAdapter)adapter;
            result = controlAdapter.getTabIndex();
        }
        return result;
    }

    private static boolean takesFocus(Control control) {
        boolean result = true;
        result &= (control.getStyle() & 0x80000) == 0;
        Class<?> clazz = control.getClass();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.swt.widgets.Composite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result &= clazz != clazz2;
        Class<?> clazz3 = control.getClass();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.swt.widgets.ToolBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result &= clazz3 != clazz4;
        Class<?> clazz5 = control.getClass();
        Class<?> clazz6 = class$4;
        if (clazz6 == null) {
            try {
                clazz6 = class$4 = Class.forName("org.eclipse.swt.custom.SashForm");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return result &= clazz5 != clazz6;
    }

    public static void processSelection(Widget widget, Item item, boolean readBounds) {
        SelectionEvent event;
        String eventId = "org.eclipse.swt.events.widgetSelected";
        if (WidgetLCAUtil.wasEventSent(widget, eventId)) {
            event = ControlLCAUtil.createSelectionEvent(widget, item, readBounds, 13);
            event.processEvent();
        }
        if (WidgetLCAUtil.wasEventSent(widget, eventId = "org.eclipse.swt.events.widgetDefaultSelected")) {
            event = ControlLCAUtil.createSelectionEvent(widget, item, readBounds, 14);
            event.processEvent();
        }
    }

    private static SelectionEvent createSelectionEvent(Widget widget, Item item, boolean readBounds, int type) {
        Rectangle bounds;
        if (widget instanceof Control && readBounds) {
            Control control = (Control)widget;
            bounds = WidgetLCAUtil.readBounds((Widget)control, control.getBounds());
        } else {
            bounds = new Rectangle(0, 0, 0, 0);
        }
        return new SelectionEvent(widget, (Widget)item, type, bounds, null, true, 0);
    }

    public static void processKeyEvents(final Control control) {
        if (WidgetLCAUtil.wasEventSent((Widget)control, "org.eclipse.swt.events.keyDown")) {
            final int keyCode = ControlLCAUtil.readIntParam("org.eclipse.swt.events.keyDown.keyCode");
            final int charCode = ControlLCAUtil.readIntParam("org.eclipse.swt.events.keyDown.charCode");
            String modifier = ControlLCAUtil.readStringParam("org.eclipse.swt.events.keyDown.modifier");
            final int stateMask = ControlLCAUtil.translateModifier(modifier);
            final int traverseKey = ControlLCAUtil.getTraverseKey(keyCode, stateMask);
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    boolean allow = true;
                    if (traverseKey != 0) {
                        TraverseEvent traverseEvent = new TraverseEvent(control);
                        ControlLCAUtil.initializeKeyEvent((KeyEvent)traverseEvent, keyCode, charCode, stateMask);
                        traverseEvent.detail = traverseKey;
                        traverseEvent.processEvent();
                        if (!traverseEvent.doit) {
                            allow = false;
                        }
                    }
                    KeyEvent pressedEvent = new KeyEvent(control, 1);
                    ControlLCAUtil.initializeKeyEvent(pressedEvent, keyCode, charCode, stateMask);
                    pressedEvent.processEvent();
                    if (pressedEvent.doit) {
                        KeyEvent releasedEvent = new KeyEvent(control, 2);
                        ControlLCAUtil.initializeKeyEvent(releasedEvent, keyCode, charCode, stateMask);
                        releasedEvent.processEvent();
                    } else {
                        allow = false;
                    }
                    if (allow) {
                        ControlLCAUtil.allowKeyEvent((Widget)control);
                    } else {
                        ControlLCAUtil.cancelKeyEvent((Widget)control);
                    }
                }
            });
        }
    }

    static int getTraverseKey(int keyCode, int stateMask) {
        int result = 0;
        switch (keyCode) {
            case 27: {
                result = 2;
                break;
            }
            case 13: {
                result = 4;
                break;
            }
            case 9: {
                if ((stateMask & SWT.MODIFIER_MASK) == 0) {
                    result = 16;
                    break;
                }
                if (stateMask != 131072) break;
                result = 8;
            }
        }
        return result;
    }

    private static void initializeKeyEvent(KeyEvent event, int keyCode, int charCode, int stateMask) {
        if (charCode == 0) {
            event.keyCode = ControlLCAUtil.translateKeyCode(keyCode);
            if ((event.keyCode & 0x1000000) == 0) {
                event.character = ControlLCAUtil.translateCharacter(event.keyCode);
            }
        } else {
            event.keyCode = charCode;
            event.character = ControlLCAUtil.translateCharacter(charCode);
        }
        event.stateMask = stateMask;
    }

    static int translateKeyCode(int keyCode) {
        int result;
        switch (keyCode) {
            case 20: {
                result = 16777298;
                break;
            }
            case 38: {
                result = 0x1000001;
                break;
            }
            case 37: {
                result = 0x1000003;
                break;
            }
            case 39: {
                result = 0x1000004;
                break;
            }
            case 40: {
                result = 0x1000002;
                break;
            }
            case 33: {
                result = 0x1000005;
                break;
            }
            case 34: {
                result = 0x1000006;
                break;
            }
            case 35: {
                result = 0x1000008;
                break;
            }
            case 36: {
                result = 0x1000007;
                break;
            }
            case 45: {
                result = 0x1000009;
                break;
            }
            case 46: {
                result = 127;
                break;
            }
            case 112: {
                result = 0x100000A;
                break;
            }
            case 113: {
                result = 0x100000B;
                break;
            }
            case 114: {
                result = 0x100000C;
                break;
            }
            case 115: {
                result = 0x100000D;
                break;
            }
            case 116: {
                result = 0x100000E;
                break;
            }
            case 117: {
                result = 0x100000F;
                break;
            }
            case 118: {
                result = 0x1000010;
                break;
            }
            case 119: {
                result = 0x1000011;
                break;
            }
            case 120: {
                result = 0x1000012;
                break;
            }
            case 121: {
                result = 0x1000013;
                break;
            }
            case 122: {
                result = 0x1000014;
                break;
            }
            case 123: {
                result = 0x1000015;
                break;
            }
            case 144: {
                result = 16777299;
                break;
            }
            case 44: {
                result = 16777303;
                break;
            }
            case 145: {
                result = 16777300;
                break;
            }
            case 19: {
                result = 0x1000055;
                break;
            }
            default: {
                result = keyCode;
            }
        }
        return result;
    }

    private static char translateCharacter(int keyCode) {
        char result = '\u0000';
        if (Character.isDefined((char)keyCode)) {
            result = (char)keyCode;
        }
        return result;
    }

    static int translateModifier(String value) {
        String[] modifiers = value.split(",");
        int result = 0;
        int i = 0;
        while (i < modifiers.length) {
            if ("ctrl".equals(modifiers[i])) {
                result |= 0x40000;
            } else if ("alt".equals(modifiers[i])) {
                result |= 0x10000;
            } else if ("shift".equals(modifiers[i])) {
                result |= 0x20000;
            }
            ++i;
        }
        return result;
    }

    private static void cancelKeyEvent(Widget widget) {
        RWT.getServiceStore().setAttribute(ATT_CANCEL_KEY_EVENT, (Object)widget);
    }

    private static void allowKeyEvent(Widget widget) {
        RWT.getServiceStore().setAttribute(ATT_ALLOW_KEY_EVENT, (Object)widget);
    }

    private static void writeKeyEventResponse(Control control) throws IOException {
        IServiceStore serviceStore = RWT.getServiceStore();
        if (serviceStore.getAttribute(ATT_ALLOW_KEY_EVENT) == control) {
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            writer.callStatic(JSFUNC_ALLOW_EVENT, null);
        } else if (serviceStore.getAttribute(ATT_CANCEL_KEY_EVENT) == control) {
            JSWriter writer = JSWriter.getWriterFor((Widget)control);
            writer.callStatic(JSFUNC_CANCEL_EVENT, null);
        }
    }

    public static void processMouseEvents(Control control) {
        Point point;
        MouseEvent event;
        String eventId;
        if (WidgetLCAUtil.wasEventSent((Widget)control, "org.eclipse.swt.events.mouseDown")) {
            MouseEvent event2 = new MouseEvent((Widget)control, 3);
            event2.button = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseDown.button");
            Point point2 = ControlLCAUtil.readXYParams(control, "org.eclipse.swt.events.mouseDown.x", "org.eclipse.swt.events.mouseDown.y");
            event2.x = point2.x;
            event2.y = point2.y;
            event2.time = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseDown.time");
            ControlLCAUtil.checkAndProcessMouseEvent(event2);
        }
        if (WidgetLCAUtil.wasEventSent((Widget)control, eventId = "org.eclipse.swt.events.mouseDoubleClick")) {
            event = new MouseEvent((Widget)control, 8);
            event.button = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseDoubleClick.button");
            point = ControlLCAUtil.readXYParams(control, "org.eclipse.swt.events.mouseDoubleClick.x", "org.eclipse.swt.events.mouseDoubleClick.y");
            event.x = point.x;
            event.y = point.y;
            event.time = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseDoubleClick.time");
            ControlLCAUtil.checkAndProcessMouseEvent(event);
        }
        if (WidgetLCAUtil.wasEventSent((Widget)control, "org.eclipse.swt.events.mouseUp")) {
            event = new MouseEvent((Widget)control, 4);
            event.button = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseUp.button");
            point = ControlLCAUtil.readXYParams(control, "org.eclipse.swt.events.mouseUp.x", "org.eclipse.swt.events.mouseUp.y");
            event.x = point.x;
            event.y = point.y;
            event.time = ControlLCAUtil.readIntParam("org.eclipse.swt.events.mouseUp.time");
            ControlLCAUtil.checkAndProcessMouseEvent(event);
        }
    }

    private static void checkAndProcessMouseEvent(MouseEvent event) {
        boolean pass = false;
        Control control = (Control)event.widget;
        if (control instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)control;
            Rectangle clientArea = scrollable.getClientArea();
            pass = event.x >= clientArea.x && event.y >= clientArea.y;
        } else {
            boolean bl = pass = event.x >= 0 && event.y >= 0;
        }
        if (pass) {
            event.processEvent();
        }
    }

    private static String readStringParam(String paramName) {
        HttpServletRequest request = ContextProvider.getRequest();
        String value = request.getParameter(paramName);
        return value;
    }

    private static int readIntParam(String paramName) {
        String value = ControlLCAUtil.readStringParam(paramName);
        return Integer.parseInt(value);
    }

    private static Point readXYParams(Control control, String paramNameX, String paramNameY) {
        int x = ControlLCAUtil.readIntParam(paramNameX);
        int y = ControlLCAUtil.readIntParam(paramNameY);
        return control.getDisplay().map(null, control, x, y);
    }

    private static String getQxCursor(Cursor newValue) {
        String result = null;
        if (newValue != null) {
            int value = 0;
            try {
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("org.eclipse.swt.graphics.Cursor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class<?> cursorClass = clazz;
                Field field = cursorClass.getDeclaredField("value");
                field.setAccessible(true);
                value = field.getInt(newValue);
            }
            catch (Exception exception) {
                throw new RuntimeException();
            }
            switch (value) {
                case 0: {
                    result = "default";
                    break;
                }
                case 1: {
                    result = "wait";
                    break;
                }
                case 2: {
                    result = "crosshair";
                    break;
                }
                case 4: {
                    result = "help";
                    break;
                }
                case 5: {
                    result = "move";
                    break;
                }
                case 7: {
                    result = "row-resize";
                    break;
                }
                case 9: {
                    result = "col-resize";
                    break;
                }
                case 10: {
                    result = "n-resize";
                    break;
                }
                case 11: {
                    result = "s-resize";
                    break;
                }
                case 12: {
                    result = "e-resize";
                    break;
                }
                case 13: {
                    result = "w-resize";
                    break;
                }
                case 14: {
                    result = "ne-resize";
                    break;
                }
                case 15: {
                    result = "se-resize";
                    break;
                }
                case 16: {
                    result = "sw-resize";
                    break;
                }
                case 17: {
                    result = "nw-resize";
                    break;
                }
                case 19: {
                    result = "text";
                    break;
                }
                case 21: {
                    result = "pointer";
                }
            }
        }
        return result;
    }
}

