/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ctabitemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.custom.ICTabFolderAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class CTabItemLCA
extends AbstractWidgetLCA {
    public static final String EVENT_ITEM_CLOSED = "org.eclipse.swt.events.ctabItemClosed";
    private static final String PROP_TEXT = "text";
    private static final String PROP_IMAGE = "image";
    private static final String PROP_BOUNDS = "bounds";
    private static final String PROP_SELECTED = "selected";
    private static final String PROP_SHOWING = "showing";
    private static final String PROP_UNSELECTED_CLOSE_VISIBLE = "unselectedCloseVisible";
    private static final String PROP_FIRST_ITEM = "firstItem";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void preserveValues(Widget widget) {
        CTabItem item = (CTabItem)widget;
        CTabFolder parent = item.getParent();
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)item);
        adapter.preserve(PROP_TEXT, (Object)CTabItemLCA.getShortenedText(item));
        adapter.preserve(PROP_IMAGE, (Object)CTabItemLCA.getImage(item));
        WidgetLCAUtil.preserveToolTipText((Widget)item, item.getToolTipText());
        adapter.preserve(PROP_BOUNDS, (Object)item.getBounds());
        boolean selected = item == parent.getSelection();
        adapter.preserve(PROP_SELECTED, (Object)selected);
        boolean closeVisible = parent.getUnselectedCloseVisible();
        adapter.preserve(PROP_UNSELECTED_CLOSE_VISIBLE, (Object)closeVisible);
        adapter.preserve(PROP_SHOWING, (Object)item.isShowing());
        adapter.preserve(PROP_FIRST_ITEM, (Object)(item == item.getParent().getItem(0) ? 1 : 0));
        CTabItemLCA.preserveFont(item);
        WidgetLCAUtil.preserveCustomVariant((Widget)item);
    }

    public void readData(Widget widget) {
        final CTabItem item = (CTabItem)widget;
        if (WidgetLCAUtil.wasEventSent((Widget)item, EVENT_ITEM_CLOSED)) {
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    CTabFolderEvent event = CTabItemLCA.createCloseEvent(item);
                    event.processEvent();
                    if (event.doit) {
                        item.dispose();
                    }
                }
            });
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        CTabItem item = (CTabItem)widget;
        CTabFolder parent = item.getParent();
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Object[] args = new Object[]{parent, CTabItemLCA.showClose(item)};
        writer.newWidget("org.eclipse.swt.custom.CTabItem", args);
        writer.call((Widget)parent, "add", new Object[]{item});
    }

    public void renderChanges(Widget widget) throws IOException {
        CTabItem item = (CTabItem)widget;
        WidgetLCAUtil.writeBounds((Widget)item, (Control)item.getParent(), item.getBounds());
        CTabItemLCA.writeText(item);
        CTabItemLCA.writeImage(item);
        CTabItemLCA.writeFont(item);
        WidgetLCAUtil.writeToolTip((Widget)item, item.getToolTipText());
        CTabItemLCA.writeShowing(item);
        CTabItemLCA.writeUnselectedCloseVisible(item);
        CTabItemLCA.writeSelection(item);
        CTabItemLCA.writeFirstItem(item);
        WidgetLCAUtil.writeCustomVariant((Widget)item);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static void writeText(CTabItem item) throws IOException {
        String text = CTabItemLCA.getShortenedText(item);
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_TEXT, text)) {
            text = WidgetLCAUtil.escapeText(text, true);
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set("label", text);
        }
    }

    private static void writeImage(CTabItem item) throws IOException {
        Image newValue = CTabItemLCA.getImage(item);
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_IMAGE, newValue, null)) {
            WidgetLCAUtil.writeImage((Widget)item, "icon", newValue);
        }
    }

    private static void writeFont(CTabItem item) throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = item.getAdapter((Class)clazz);
        IWidgetFontAdapter fontAdapter = (IWidgetFontAdapter)adapter;
        Font font = fontAdapter.getUserFont();
        WidgetLCAUtil.writeFont((Widget)item, font);
    }

    private static void writeSelection(CTabItem item) throws IOException {
        Boolean defValue;
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        boolean selected = item == item.getParent().getSelection();
        Boolean newValue = selected;
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_SELECTED, newValue, defValue = Boolean.FALSE)) {
            writer.set(PROP_SELECTED, (Object)selected);
        }
    }

    private static void writeFirstItem(CTabItem item) throws IOException {
        Boolean defValue;
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        boolean isFirst = item == item.getParent().getItem(0);
        Boolean newValue = isFirst;
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_FIRST_ITEM, newValue, defValue = Boolean.FALSE)) {
            if (isFirst) {
                writer.call("addState", new Object[]{PROP_FIRST_ITEM});
            } else {
                writer.call("removeState", new Object[]{PROP_FIRST_ITEM});
            }
        }
    }

    private static void writeShowing(CTabItem item) throws IOException {
        Boolean newValue = item.isShowing();
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_SHOWING, newValue, Boolean.TRUE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set("visibility", newValue);
        }
    }

    private static void writeUnselectedCloseVisible(CTabItem item) throws IOException {
        String prop = PROP_UNSELECTED_CLOSE_VISIBLE;
        CTabFolder parent = item.getParent();
        Boolean newValue = parent.getUnselectedCloseVisible();
        if (WidgetLCAUtil.hasChanged((Widget)item, prop, newValue, Boolean.TRUE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set(PROP_UNSELECTED_CLOSE_VISIBLE, newValue);
        }
    }

    private static Image getImage(CTabItem item) {
        Image result = item.getImage();
        if (result != null) {
            Object adapter;
            ICTabFolderAdapter folderAdapter;
            CTabFolder cTabFolder = item.getParent();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.internal.custom.ICTabFolderAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!(folderAdapter = (ICTabFolderAdapter)(adapter = cTabFolder.getAdapter((Class)clazz))).showItemImage(item)) {
                result = null;
            }
        }
        return result;
    }

    private static String getShortenedText(CTabItem item) {
        CTabFolder folder = item.getParent();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.custom.ICTabFolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = folder.getAdapter((Class)clazz);
        ICTabFolderAdapter folderAdapter = (ICTabFolderAdapter)adapter;
        return folderAdapter.getShortenedItemText(item);
    }

    private static boolean showClose(CTabItem item) {
        CTabFolder parent = item.getParent();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.custom.ICTabFolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ICTabFolderAdapter adapter = (ICTabFolderAdapter)parent.getAdapter((Class)clazz);
        boolean canClose = adapter.showItemClose(item);
        return canClose;
    }

    private static CTabFolderEvent createCloseEvent(CTabItem item) {
        CTabFolderEvent result = new CTabFolderEvent((Object)item.getParent(), 1);
        result.item = item;
        result.doit = true;
        return result;
    }

    private static void preserveFont(CTabItem item) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = item.getAdapter((Class)clazz);
        IWidgetFontAdapter fontAdapter = (IWidgetFontAdapter)adapter;
        Font font = fontAdapter.getUserFont();
        WidgetLCAUtil.preserveFont((Widget)item, font);
    }
}

