/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.linkkit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.ILinkAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class LinkLCA
extends AbstractWidgetLCA {
    private static final String QX_TYPE = "qx.ui.layout.HorizontalBoxLayout";
    private static final String JS_LINK_UTIL = "org.eclipse.swt.LinkUtil";
    private static final String JS_FUNC_INIT = "org.eclipse.swt.LinkUtil.init";
    private static final String JS_FUNC_ADD_LINK = "org.eclipse.swt.LinkUtil.addLink";
    private static final String JS_FUNC_ADD_TEXT = "org.eclipse.swt.LinkUtil.addText";
    private static final String JS_FUNC_ADD_STATE = "org.eclipse.swt.LinkUtil.addState";
    private static final String JS_FUNC_REMOVE_STATE = "org.eclipse.swt.LinkUtil.removeState";
    private static final String JS_FUNC_CLEAR = "org.eclipse.swt.LinkUtil.clear";
    private static final String JS_FUNC_DESTROY = "org.eclipse.swt.LinkUtil.destroy";
    private static final String JS_FUNC_SET_SELECTION_LISTENER = "org.eclipse.swt.LinkUtil.setSelectionListener";
    private static final String PROP_TEXT = "text";
    private static final String PROP_VARIANT = "variant";
    static final String PROP_SEL_LISTENER = "selectionListener";
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        Link link = (Link)widget;
        ControlLCAUtil.preserveValues((Control)link);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_TEXT, (Object)link.getText());
        Boolean newValue = SelectionEvent.hasListener((Adaptable)link);
        adapter.preserve(PROP_SEL_LISTENER, (Object)newValue);
        WidgetLCAUtil.preserveCustomVariant((Widget)link);
    }

    public void readData(Widget widget) {
        Link link = (Link)widget;
        LinkLCA.processSelectionEvent(link);
        ControlLCAUtil.processMouseEvents((Control)link);
        ControlLCAUtil.processKeyEvents((Control)link);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Link link = (Link)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)link);
        writer.newWidget(QX_TYPE);
        writer.set("appearance", "link");
        Object[] args = new Object[]{widget};
        writer.callStatic(JS_FUNC_INIT, args);
        ControlLCAUtil.writeStyleFlags((Control)link);
    }

    public void renderChanges(Widget widget) throws IOException {
        Link link = (Link)widget;
        ControlLCAUtil.writeChanges((Control)link);
        LinkLCA.writeSelectionListener(link);
        LinkLCA.writeText(link);
        LinkLCA.writeCustomVariant(link);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        Object[] args = new Object[]{widget};
        writer.callStatic(JS_FUNC_DESTROY, args);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
        ControlLCAUtil.resetStyleFlags();
        JSWriter writer = JSWriter.getWriterForResetHandler();
        Object[] args = new Object[]{JSWriter.WIDGET_REF};
        writer.callStatic(JS_FUNC_CLEAR, args);
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static void writeSelectionListener(Link link) throws IOException {
        Boolean defValue;
        String prop = PROP_SEL_LISTENER;
        Boolean newValue = SelectionEvent.hasListener((Adaptable)link);
        if (WidgetLCAUtil.hasChanged((Widget)link, prop, newValue, defValue = Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)link);
            Object[] args = new Object[]{link, newValue};
            writer.callStatic(JS_FUNC_SET_SELECTION_LISTENER, args);
        }
    }

    private static void writeText(Link link) throws IOException {
        String newValue = link.getText();
        if (WidgetLCAUtil.hasChanged((Widget)link, PROP_TEXT, newValue, "")) {
            JSWriter writer = JSWriter.getWriterFor((Widget)link);
            Object[] args = new Object[]{link};
            writer.callStatic(JS_FUNC_CLEAR, args);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ILinkAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ILinkAdapter adapter = (ILinkAdapter)link.getAdapter((Class)clazz);
            String displayText = adapter.getDisplayText();
            Point[] offsets = adapter.getOffsets();
            int length = displayText.length();
            int pos = 0;
            int i = 0;
            while (i < offsets.length) {
                int start = offsets[i].x;
                int end = offsets[i].y + 1;
                if (pos < start) {
                    LinkLCA.writeNormalText(link, displayText.substring(pos, start));
                }
                if (start < end) {
                    LinkLCA.writeLinkText(link, displayText.substring(start, end), i);
                }
                pos = end;
                ++i;
            }
            if (pos < length) {
                LinkLCA.writeNormalText(link, displayText.substring(pos, length));
            }
        }
    }

    private static void writeNormalText(Link link, String text) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)link);
        Object[] args = new Object[]{link, WidgetLCAUtil.escapeText(text, false)};
        writer.callStatic(JS_FUNC_ADD_TEXT, args);
    }

    private static void writeLinkText(Link link, String text, int index) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)link);
        Object[] args = new Object[]{link, WidgetLCAUtil.escapeText(text, false), new Integer(index)};
        writer.callStatic(JS_FUNC_ADD_LINK, args);
    }

    private static void processSelectionEvent(Link link) {
        String eventId = "org.eclipse.swt.events.widgetSelected";
        if (WidgetLCAUtil.wasEventSent((Widget)link, eventId)) {
            ILinkAdapter adapter;
            String[] ids;
            HttpServletRequest request = ContextProvider.getRequest();
            String indexStr = request.getParameter("org.eclipse.swt.events.widgetSelected.index");
            int index = Integer.parseInt(indexStr);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ILinkAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (index < (ids = (adapter = (ILinkAdapter)link.getAdapter((Class)clazz)).getIds()).length) {
                SelectionEvent event = new SelectionEvent((Widget)link, null, 13);
                event.text = ids[index];
                event.processEvent();
            }
        }
    }

    private static void writeCustomVariant(Link link) throws IOException {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)link);
        String oldValue = (String)adapter.getPreserved(PROP_VARIANT);
        String newValue = WidgetUtil.getVariant((Widget)link);
        if (WidgetLCAUtil.hasChanged((Widget)link, PROP_VARIANT, newValue, null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)link);
            Object[] args = new Object[]{link, "variant_" + oldValue};
            if (oldValue != null) {
                writer.callStatic(JS_FUNC_REMOVE_STATE, args);
            }
            if (newValue != null) {
                args = new Object[]{link, "variant_" + newValue};
                writer.callStatic(JS_FUNC_ADD_STATE, args);
            }
        }
    }
}

