/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.textkit;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.swt.internal.widgets.textkit.AbstractTextDelegateLCA;
import org.eclipse.swt.internal.widgets.textkit.MultiTextLCA;
import org.eclipse.swt.internal.widgets.textkit.PasswordTextLCA;
import org.eclipse.swt.internal.widgets.textkit.SingleTextLCA;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public final class TextLCA
extends AbstractWidgetLCA {
    private static final AbstractTextDelegateLCA SINGLE = new SingleTextLCA();
    private static final AbstractTextDelegateLCA PASSWORD = new PasswordTextLCA();
    private static final AbstractTextDelegateLCA MULTI = new MultiTextLCA();

    public void preserveValues(Widget widget) {
        TextLCA.getLCADelegate(widget).preserveValues((Text)widget);
    }

    public void readData(Widget widget) {
        TextLCA.getLCADelegate(widget).readData((Text)widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        TextLCA.getLCADelegate(widget).renderInitialization((Text)widget);
    }

    public void renderChanges(Widget widget) throws IOException {
        TextLCA.getLCADelegate(widget).renderChanges((Text)widget);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
        TextLCA.getLCADelegate(typePoolId).createResetHandlerCalls(typePoolId);
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static AbstractTextDelegateLCA getLCADelegate(String tpId) {
        AbstractTextDelegateLCA result;
        if (PasswordTextLCA.TYPE_POOL_ID.equals(tpId)) {
            result = PASSWORD;
        } else if (SingleTextLCA.TYPE_POOL_ID.equals(tpId)) {
            result = SINGLE;
        } else if (MultiTextLCA.TYPE_POOL_ID.equals(tpId)) {
            result = MULTI;
        } else {
            String txt = "The typePoolId ''{0}'' is not supported.";
            String msg = MessageFormat.format(txt, tpId);
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    private static AbstractTextDelegateLCA getLCADelegate(Widget widget) {
        int style = ((Text)widget).getStyle();
        AbstractTextDelegateLCA result = (style & 0x400000) != 0 ? PASSWORD : ((style & 4) != 0 ? SINGLE : ((style & 2) != 0 ? MULTI : SINGLE));
        return result;
    }
}

