/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treeitemkit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ITreeItemAdapter;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class TreeItemLCA
extends AbstractWidgetLCA {
    public static final String PROP_CHECKED = "checked";
    public static final String PROP_EXPANDED = "expanded";
    public static final String PROP_SELECTION = "selection";
    public static final String PROP_BACKGROUND = "background";
    public static final String PROP_FOREGROUND = "foreground";
    public static final String PROP_FONT = "font";
    public static final String PROP_CELL_BACKGROUNDS = "backgrounds";
    public static final String PROP_CELL_FOREGROUNDS = "foregrounds";
    public static final String PROP_CELL_FONTS = "fonts";
    public static final String PROP_GRAYED = "grayed";
    public static final String PROP_TEXTS = "texts";
    public static final String PROP_IMAGES = "images";
    public static final String PROP_MATERIALIZED = "materialized";
    private static final String STATE_COLLAPSED = "collapsed";
    private static final String STATE_EXPANDED = "expanded";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public void preserveValues(Widget widget) {
        TreeItem treeItem = (TreeItem)widget;
        Tree tree = treeItem.getParent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeAdapter treeAdapter = (ITreeAdapter)tree.getAdapter((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemAdapter itemAdapter = (ITreeItemAdapter)treeItem.getAdapter((Class)clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetColorAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWidgetColorAdapter colorAdapter = (IWidgetColorAdapter)treeItem.getAdapter((Class)clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWidgetFontAdapter fontAdapter = (IWidgetFontAdapter)treeItem.getAdapter((Class)clazz4);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)treeItem);
        if (treeAdapter.isCached(treeItem)) {
            TreeItemLCA.preserveFont(treeItem);
            adapter.preserve(PROP_CHECKED, (Object)treeItem.getChecked());
            adapter.preserve("expanded", (Object)treeItem.getExpanded());
            adapter.preserve(PROP_TEXTS, (Object)TreeItemLCA.getTexts(treeItem));
            adapter.preserve(PROP_IMAGES, (Object)TreeItemLCA.getImages(treeItem));
            boolean selection = TreeItemLCA.isSelected(treeItem);
            adapter.preserve(PROP_SELECTION, (Object)selection);
            adapter.preserve(PROP_BACKGROUND, (Object)colorAdapter.getUserBackgound());
            adapter.preserve(PROP_FOREGROUND, (Object)colorAdapter.getUserForegound());
            adapter.preserve(PROP_FONT, (Object)fontAdapter.getUserFont());
            adapter.preserve(PROP_CELL_BACKGROUNDS, (Object)itemAdapter.getCellBackgrounds());
            adapter.preserve(PROP_CELL_FOREGROUNDS, (Object)itemAdapter.getCellForegrounds());
            adapter.preserve(PROP_CELL_FONTS, (Object)itemAdapter.getCellFonts());
            adapter.preserve(PROP_GRAYED, (Object)treeItem.getGrayed());
        }
        adapter.preserve(PROP_MATERIALIZED, (Object)treeAdapter.isCached(treeItem));
        WidgetLCAUtil.preserveCustomVariant((Widget)treeItem);
    }

    public void readData(Widget widget) {
        String state;
        TreeItem treeItem = (TreeItem)widget;
        String value = WidgetLCAUtil.readPropertyValue(widget, PROP_CHECKED);
        if (value != null) {
            treeItem.setChecked(Boolean.valueOf(value).booleanValue());
        }
        if ("expanded".equals(state = WidgetLCAUtil.readPropertyValue(widget, "state")) || STATE_COLLAPSED.equals(state)) {
            treeItem.setExpanded("expanded".equals(state));
        }
        TreeItemLCA.processTreeExpandedEvent(widget);
        TreeItemLCA.processTreeCollapsedEvent(widget);
    }

    public void renderInitialization(Widget widget) throws IOException {
        TreeItem treeItem = (TreeItem)widget;
        JSWriter writer = JSWriter.getWriterFor(widget);
        Object parent = treeItem.getParentItem() == null ? treeItem.getParent() : treeItem.getParentItem();
        Object[] args = new Object[]{WidgetUtil.getId((Widget)treeItem), parent, treeItem.getParent()};
        writer.callStatic("org.eclipse.swt.TreeItemUtil.createTreeItem", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        ITreeAdapter adapter;
        TreeItem treeItem = (TreeItem)widget;
        Tree tree = treeItem.getParent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ITreeAdapter)tree.getAdapter((Class)clazz)).isCached(treeItem)) {
            TreeItemLCA.writeImages(treeItem);
            TreeItemLCA.writeTexts(treeItem);
            TreeItemLCA.writeBackground(treeItem);
            TreeItemLCA.writeForeground(treeItem);
            TreeItemLCA.writeFont(treeItem);
            TreeItemLCA.writeCellBackgrounds(treeItem);
            TreeItemLCA.writeCellForegrounds(treeItem);
            TreeItemLCA.writeCellFonts(treeItem);
            TreeItemLCA.writeSelection(treeItem);
            TreeItemLCA.writeExpanded(treeItem);
            TreeItemLCA.writeChecked(treeItem);
            TreeItemLCA.writeGrayed(treeItem);
            this.writeShowItem(treeItem);
        }
        this.writeMaterialized(treeItem);
        WidgetLCAUtil.writeCustomVariant((Widget)treeItem);
    }

    private void writeMaterialized(TreeItem treeItem) throws IOException {
        Tree tree = treeItem.getParent();
        if ((tree.getStyle() & 0x10000000) != 0) {
            JSWriter writer = JSWriter.getWriterFor((Widget)treeItem);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ITreeAdapter adapter = (ITreeAdapter)tree.getAdapter((Class)clazz);
            writer.set(PROP_MATERIALIZED, PROP_MATERIALIZED, adapter.isCached(treeItem));
        }
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.call("destroy", null);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private void writeShowItem(TreeItem item) throws IOException {
        ITreeAdapter adapter;
        TreeItem showItem;
        Tree tree = item.getParent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((showItem = (adapter = (ITreeAdapter)tree.getAdapter((Class)clazz)).getShowItem()) != null && showItem == item) {
            JSWriter writer = JSWriter.getWriterFor((Widget)tree);
            writer.call((Widget)tree, "showItem", new Object[]{showItem});
            adapter.clearShowItem();
        }
    }

    private static void writeImages(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Image[] images = TreeItemLCA.getImages(item);
        Integer[] imageWidths = new Integer[images.length];
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_IMAGES, images)) {
            String[] imagePaths = new String[images.length];
            int i = 0;
            while (i < imagePaths.length) {
                imagePaths[i] = ResourceFactory.getImagePath((Image)images[i]);
                imageWidths[i] = new Integer(item.getImageBounds((int)i).width);
                ++i;
            }
            writer.set(PROP_IMAGES, new Object[]{imagePaths});
        }
    }

    private static void preserveFont(TreeItem treeItem) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWidgetFontAdapter fontAdapter = (IWidgetFontAdapter)treeItem.getAdapter((Class)clazz);
        Font font = fontAdapter.getUserFont();
        WidgetLCAUtil.preserveFont((Widget)treeItem, font);
    }

    private static void writeExpanded(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Boolean newValue = item.getExpanded();
        writer.set("expanded", "open", newValue, Boolean.FALSE);
    }

    private static void writeChecked(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Boolean newValue = item.getChecked();
        writer.set(PROP_CHECKED, PROP_CHECKED, newValue, Boolean.FALSE);
    }

    private static void writeSelection(TreeItem item) throws IOException {
        Boolean defValue;
        Boolean newValue = TreeItemLCA.isSelected(item);
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_SELECTION, newValue, defValue = Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            Boolean focused = TreeItemLCA.isFocused(item);
            writer.set(PROP_SELECTION, new Object[]{newValue, focused});
        }
    }

    private static void writeFont(TreeItem treeItem) throws IOException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = treeItem.getAdapter((Class)clazz);
        IWidgetFontAdapter fontAdapter = (IWidgetFontAdapter)adapter;
        Font font = fontAdapter.getUserFont();
        WidgetLCAUtil.writeFont((Widget)treeItem, font);
    }

    private static void writeCellFonts(TreeItem item) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemAdapter itemAdapter = (ITreeItemAdapter)item.getAdapter((Class)clazz);
        Font[] fonts = itemAdapter.getCellFonts();
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_CELL_FONTS, fonts, null)) {
            String[] css = null;
            if (fonts != null) {
                css = new String[fonts.length];
                int i = 0;
                while (i < fonts.length) {
                    css[i] = TreeItemLCA.toCss(fonts[i]);
                    ++i;
                }
            }
            writer.set(PROP_CELL_FONTS, new Object[]{css});
        }
    }

    private static void writeBackground(TreeItem item) throws IOException {
        IWidgetColorAdapter colorAdapter;
        Color background;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetColorAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_BACKGROUND, background = (colorAdapter = (IWidgetColorAdapter)item.getAdapter((Class)clazz)).getUserBackgound(), null)) {
            WidgetLCAUtil.writeBackground((Widget)item, background);
        }
    }

    private static void writeForeground(TreeItem item) throws IOException {
        IWidgetColorAdapter colorAdapter;
        Color foreground;
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetColorAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_FOREGROUND, foreground = (colorAdapter = (IWidgetColorAdapter)item.getAdapter((Class)clazz)).getUserForegound(), null)) {
            WidgetLCAUtil.writeForeground((Widget)item, foreground);
        }
    }

    private static void writeCellBackgrounds(TreeItem item) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemAdapter itemAdapter = (ITreeItemAdapter)item.getAdapter((Class)clazz);
        Color[] backgrounds = itemAdapter.getCellBackgrounds();
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        writer.set(PROP_CELL_BACKGROUNDS, PROP_CELL_BACKGROUNDS, backgrounds, null);
    }

    private static void writeCellForegrounds(TreeItem item) throws IOException {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemAdapter itemAdapter = (ITreeItemAdapter)item.getAdapter((Class)clazz);
        Color[] foregrounds = itemAdapter.getCellForegrounds();
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        writer.set(PROP_CELL_FOREGROUNDS, PROP_CELL_FOREGROUNDS, foregrounds, null);
    }

    private static void writeTexts(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        String[] texts = TreeItemLCA.getTexts(item);
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_TEXTS, texts)) {
            int i = 0;
            while (i < texts.length) {
                texts[i] = WidgetLCAUtil.escapeText(texts[i], false);
                texts[i] = texts[i].replaceAll(" ", "&nbsp;");
                ++i;
            }
            writer.set(PROP_TEXTS, new Object[]{texts});
        }
    }

    private static String[] getTexts(TreeItem item) {
        int columnCount = TreeItemLCA.getColumnCount(item);
        String[] texts = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            texts[i] = item.getText(i);
            ++i;
        }
        return texts;
    }

    private static Image[] getImages(TreeItem item) {
        int columnCount = TreeItemLCA.getColumnCount(item);
        Image[] images = new Image[columnCount];
        int i = 0;
        while (i < columnCount) {
            images[i] = item.getImage(i);
            ++i;
        }
        return images;
    }

    private static int getColumnCount(TreeItem item) {
        return Math.max(1, item.getParent().getColumnCount());
    }

    private static void writeGrayed(TreeItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Boolean newValue = item.getGrayed();
        writer.set(PROP_GRAYED, PROP_GRAYED, newValue, Boolean.FALSE);
    }

    private static boolean isFocused(TreeItem item) {
        Tree tree = item.getParent();
        return tree.getSelectionCount() > 0 && tree.getSelection()[0] == item;
    }

    private static boolean isSelected(TreeItem item) {
        boolean result = false;
        Tree tree = item.getParent();
        TreeItem[] selectedItems = tree.getSelection();
        int i = 0;
        while (!result && i < selectedItems.length) {
            if (item == selectedItems[i]) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private static String toCss(Font font) {
        StringBuffer result = new StringBuffer();
        if (font != null) {
            FontData fontData = font.getFontData()[0];
            if ((fontData.getStyle() & 2) != 0) {
                result.append("italic ");
            }
            if ((fontData.getStyle() & 1) != 0) {
                result.append("bold ");
            }
            result.append(fontData.getHeight());
            result.append("px ");
            String escapedName = fontData.getName().replaceAll("\"", "");
            result.append(escapedName);
        } else {
            result.append("");
        }
        return result.toString();
    }

    private static void processTreeExpandedEvent(Widget widget) {
        HttpServletRequest request = ContextProvider.getRequest();
        String id = request.getParameter("org.eclipse.swt.events.treeExpanded");
        if (WidgetUtil.getId((Widget)widget).equals(id)) {
            TreeItem treeItem = (TreeItem)widget;
            TreeEvent event = new TreeEvent((Widget)treeItem.getParent(), (Widget)treeItem, 17);
            event.processEvent();
        }
    }

    private static void processTreeCollapsedEvent(Widget widget) {
        HttpServletRequest request = ContextProvider.getRequest();
        String id = request.getParameter("org.eclipse.swt.events.treeCollapsed");
        if (WidgetUtil.getId((Widget)widget).equals(id)) {
            TreeItem treeItem = (TreeItem)widget;
            TreeEvent event = new TreeEvent((Widget)treeItem.getParent(), (Widget)treeItem, 18);
            event.processEvent();
        }
    }
}

