/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.browser;

import java.text.NumberFormat;
import org.eclipse.rwt.internal.browser.DetectorBase;

public class DetectorIE
extends DetectorBase {
    private static final String ID_OPERA = "opera";
    private static final String ID_MSIE = "msie";
    private static final String ID_MSIE5 = "msie 5";
    private static final String ID_MSIE5_5 = "msie 5.5";
    private static final String ID_MSIE6 = "msie 6";
    private static final String ID_MSIE7 = "msie 7";

    public boolean knowsBrowserString(String userAgent) {
        return !"".equals(this.getBrowserVersion(userAgent));
    }

    public String getBrowserClassName(String userAgent) {
        return "org.eclipse.rwt.internal.browser.Ie" + this.getBrowserVersion(userAgent);
    }

    public String getBrowserVersion(String userAgent) {
        String result = "";
        if (DetectorIE.contains(userAgent, ID_MSIE) && !DetectorIE.contains(userAgent, ID_OPERA)) {
            if (DetectorIE.contains(userAgent, ID_MSIE5_5)) {
                result = "5_5";
            } else if (DetectorIE.contains(userAgent, ID_MSIE5)) {
                result = "5";
            } else if (DetectorIE.contains(userAgent, ID_MSIE6)) {
                result = "6";
            } else if (DetectorIE.contains(userAgent, ID_MSIE7)) {
                result = "7";
            } else if (DetectorIE.getMajor(userAgent) > 6) {
                result = "7";
            }
        }
        return result;
    }

    private static int getMajor(String userAgent) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        int result = -1;
        try {
            String appVersion = DetectorIE.parseAppVersion(userAgent);
            int index = appVersion.indexOf(".");
            if (index != -1) {
                appVersion = appVersion.substring(0, index);
            }
            result = nf.parse(appVersion).intValue();
        }
        catch (Exception exception) {}
        return result;
    }

    private static String parseAppVersion(String userAgent) {
        String result = "";
        int index = userAgent.indexOf(ID_MSIE);
        int start = index + ID_MSIE.length() + 1;
        result = userAgent.substring(start, start + 3);
        return result;
    }
}

