/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.browser;

import org.eclipse.rwt.internal.browser.DetectorBase;

public class DetectorKonqueror
extends DetectorBase {
    private static final String VERSION_PREFIX = "konqueror/";
    private static final String ID_KONQUEROR = "konqueror";

    public boolean knowsBrowserString(String userAgent) {
        return DetectorKonqueror.contains(userAgent, ID_KONQUEROR);
    }

    public String getBrowserName(String userAgent) {
        return "Konqueror";
    }

    public String getBrowserClassName(String userAgent) {
        String result = "org.eclipse.rwt.internal.browser." + this.getBrowserName(userAgent) + this.getBrowserVersion(userAgent);
        return result;
    }

    public String getBrowserVersion(String userAgent) {
        String result = "";
        int[] versions = this.getVersions(userAgent);
        if (versions[0] == 3) {
            if (versions[1] == 1) {
                result = "3_1";
            } else if (versions[1] == 2) {
                result = "3_2";
            } else if (versions[1] == 3) {
                result = "3_3";
            } else if (versions[1] >= 4) {
                result = "3_4";
            }
        }
        return result;
    }

    private int[] getVersions(String userAgent) {
        int absoluteEnd;
        int absoluteStart;
        String version;
        String[] parts;
        int endIndex;
        int[] result = new int[]{-1, -1};
        int startIndex = userAgent.indexOf(VERSION_PREFIX);
        if (startIndex != -1 && (endIndex = userAgent.substring(startIndex).indexOf(";")) != -1 && (parts = (version = userAgent.substring(absoluteStart = startIndex + VERSION_PREFIX.length(), absoluteEnd = startIndex + endIndex)).split("\\.", 2)).length == 2) {
            try {
                result[0] = Integer.parseInt(parts[0]);
                result[1] = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }
}

