/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rwt.internal.theme.QxBorder;
import org.eclipse.rwt.internal.theme.QxBoxDimensions;
import org.eclipse.rwt.internal.theme.QxColor;
import org.eclipse.rwt.internal.theme.QxDimension;
import org.eclipse.rwt.internal.theme.QxFont;
import org.eclipse.rwt.internal.theme.QxIdentifier;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.ResourceLoader;
import org.w3c.css.sac.LexicalUnit;

public final class PropertyResolver {
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";
    private static final String NORMAL = "normal";
    private static final String NONE = "none";
    private static final String HIDDEN = "hidden";
    private static final String DOTTED = "dotted";
    private static final String DASHED = "dashed";
    private static final String SOLID = "solid";
    private static final String DOUBLE = "double";
    private static final String GROOVE = "groove";
    private static final String RIDGE = "ridge";
    private static final String INSET = "inset";
    private static final String OUTSET = "outset";
    private static final String THIN = "thin";
    private static final String MEDIUM = "medium";
    private static final String THICK = "thick";
    private static final String TRANSPARENT = "transparent";
    private static final Map NAMED_COLORS = new HashMap();
    private static final List BORDER_STYLES = new ArrayList();
    static final int THIN_VALUE = 1;
    static final int MEDIUM_VALUE = 3;
    static final int THICK_VALUE = 5;

    static {
        NAMED_COLORS.put("black", new int[3]);
        NAMED_COLORS.put("gray", new int[]{128, 128, 128});
        NAMED_COLORS.put("silver", new int[]{192, 192, 192});
        NAMED_COLORS.put("white", new int[]{255, 255, 255});
        int[] nArray = new int[3];
        nArray[0] = 128;
        NAMED_COLORS.put("maroon", nArray);
        int[] nArray2 = new int[3];
        nArray2[0] = 255;
        NAMED_COLORS.put("red", nArray2);
        int[] nArray3 = new int[3];
        nArray3[0] = 128;
        nArray3[2] = 128;
        NAMED_COLORS.put("purple", nArray3);
        int[] nArray4 = new int[3];
        nArray4[0] = 255;
        nArray4[2] = 255;
        NAMED_COLORS.put("fuchsia", nArray4);
        int[] nArray5 = new int[3];
        nArray5[1] = 128;
        NAMED_COLORS.put("green", nArray5);
        int[] nArray6 = new int[3];
        nArray6[1] = 255;
        NAMED_COLORS.put("lime", nArray6);
        int[] nArray7 = new int[3];
        nArray7[2] = 128;
        NAMED_COLORS.put("navy", nArray7);
        int[] nArray8 = new int[3];
        nArray8[2] = 255;
        NAMED_COLORS.put("blue", nArray8);
        int[] nArray9 = new int[3];
        nArray9[0] = 128;
        nArray9[1] = 128;
        NAMED_COLORS.put("olive", nArray9);
        int[] nArray10 = new int[3];
        nArray10[0] = 255;
        nArray10[1] = 255;
        NAMED_COLORS.put("yellow", nArray10);
        int[] nArray11 = new int[3];
        nArray11[1] = 128;
        nArray11[2] = 128;
        NAMED_COLORS.put("teal", nArray11);
        int[] nArray12 = new int[3];
        nArray12[1] = 255;
        nArray12[2] = 255;
        NAMED_COLORS.put("aqua", nArray12);
        BORDER_STYLES.add(NONE);
        BORDER_STYLES.add(HIDDEN);
        BORDER_STYLES.add(DOTTED);
        BORDER_STYLES.add(DASHED);
        BORDER_STYLES.add(SOLID);
        BORDER_STYLES.add(DOUBLE);
        BORDER_STYLES.add(GROOVE);
        BORDER_STYLES.add(RIDGE);
        BORDER_STYLES.add(INSET);
        BORDER_STYLES.add(OUTSET);
    }

    public static QxType resolveProperty(String name, LexicalUnit unit, ResourceLoader loader) {
        QxType result;
        String type = PropertyResolver.getType(name);
        if (type == null) {
            throw new IllegalArgumentException("Unknown property " + name);
        }
        if ("boolean".equals(type)) {
            throw new IllegalArgumentException("Currently not supported");
        }
        if ("border".equals(type)) {
            result = PropertyResolver.readBorder(unit);
        } else if ("boxdim".equals(type)) {
            result = PropertyResolver.readBoxDimensions(unit);
        } else if ("color".equals(type)) {
            result = PropertyResolver.readColor(unit);
        } else if ("dimension".equals(type)) {
            result = PropertyResolver.readDimension(unit);
        } else if ("font".equals(type)) {
            result = PropertyResolver.readFont(unit);
        } else if ("image".equals(type)) {
            result = PropertyResolver.readBackgroundImage(unit, loader);
        } else if ("text-decoration".equals(type)) {
            result = PropertyResolver.readTextDecoration(unit);
        } else {
            throw new RuntimeException("Illegal type " + type);
        }
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse value " + PropertyResolver.toString(unit));
        }
        return result;
    }

    public static String getType(String property) {
        String result = null;
        if ("padding".equals(property) || "margin".equals(property)) {
            result = "boxdim";
        } else if ("color".equals(property) || "background-color".equals(property) || property.endsWith("-color")) {
            result = "color";
        } else if ("font".equals(property)) {
            result = "font";
        } else if ("border".equals(property)) {
            result = "border";
        } else if ("spacing".equals(property) || "width".equals(property) || "height".equals(property)) {
            result = "dimension";
        } else if ("background-image".equals(property) || property.endsWith("-image")) {
            result = "image";
        } else if ("text-decoration".equals(property)) {
            result = "text-decoration";
        }
        return result;
    }

    static QxColor readColor(LexicalUnit input) {
        QxColor result = null;
        short type = input.getLexicalUnitType();
        if (type == 27) {
            LexicalUnit redParam = input.getParameters();
            LexicalUnit greenParam = redParam.getNextLexicalUnit().getNextLexicalUnit();
            LexicalUnit blueParam = greenParam.getNextLexicalUnit().getNextLexicalUnit();
            short valueType = redParam.getLexicalUnitType();
            if (greenParam.getLexicalUnitType() == valueType || blueParam.getLexicalUnitType() == valueType) {
                if (valueType == 13) {
                    int red = PropertyResolver.normalizeRGBValue(redParam.getIntegerValue());
                    int green = PropertyResolver.normalizeRGBValue(greenParam.getIntegerValue());
                    int blue = PropertyResolver.normalizeRGBValue(blueParam.getIntegerValue());
                    result = QxColor.create(red, green, blue);
                } else if (valueType == 23) {
                    float redPercent = PropertyResolver.normalizePercentValue(redParam.getFloatValue());
                    float greenPercent = PropertyResolver.normalizePercentValue(greenParam.getFloatValue());
                    float bluePercent = PropertyResolver.normalizePercentValue(blueParam.getFloatValue());
                    int red = (int)(255.0f * redPercent / 100.0f);
                    int green = (int)(255.0f * greenPercent / 100.0f);
                    int blue = (int)(255.0f * bluePercent / 100.0f);
                    result = QxColor.create(red, green, blue);
                }
            }
        } else if (type == 35) {
            String string = input.getStringValue();
            if (TRANSPARENT.equals(string)) {
                result = QxColor.TRANSPARENT;
            } else if (NAMED_COLORS.containsKey(string.toLowerCase())) {
                int[] values = (int[])NAMED_COLORS.get(string.toLowerCase());
                result = QxColor.create(values[0], values[1], values[2]);
            }
        } else if (type == 12) {
            result = QxColor.TRANSPARENT;
        }
        return result;
    }

    static QxDimension readDimension(LexicalUnit unit) {
        QxDimension result = null;
        Integer length = PropertyResolver.readSingleLengthUnit(unit);
        if (length != null) {
            result = QxDimension.create(length);
        }
        return result;
    }

    static QxBoxDimensions readBoxDimensions(LexicalUnit unit) {
        QxBoxDimensions result = null;
        Integer value1 = PropertyResolver.readSingleLengthUnit(unit);
        if (value1 != null) {
            int left;
            int bottom = left = value1.intValue();
            int right = left;
            int top = left;
            LexicalUnit nextUnit = unit.getNextLexicalUnit();
            boolean ok = true;
            int pos = 1;
            while (nextUnit != null && ok) {
                Integer nextValue = PropertyResolver.readSingleLengthUnit(nextUnit);
                if (ok &= nextValue != null && ++pos <= 4) {
                    if (pos == 2) {
                        right = left = nextValue.intValue();
                    } else if (pos == 3) {
                        bottom = nextValue;
                    } else if (pos == 4) {
                        left = nextValue;
                    }
                }
                nextUnit = nextUnit.getNextLexicalUnit();
            }
            if (ok &= nextUnit == null) {
                result = QxBoxDimensions.create(top, right, bottom, left);
            }
        }
        return result;
    }

    static String readBorderStyle(LexicalUnit unit) {
        String string;
        String result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35 && BORDER_STYLES.contains(string = unit.getStringValue())) {
            result = string;
        }
        return result;
    }

    static int readBorderWidth(LexicalUnit unit) {
        float value;
        int result = -1;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            String string = unit.getStringValue();
            if (THIN.equals(string)) {
                result = 1;
            } else if (MEDIUM.equals(string)) {
                result = 3;
            } else if (THICK.equals(string)) {
                result = 5;
            }
        } else if (type == 17 && (value = unit.getFloatValue()) >= 0.0f) {
            result = Math.round(value);
        }
        return result;
    }

    static QxBorder readBorder(LexicalUnit unit) {
        QxBorder result = null;
        QxColor color = null;
        String style = null;
        int width = -1;
        LexicalUnit nextUnit = unit;
        boolean consumed = false;
        while (nextUnit != null) {
            consumed = false;
            if (!consumed && width == -1) {
                width = PropertyResolver.readBorderWidth(nextUnit);
                consumed |= width != -1;
            }
            if (!consumed && style == null) {
                style = PropertyResolver.readBorderStyle(nextUnit);
                consumed |= style != null;
            }
            if (!consumed && color == null) {
                color = PropertyResolver.readColor(nextUnit);
                consumed |= color != null;
            }
            LexicalUnit lexicalUnit = nextUnit = consumed ? nextUnit.getNextLexicalUnit() : null;
        }
        if (consumed) {
            result = QxBorder.create(width == -1 ? 0 : width, style, color != null ? color.toDefaultString() : null);
        }
        return result;
    }

    static String readFontStyle(LexicalUnit unit) {
        String result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            String value = unit.getStringValue();
            if (NORMAL.equals(value)) {
                result = value;
            } else if (ITALIC.equals(value)) {
                result = value;
            }
        }
        return result;
    }

    static String readFontWeight(LexicalUnit unit) {
        String result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            String value = unit.getStringValue();
            if (NORMAL.equals(value)) {
                result = value;
            } else if (BOLD.equals(value)) {
                result = value;
            }
        }
        return result;
    }

    static int readFontSize(LexicalUnit unit) {
        int value;
        int result = -1;
        Integer length = PropertyResolver.readSingleLengthUnit(unit);
        if (length != null && (value = length.intValue()) >= 0) {
            result = value;
        }
        return result;
    }

    static String[] readFontFamily(LexicalUnit unit) {
        ArrayList<String> list = new ArrayList<String>();
        LexicalUnit nextUnit = unit;
        boolean ok = true;
        String buffer = "";
        while (nextUnit != null && ok) {
            short type = nextUnit.getLexicalUnitType();
            if (type == 36 || type == 35) {
                if (buffer.length() > 0) {
                    buffer = String.valueOf(buffer) + " ";
                }
                buffer = String.valueOf(buffer) + nextUnit.getStringValue();
            } else if (type == 0) {
                if (buffer.length() > 0) {
                    list.add(buffer);
                } else {
                    ok = false;
                }
                buffer = "";
            }
            nextUnit = nextUnit.getNextLexicalUnit();
        }
        String[] result = null;
        if (buffer.length() > 0) {
            list.add(buffer);
            result = new String[list.size()];
            list.toArray(result);
        }
        return result;
    }

    static QxFont readFont(LexicalUnit unit) {
        QxFont result = null;
        String[] family = null;
        String style = null;
        String weight = null;
        int size = -1;
        boolean consumed = false;
        boolean consumedSize = false;
        boolean consumedFamily = false;
        LexicalUnit nextUnit = unit;
        while (nextUnit != null && !consumedFamily) {
            consumed = false;
            if (!consumed && !consumedSize && style == null) {
                style = PropertyResolver.readFontStyle(nextUnit);
                consumed |= style != null;
            }
            if (!consumed && !consumedSize && weight == null) {
                weight = PropertyResolver.readFontWeight(nextUnit);
                consumed |= weight != null;
            }
            if (!consumed && !consumedFamily && size == -1) {
                size = PropertyResolver.readFontSize(nextUnit);
                consumedSize = size != -1;
                consumed |= consumedSize;
            }
            if (!consumed && consumedSize && family == null) {
                family = PropertyResolver.readFontFamily(nextUnit);
                consumedFamily = family != null;
                consumed |= consumedFamily;
            }
            LexicalUnit lexicalUnit = nextUnit = consumed ? nextUnit.getNextLexicalUnit() : null;
        }
        if (consumed && consumedSize && consumedFamily) {
            boolean bold = BOLD.equals(weight);
            boolean italic = ITALIC.equals(style);
            result = QxFont.create(family, size, bold, italic);
        }
        return result;
    }

    static String readUrl(LexicalUnit unit) {
        String result = null;
        short type = unit.getLexicalUnitType();
        if (type == 24) {
            result = unit.getStringValue();
        }
        return result;
    }

    static QxImage readBackgroundImage(LexicalUnit unit, ResourceLoader loader) {
        String value;
        QxImage result = null;
        short type = unit.getLexicalUnitType();
        if (type == 24) {
            String value2 = unit.getStringValue();
            result = QxImage.valueOf(value2, loader);
        } else if (type == 35 && NONE.equals(value = unit.getStringValue())) {
            result = QxImage.NONE;
        }
        return result;
    }

    static QxIdentifier readTextDecoration(LexicalUnit unit) {
        QxIdentifier result = null;
        short type = unit.getLexicalUnitType();
        if (type == 35) {
            String value = unit.getStringValue();
            if ("underline".equals(value) || "overline".equals(value) || "line-through".equals(value) || NONE.equals(value)) {
                result = new QxIdentifier(value);
            } else {
                String msg = "Invalid value for text-decoration: " + value;
                throw new IllegalArgumentException(msg);
            }
        }
        return result;
    }

    private static Integer readSingleLengthUnit(LexicalUnit unit) {
        Integer result = null;
        short type = unit.getLexicalUnitType();
        if (type == 17) {
            result = new Integer((int)unit.getFloatValue());
        }
        return result;
    }

    private static int normalizeRGBValue(int input) {
        int result = input;
        if (input < 0) {
            result = 0;
        } else if (input > 255) {
            result = 255;
        }
        return result;
    }

    private static float normalizePercentValue(float input) {
        float result = input;
        if (input < 0.0f) {
            result = 0.0f;
        } else if (input > 100.0f) {
            result = 100.0f;
        }
        return result;
    }

    static String toString(LexicalUnit value) {
        StringBuffer buffer = new StringBuffer();
        short type = value.getLexicalUnitType();
        if (type == 37) {
            buffer.append("ATTR " + value.getStringValue());
        } else if (type == 19 || type == 28 || type == 15 || type == 16 || type == 29 || type == 33 || type == 18 || type == 34 || type == 20 || type == 31 || type == 23 || type == 22 || type == 21 || type == 17 || type == 30 || type == 32 || type == 42) {
            buffer.append("DIM " + value.getFloatValue() + value.getDimensionUnitText());
        } else if (type == 27) {
            LexicalUnit parameters = value.getParameters();
            buffer.append("rgb(" + PropertyResolver.toString(parameters) + ")");
        } else if (type == 36) {
            buffer.append("\"" + value.getStringValue() + "\"");
        } else if (type == 35) {
            buffer.append(value.getStringValue());
        } else if (type == 17) {
            buffer.append(String.valueOf(value.getFloatValue()) + "px");
        } else if (type == 13) {
            buffer.append(value.getIntegerValue());
        } else if (type == 0) {
            buffer.append(",");
        } else if (type == 37) {
            buffer.append("ATTR " + value.getStringValue());
        } else if (type == 41) {
            buffer.append("UNKNOWN FUNCTION " + value.getFunctionName());
        } else if (type == 42) {
            buffer.append("UNKNOWN DIMENSION " + value);
        } else {
            buffer.append("unsupported unit " + value.getLexicalUnitType());
        }
        LexicalUnit next = value.getNextLexicalUnit();
        if (next != null) {
            buffer.append(" ");
            buffer.append(PropertyResolver.toString(next));
        }
        return buffer.toString();
    }
}

