/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import org.eclipse.rwt.internal.theme.css.Element;
import org.eclipse.rwt.internal.theme.css.ElementMatcher;
import org.eclipse.rwt.internal.theme.css.IStylePropertyMap;
import org.eclipse.rwt.internal.theme.css.Specific;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;

public class StyleRule
implements ElementMatcher {
    private final SelectorList selectors;
    private final IStylePropertyMap properties;

    public StyleRule(SelectorList selectors, IStylePropertyMap properties) {
        this.selectors = selectors;
        this.properties = properties;
    }

    public SelectorList getSelectors() {
        return this.selectors;
    }

    public IStylePropertyMap getProperties() {
        return this.properties;
    }

    public Selector getMatchingSelector(Element element) {
        Selector result = null;
        int maxSpecificity = -1;
        int length = this.selectors.getLength();
        int i = 0;
        while (i < length) {
            int specificity;
            Selector selector = this.selectors.item(i);
            ElementMatcher matcher = (ElementMatcher)((Object)selector);
            if (matcher.matches(element) && (specificity = ((Specific)((Object)selector)).getSpecificity()) > maxSpecificity) {
                result = selector;
                maxSpecificity = specificity;
            }
            ++i;
        }
        return result;
    }

    public boolean matches(Element element) {
        return this.getMatchingSelector(element) != null;
    }
}

