/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.widgets;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public final class ExternalBrowser {
    public static final int LOCATION_BAR = 2;
    public static final int NAVIGATION_BAR = 4;
    public static final int STATUS = 8;
    private static final String JS_EXECUTOR;
    private static final String OPEN = "org.eclipse.rwt.widgets.ExternalBrowser.open( \"{0}\", \"{1}\", \"{2}\" );";
    private static final String CLOSE = "org.eclipse.rwt.widgets.ExternalBrowser.close( \"{0}\" );";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.widgets.ExternalBrowser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        JS_EXECUTOR = String.valueOf(clazz.getName()) + "#jsExecutor";
    }

    public static void open(String id, String url, int style) {
        ExternalBrowser.checkWidget();
        if (id == null || url == null) {
            SWT.error(4);
        }
        if (id.length() == 0) {
            SWT.error(5);
        }
        ExternalBrowser.executeJS(ExternalBrowser.getOpenJS(id, url, style));
    }

    public static void close(String id) {
        ExternalBrowser.checkWidget();
        if (id == null) {
            SWT.error(4);
        }
        if (id.length() == 0) {
            SWT.error(5);
        }
        ExternalBrowser.executeJS(ExternalBrowser.getCloseJS(id));
    }

    private static String getOpenJS(String id, String url, int style) {
        Object[] args = new String[]{ExternalBrowser.escapeId(id), url, ExternalBrowser.getFeatures(style)};
        return MessageFormat.format(OPEN, args);
    }

    private static String getCloseJS(String id) {
        return MessageFormat.format(CLOSE, ExternalBrowser.escapeId(id));
    }

    static String escapeId(String id) {
        String result = id;
        result = result.replaceAll("\\_", "\\_0");
        result = result.replaceAll("\\.", "\\_");
        return result;
    }

    private static String getFeatures(int style) {
        StringBuffer result = new StringBuffer();
        ExternalBrowser.appendFeature(result, "dependent", true);
        ExternalBrowser.appendFeature(result, "scrollbars", true);
        ExternalBrowser.appendFeature(result, "resizable", true);
        ExternalBrowser.appendFeature(result, "status", (style & 8) != 0);
        ExternalBrowser.appendFeature(result, "location", (style & 2) != 0);
        boolean navigation = (style & 4) != 0;
        ExternalBrowser.appendFeature(result, "toolbar", navigation);
        ExternalBrowser.appendFeature(result, "menubar", navigation);
        return result.toString();
    }

    private static void appendFeature(StringBuffer features, String feature, boolean enable) {
        if (features.length() > 0) {
            features.append(",");
        }
        features.append(feature);
        features.append("=");
        features.append(enable ? 1 : 0);
    }

    private static void executeJS(String code) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        JSExecutor jsExecutor = (JSExecutor)stateInfo.getAttribute(JS_EXECUTOR);
        if (jsExecutor == null) {
            jsExecutor = new JSExecutor(Display.getCurrent());
            LifeCycleFactory.getLifeCycle().addPhaseListener(jsExecutor);
            stateInfo.setAttribute(JS_EXECUTOR, jsExecutor);
        }
        jsExecutor.append(code);
    }

    private static void checkWidget() {
        if (Display.getCurrent().getThread() != Thread.currentThread()) {
            SWT.error(22);
        }
    }

    private ExternalBrowser() {
    }

    private static final class JSExecutor
    implements PhaseListener {
        private static final long serialVersionUID = 1L;
        private final Display display;
        private String code;

        private JSExecutor(Display display) {
            this.display = display;
            this.code = "";
        }

        private void append(String command) {
            this.code = String.valueOf(this.code) + command;
        }

        public void beforePhase(PhaseEvent event) {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void afterPhase(PhaseEvent event) {
            if (this.display != RWTLifeCycle.getSessionDisplay()) return;
            IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
            HtmlResponseWriter writer = stateInfo.getResponseWriter();
            try {
                try {
                    writer.write(this.code, 0, this.code.length());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                LifeCycleFactory.getLifeCycle().removePhaseListener(this);
                throw throwable;
            }
            {
                Object var5_7 = null;
                LifeCycleFactory.getLifeCycle().removePhaseListener(this);
                return;
            }
        }

        public PhaseId getPhaseId() {
            return PhaseId.RENDER;
        }
    }
}

