/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import org.eclipse.swt.custom.ScrolledCompositeLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class ScrolledComposite
extends Composite {
    private final ControlAdapter contentListener;
    private ScrollBar horizontalBar;
    private ScrollBar verticalBar;
    Control content;
    int minHeight = 0;
    int minWidth = 0;
    boolean expandHorizontal;
    boolean expandVertical;
    boolean alwaysShowScroll;

    public ScrolledComposite(Composite parent, int style) {
        super(parent, ScrolledComposite.checkStyle(style));
        super.setLayout(new ScrolledCompositeLayout());
        this.createScrollBars(style);
        this.registerScrollListeners();
        this.contentListener = new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ScrolledComposite.this.layout();
            }
        };
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public Rectangle getClientArea() {
        ScrollBar vBar;
        this.checkWidget();
        Rectangle result = this.getBounds();
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null && hBar.getVisible()) {
            result.height -= hBar.getSize().y;
        }
        if ((vBar = this.getVerticalBar()) != null && vBar.getVisible()) {
            result.width -= vBar.getSize().x;
        }
        return result;
    }

    public void setOrigin(Point origin) {
        this.setOrigin(origin.x, origin.y);
    }

    public void setOrigin(int left, int top) {
        this.checkWidget();
        if (this.content != null) {
            int x = left;
            int y = top;
            ScrollBar hBar = this.getHorizontalBar();
            if (hBar != null) {
                hBar.setSelection(x);
                x = -hBar.getSelection();
            } else {
                x = 0;
            }
            ScrollBar vBar = this.getVerticalBar();
            if (vBar != null) {
                vBar.setSelection(y);
                y = -vBar.getSelection();
            } else {
                y = 0;
            }
            this.content.setLocation(x, y);
        }
    }

    public Point getOrigin() {
        Point result;
        this.checkWidget();
        if (this.content == null) {
            result = new Point(0, 0);
        } else {
            Point location = this.content.getLocation();
            result = new Point(-location.x, -location.y);
        }
        return result;
    }

    public void setAlwaysShowScrollBars(boolean show) {
        this.checkWidget();
        if (!show != !this.alwaysShowScroll) {
            ScrollBar vBar;
            this.alwaysShowScroll = show;
            ScrollBar hBar = this.getHorizontalBar();
            if (hBar != null && this.alwaysShowScroll) {
                hBar.setVisible(true);
            }
            if ((vBar = this.getVerticalBar()) != null && this.alwaysShowScroll) {
                vBar.setVisible(true);
            }
            this.layout();
        }
    }

    public boolean getAlwaysShowScrollBars() {
        return this.alwaysShowScroll;
    }

    public boolean getExpandHorizontal() {
        this.checkWidget();
        return this.expandHorizontal;
    }

    public boolean getExpandVertical() {
        this.checkWidget();
        return this.expandVertical;
    }

    public void setExpandHorizontal(boolean expand) {
        this.checkWidget();
        if (expand != this.expandHorizontal) {
            this.expandHorizontal = expand;
            this.layout();
        }
    }

    public void setExpandVertical(boolean expand) {
        this.checkWidget();
        if (expand != this.expandVertical) {
            this.expandVertical = expand;
            this.layout();
        }
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    public void setMinWidth(int width) {
        this.setMinSize(width, this.minHeight);
    }

    public int getMinWidth() {
        this.checkWidget();
        return this.minWidth;
    }

    public void setMinHeight(int height) {
        this.setMinSize(this.minWidth, height);
    }

    public int getMinHeight() {
        this.checkWidget();
        return this.minHeight;
    }

    public void setMinSize(Point size) {
        if (size == null) {
            this.setMinSize(0, 0);
        } else {
            this.setMinSize(size.x, size.y);
        }
    }

    public void setMinSize(int width, int height) {
        this.checkWidget();
        if (width != this.minWidth || height != this.minHeight) {
            this.minWidth = Math.max(0, width);
            this.minHeight = Math.max(0, height);
            this.layout();
        }
    }

    public void setContent(Control content) {
        this.checkWidget();
        if (this.content != null && !this.content.isDisposed()) {
            this.content.removeControlListener(this.contentListener);
            this.content.setBounds(new Rectangle(-200, -200, 0, 0));
        }
        this.content = content;
        ScrollBar vBar = this.getVerticalBar();
        ScrollBar hBar = this.getHorizontalBar();
        if (this.content != null) {
            if (vBar != null) {
                vBar.setMaximum(0);
                vBar.setThumb(0);
                vBar.setSelection(0);
            }
            if (hBar != null) {
                hBar.setMaximum(0);
                hBar.setThumb(0);
                hBar.setSelection(0);
            }
            content.setLocation(0, 0);
            this.layout();
            this.content.addControlListener(this.contentListener);
        } else {
            if (hBar != null) {
                hBar.setVisible(this.alwaysShowScroll);
            }
            if (vBar != null) {
                vBar.setVisible(this.alwaysShowScroll);
            }
        }
    }

    public Control getContent() {
        return this.content;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            if (this.content != null && !this.content.isDisposed()) {
                this.content.removeControlListener(this.contentListener);
            }
            super.dispose();
        }
    }

    boolean needHScroll(Rectangle contentRect, boolean vVisible) {
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return false;
        }
        Rectangle hostRect = this.getBounds();
        int border = this.getBorderWidth();
        hostRect.width -= 2 * border;
        ScrollBar vBar = this.getVerticalBar();
        if (vVisible && vBar != null) {
            hostRect.width -= vBar.getSize().x;
        }
        if (!this.expandHorizontal && contentRect.width > hostRect.width) {
            return true;
        }
        return this.expandHorizontal && this.minWidth > hostRect.width;
    }

    boolean needVScroll(Rectangle contentRect, boolean hVisible) {
        ScrollBar vBar = this.getVerticalBar();
        if (vBar == null) {
            return false;
        }
        Rectangle hostRect = this.getBounds();
        int border = this.getBorderWidth();
        hostRect.height -= 2 * border;
        ScrollBar hBar = this.getHorizontalBar();
        if (hVisible && hBar != null) {
            hostRect.height -= hBar.getSize().y;
        }
        if (!this.expandVertical && contentRect.height > hostRect.height) {
            return true;
        }
        return this.expandVertical && this.minHeight > hostRect.height;
    }

    void hScroll() {
        if (this.content == null) {
            return;
        }
        Point location = this.content.getLocation();
        ScrollBar hBar = this.getHorizontalBar();
        int hSelection = hBar.getSelection();
        this.content.setLocation(-hSelection, location.y);
    }

    void vScroll() {
        if (this.content == null) {
            return;
        }
        Point location = this.content.getLocation();
        ScrollBar vBar = this.getVerticalBar();
        int vSelection = vBar.getSelection();
        this.content.setLocation(location.x, -vSelection);
    }

    private void createScrollBars(int style) {
        if ((style & 0x100) != 0) {
            this.horizontalBar = new ScrollBar(this, 256);
        }
        if ((style & 0x200) != 0) {
            this.verticalBar = new ScrollBar(this, 512);
        }
    }

    private void registerScrollListeners() {
        ScrollBar vBar;
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setVisible(false);
            hBar.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ScrolledComposite.this.hScroll();
                }
            });
        }
        if ((vBar = this.getVerticalBar()) != null) {
            vBar.setVisible(false);
            vBar.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ScrolledComposite.this.vScroll();
                }
            });
        }
    }

    private static int checkStyle(int style) {
        int mask = 0x2000B00;
        return style & mask;
    }
}

