/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.DefaultTextSizeStorage;
import org.eclipse.swt.internal.graphics.ITextSizeStorage;
import org.eclipse.swt.internal.graphics.TextSizeDeterminationFacade;
import org.eclipse.swt.internal.graphics.TextSizeStorageRegistry;
import org.eclipse.swt.widgets.Display;

final class TextSizeProbeStore
extends SessionSingletonBase {
    static String DEFAULT_PROBE;
    private static final String PROBE_REQUESTS;
    private static Map probes;
    private Map probeResults = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        StringBuffer result = new StringBuffer();
        int i = 33;
        while (i < 122) {
            if (i != 34 && i != 39) {
                result.append((char)i);
            }
            ++i;
        }
        DEFAULT_PROBE = result.toString();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.graphics.TextSizeProbeStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PROBE_REQUESTS = String.valueOf(clazz.getName()) + ".ProbeRequests";
        probes = new HashMap();
    }

    private TextSizeProbeStore() {
    }

    static TextSizeProbeStore getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.graphics.TextSizeProbeStore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TextSizeProbeStore)TextSizeProbeStore.getInstance(clazz);
    }

    IProbeResult getProbeResult(Font font) {
        FontData fontData = font.getFontData()[0];
        return (IProbeResult)this.probeResults.get(fontData);
    }

    boolean containsProbeResult(Font font) {
        return this.getProbeResult(font) != null;
    }

    IProbeResult createProbeResult(final IProbe probe, final Point size) {
        FontData fontData = probe.getFont().getFontData()[0];
        IProbeResult result = new IProbeResult(){
            private float avgCharWidth;

            public IProbe getProbe() {
                return probe;
            }

            public Point getSize() {
                return size;
            }

            public float getAvgCharWidth() {
                if (this.avgCharWidth == 0.0f) {
                    BigDecimal width = new BigDecimal((double)this.getSize().x);
                    BigDecimal charCount = new BigDecimal((double)this.getProbe().getString().length());
                    int roundingMethod = 4;
                    this.avgCharWidth = width.divide(charCount, 2, roundingMethod).floatValue();
                }
                return this.avgCharWidth;
            }
        };
        this.probeResults.put(fontData, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IProbe[] getProbeList() {
        IProbe[] result;
        Map map = probes;
        synchronized (map) {
            if (probes.isEmpty()) {
                Font[] fontList = TextSizeStorageRegistry.obtain().getFontList();
                int i = 0;
                while (i < fontList.length) {
                    TextSizeProbeStore.createProbe(fontList[i], TextSizeProbeStore.getProbeString(fontList[i]));
                    ++i;
                }
            }
            result = new IProbe[probes.size()];
            probes.values().toArray(result);
        }
        return result;
    }

    private static String getProbeString(Font font) {
        return DEFAULT_PROBE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IProbe getProbe(Font font) {
        IProbe result;
        FontData fontData = font.getFontData()[0];
        Map map = probes;
        synchronized (map) {
            result = (IProbe)probes.get(fontData);
        }
        return result;
    }

    static boolean containsProbe(Font font) {
        return TextSizeProbeStore.getProbe(font) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IProbe createProbe(Font font, String probeText) {
        ProbeImpl result = new ProbeImpl(probeText, font);
        FontData fontData = font.getFontData()[0];
        Map map = probes;
        synchronized (map) {
            probes.put(fontData, result);
        }
        TextSizeStorageRegistry.obtain().storeFont(font);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Map map = probes;
        synchronized (map) {
            ITextSizeStorage registry = TextSizeStorageRegistry.obtain();
            if (registry instanceof DefaultTextSizeStorage) {
                ((DefaultTextSizeStorage)registry).resetFontList();
            }
            probes.clear();
        }
    }

    static void addProbeRequest(Font font) {
        IProbe probe = TextSizeProbeStore.getProbe(font);
        if (probe == null) {
            probe = TextSizeProbeStore.createProbe(font, TextSizeProbeStore.getProbeString(font));
        }
        TextSizeProbeStore.getProbeRequestsInternal().add(probe);
    }

    static IProbe[] getProbeRequests() {
        Set probeRequests = TextSizeProbeStore.getProbeRequestsInternal();
        IProbe[] result = new IProbe[probeRequests.size()];
        probeRequests.toArray(result);
        return result;
    }

    private static String createProbeParam(IProbe probe) {
        StringBuffer result = new StringBuffer();
        Display display = Display.getCurrent();
        if (display != null) {
            result.append("[ ");
            result.append(probe.getFont().hashCode());
            result.append(", ");
            result.append("\"");
            result.append(probe.getString());
            result.append("\", ");
            result.append(TextSizeDeterminationFacade.createFontParam(probe.getFont()));
            result.append(" ]");
        }
        return result.toString();
    }

    private static Set getProbeRequestsInternal() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HashSet result = (HashSet)stateInfo.getAttribute(PROBE_REQUESTS);
        if (result == null) {
            result = new HashSet();
            stateInfo.setAttribute(PROBE_REQUESTS, result);
        }
        return result;
    }

    public static interface IProbe {
        public Font getFont();

        public String getString();

        public String getJSProbeParam();
    }

    public static interface IProbeResult {
        public IProbe getProbe();

        public Point getSize();

        public float getAvgCharWidth();
    }

    private static final class ProbeImpl
    implements IProbe {
        private final String probeText;
        private final Font font;
        private String jsProbeParam;

        private ProbeImpl(String probeText, Font font) {
            this.probeText = probeText;
            this.font = font;
            this.jsProbeParam = TextSizeProbeStore.createProbeParam(this);
        }

        public Font getFont() {
            return this.font;
        }

        public String getString() {
            return this.probeText;
        }

        public String getJSProbeParam() {
            if ("".equals(this.jsProbeParam)) {
                this.jsProbeParam = TextSizeProbeStore.createProbeParam(this);
            }
            return this.jsProbeParam;
        }
    }
}

