/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;

public final class Graphics {
    public static Color getColor(RGB rgb) {
        return ResourceFactory.getColor(rgb.red, rgb.green, rgb.blue);
    }

    public static Color getColor(int red, int green, int blue) {
        return ResourceFactory.getColor(red, green, blue);
    }

    public static Font getFont(FontData data) {
        return Graphics.getFont(data.getName(), data.getHeight(), data.getStyle());
    }

    public static Font getFont(String name, int height, int style) {
        return ResourceFactory.getFont(name, height, style);
    }

    public static Image getImage(String path) {
        return ResourceFactory.findImage(path);
    }

    public static Image getImage(String path, ClassLoader imageLoader) {
        return ResourceFactory.findImage(path, imageLoader);
    }

    public static Image getImage(String path, InputStream inputStream) {
        return ResourceFactory.findImage(path, inputStream);
    }

    public static Cursor getCursor(int style) {
        return ResourceFactory.getCursor(style);
    }

    public static Point textExtent(Font font, String string, int wrapWidth) {
        if (string == null) {
            SWT.error(4);
        }
        return TextSizeDetermination.textExtent(font, string, wrapWidth);
    }

    public static Point stringExtent(Font font, String string) {
        if (string == null) {
            SWT.error(4);
        }
        return TextSizeDetermination.stringExtent(font, string);
    }

    public static int getCharHeight(Font font) {
        if (font == null) {
            SWT.error(4);
        }
        return TextSizeDetermination.getCharHeight(font);
    }

    public static float getAvgCharWidth(Font font) {
        if (font == null) {
            SWT.error(4);
        }
        return TextSizeDetermination.getAvgCharWidth(font);
    }

    private Graphics() {
    }
}

