/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.rwt.internal.IConfiguration;
import org.eclipse.rwt.internal.IEngineConfig;
import org.eclipse.rwt.internal.IFileUpload;
import org.eclipse.rwt.internal.IInitialization;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigurationReader {
    private static final String W4_TOOLKIT_SCHEMA = "w4t.xsd";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static Document document = null;
    private static IConfiguration configuration = null;
    private static final Map values = new HashMap();
    private static File configurationFile = null;
    private static IEngineConfig engineConfig = null;
    static /* synthetic */ Class class$0;

    public static IConfiguration getConfiguration() {
        if (configuration == null) {
            configuration = new ConfigurationImpl();
        }
        return configuration;
    }

    public static void setConfigurationFile(File configurationFile) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        ConfigurationReader.reset();
        if (configurationFile != null) {
            if (!configurationFile.exists()) {
                String msg = "Parameter 'configurationFile [" + configurationFile.toString() + "]' does not exist.";
                throw new IllegalArgumentException(msg);
            }
            if (configurationFile.isDirectory()) {
                String msg = "Parameter 'configurationFile' must not be a directory.";
                throw new IllegalArgumentException(msg);
            }
            ConfigurationReader.configurationFile = configurationFile;
        }
        if (configurationFile != null) {
            ConfigurationReader.parseConfiguration();
        }
    }

    public static IEngineConfig getEngineConfig() {
        return engineConfig;
    }

    public static void setEngineConfig(IEngineConfig engineConfig) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        ConfigurationReader.engineConfig = engineConfig;
        ConfigurationReader.setConfigurationFile(engineConfig.getConfigFile());
    }

    private static void reset() {
        values.clear();
        document = null;
        configuration = null;
        configurationFile = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void parseConfiguration() throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        if (configurationFile == null) return;
        FileInputStream is = new FileInputStream(configurationFile);
        try {
            ClassLoader loader;
            URL schema;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.rwt.internal.ConfigurationReader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            factory.setValidating((schema = (loader = clazz.getClassLoader()).getResource(W4_TOOLKIT_SCHEMA)) != null);
            try {
                factory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                factory.setNamespaceAware(false);
                factory.setValidating(false);
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) throws IOException, SAXException {
                    InputSource result = null;
                    if (schema != null && systemID.endsWith(ConfigurationReader.W4_TOOLKIT_SCHEMA)) {
                        URLConnection connection = schema.openConnection();
                        connection.setUseCaches(false);
                        result = new InputSource(connection.getInputStream());
                    }
                    return result;
                }
            });
            builder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException spe) throws SAXException {
                    System.out.println("Error parsing W4 Toolkit configuration:");
                    System.out.println(configurationFile.toString());
                    System.out.println(spe.getMessage());
                }

                public void fatalError(SAXParseException spe) throws SAXException {
                    String msg = "Fatal error parsing W4 Toolkit configuration:";
                    System.out.println(msg);
                    System.out.println(configurationFile.toString());
                    System.out.println(spe.getMessage());
                }

                public void warning(SAXParseException spe) throws SAXException {
                    System.out.println("Warning parsing W4 Toolkit configuration:");
                    System.out.println(configurationFile.toString());
                    System.out.println(spe.getMessage());
                }
            });
            document = builder.parse(is);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ((InputStream)is).close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        ((InputStream)is).close();
    }

    private static String getConfigValue(String tagName, String defaultValue) {
        if (!values.containsKey(tagName)) {
            String result = "";
            if (System.getProperty(tagName) != null) {
                result = System.getProperty(tagName);
            } else if (document != null) {
                NodeList nodeList = document.getElementsByTagName(tagName);
                Node item = nodeList.item(0);
                if (item != null) {
                    Node firstChild = item.getFirstChild();
                    if (firstChild != null) {
                        String nodeValue = firstChild.getNodeValue();
                        result = nodeValue.trim();
                    }
                } else {
                    result = defaultValue;
                }
            } else {
                result = defaultValue;
            }
            values.put(tagName, result);
        }
        return (String)values.get(tagName);
    }

    private static final class ConfigurationImpl
    implements IConfiguration {
        private IInitialization initialization = null;
        private IFileUpload fileUpload = null;

        private ConfigurationImpl() {
        }

        public IInitialization getInitialization() {
            if (this.initialization == null) {
                this.initialization = new InitializationImpl();
            }
            return this.initialization;
        }

        public IFileUpload getFileUpload() {
            if (this.fileUpload == null) {
                this.fileUpload = new FileUploadImpl();
            }
            return this.fileUpload;
        }
    }

    private static final class FileUploadImpl
    implements IFileUpload {
        private FileUploadImpl() {
        }

        public long getMaxUploadSize() {
            String value = ConfigurationReader.getConfigValue("maxUploadSize", "4194304");
            return Long.parseLong(value);
        }

        public int getMaxMemorySize() {
            String value = ConfigurationReader.getConfigValue("maxMemorySize", "524288");
            return Integer.parseInt(value);
        }
    }

    private static final class InitializationImpl
    implements IInitialization {
        private InitializationImpl() {
        }

        public String getStartUpForm() {
            return ConfigurationReader.getConfigValue("startUpForm", "com.w4t.administration.Startup");
        }

        public String getLifeCycle() {
            String defaultValue = "com.w4t.engine.lifecycle.standard.LifeCycle_Standard";
            return ConfigurationReader.getConfigValue("lifecycle", defaultValue);
        }

        public String getErrorPage() {
            String defaultValue = "com.w4t.administration.DefaultErrorForm";
            return ConfigurationReader.getConfigValue("errorPage", defaultValue);
        }

        public String getAdministrationStartupForm() {
            String defaultValue = "com.w4t.administration.Startup";
            return ConfigurationReader.getConfigValue("administrationStartupForm", defaultValue);
        }

        public String getMessagePage() {
            String defaultValue = "com.w4t.administration.DefaultMessageForm";
            return ConfigurationReader.getConfigValue("messagePage", defaultValue);
        }

        public String getWorkDirectory() {
            return ConfigurationReader.getConfigValue("workDirectory", "WEB-INF/classes/");
        }

        public long getClosingTimeout() {
            String value = ConfigurationReader.getConfigValue("closingTimeout", "3600000");
            long result = Long.parseLong(value);
            return result < 60000L ? 60000L : result;
        }

        public long getSkimmerFrequenzy() {
            String value = ConfigurationReader.getConfigValue("skimmerFrequency", "60000");
            return Long.parseLong(value);
        }

        public boolean isDirectMonitoringAccess() {
            String value = ConfigurationReader.getConfigValue("directMonitoringAccess", "true");
            return Boolean.valueOf(value);
        }

        public boolean isCompression() {
            String value = ConfigurationReader.getConfigValue("compression", "true");
            return Boolean.valueOf(value);
        }

        public boolean isProcessTime() {
            String value = ConfigurationReader.getConfigValue("processTime", "false");
            return Boolean.valueOf(value);
        }

        public String getNoscriptSubmitters() {
            String defaultValue = "Create";
            return ConfigurationReader.getConfigValue("noscriptSubmitters", defaultValue);
        }

        public String getResources() {
            String defaultValue = "deliverFromDisk";
            return ConfigurationReader.getConfigValue("resources", defaultValue);
        }

        public long getMaxSessionUnboundToForceGC() {
            String tagName = "maxSessionUnboundToForceGC";
            String value = ConfigurationReader.getConfigValue(tagName, "0");
            return Long.parseLong(value);
        }

        public String getHandleMissingI18NResource() {
            String defaultValue = "Empty";
            return ConfigurationReader.getConfigValue("handleMissingI18NResource", defaultValue);
        }
    }
}

