/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.browser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.rwt.internal.browser.DetectorBase;
import org.eclipse.rwt.internal.resources.ResourceManagerImpl;
import org.eclipse.rwt.resources.IResourceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BrowserDetector {
    private static final String BROWSERDETECTION_XML = "browserdetection.xml";
    private static final String CLASSNAME_ELEMENT = "classname";
    private static final String BROWSER_ELEMENT = "browser";
    private static BrowserDetector _instance;
    private final List browserDetectors = new ArrayList();
    static /* synthetic */ Class class$0;

    private BrowserDetector() {
        this.loadBrowserDetectors();
    }

    public static synchronized BrowserDetector getInstance() {
        if (_instance == null) {
            _instance = new BrowserDetector();
        }
        return _instance;
    }

    public String getBrowserClassName(String userAgent) {
        return this.detectBrowser(userAgent);
    }

    public String getBrowserOSName(String userAgent) {
        return DetectorBase.getBrowserOS(userAgent);
    }

    private String detectBrowser(String theUserAgent) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.browser.Default");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String result = clazz.getName();
        if (theUserAgent != null) {
            String userAgent = theUserAgent.toLowerCase();
            Object[] detectors = this.browserDetectors.toArray();
            boolean detected = false;
            int i = 0;
            while (!detected && i < detectors.length) {
                DetectorBase browserDetector = (DetectorBase)detectors[i];
                if (browserDetector.knowsBrowserString(userAgent)) {
                    result = browserDetector.getBrowserClassName(userAgent);
                    detected = true;
                }
                ++i;
            }
        }
        return result;
    }

    private void loadBrowserDetectors() {
        try {
            Enumeration<URL> browserDetectionFiles;
            IResourceManager manager = ResourceManagerImpl.getInstance();
            if (manager == null) {
                ClassLoader loader = this.getClass().getClassLoader();
                browserDetectionFiles = loader.getResources(BROWSERDETECTION_XML);
            } else {
                browserDetectionFiles = manager.getResources(BROWSERDETECTION_XML);
            }
            while (browserDetectionFiles.hasMoreElements()) {
                int nextItem = 0;
                URL browserFile = browserDetectionFiles.nextElement();
                Document document = BrowserDetector.parseDocument(browserFile);
                NodeList nodeList = document.getElementsByTagName(BROWSER_ELEMENT);
                Node item = nodeList.item(nextItem);
                while (item != null) {
                    String detectorClassName = BrowserDetector.findElementValue(item, CLASSNAME_ELEMENT);
                    Object detectorInstance = Class.forName(detectorClassName).newInstance();
                    DetectorBase browserDetector = (DetectorBase)detectorInstance;
                    this.browserDetectors.add(browserDetector);
                    item = nodeList.item(++nextItem);
                }
            }
        }
        catch (Throwable thr) {
            StringBuffer msg = new StringBuffer();
            msg.append(new Date());
            msg.append(" BROWSERDETECTOR error: ");
            msg.append("Unable to load browserdetection classes (caused by ");
            msg.append(thr.getClass().getName());
            msg.append(" with message: ");
            msg.append(thr.getMessage());
            msg.append(").");
            System.out.println(msg);
            thr.printStackTrace();
        }
    }

    private static String findElementValue(Node rootNode, String elementName) {
        Element rootElement;
        NodeList foundElements;
        Node firstNode;
        String result = null;
        if (rootNode instanceof Element && (firstNode = (foundElements = (rootElement = (Element)rootNode).getElementsByTagName(elementName)).item(0)) != null && firstNode instanceof Element) {
            Element foundElement = (Element)firstNode;
            result = foundElement.getFirstChild().getNodeValue().trim();
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document parseDocument(URL browserFile) throws IOException, ParserConfigurationException, SAXException {
        Document result;
        URLConnection con = browserFile.openConnection();
        con.setUseCaches(false);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputStream is = con.getInputStream();
        try {
            result = builder.parse(is);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            is.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        is.close();
        return result;
    }
}

