/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CommonPatterns {
    public static final Pattern NEWLINE_PATTERN = Pattern.compile("\\r\\n|\\r|\\n");
    private static final String NEWLINE_REPLACEMENT = "\\\\n";
    private static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile("(\"|\\\\)");
    private static final String DOUBLE_QUOTE_REPLACEMENT = "\\\\$1";
    private static final String LEADING_TRAILING_SPACES_REPLACEMENT = "&nbsp;";

    private CommonPatterns() {
    }

    public static String escapeDoubleQuoted(String input) {
        Matcher matcher = DOUBLE_QUOTE_PATTERN.matcher(input);
        return matcher.replaceAll(DOUBLE_QUOTE_REPLACEMENT);
    }

    public static String escapeLeadingTrailingSpaces(String input) {
        StringBuffer buffer = new StringBuffer();
        int beginIndex = 0;
        int endIndex = input.length();
        while (beginIndex < input.length() && input.charAt(beginIndex) == ' ') {
            ++beginIndex;
            buffer.append(LEADING_TRAILING_SPACES_REPLACEMENT);
        }
        while (endIndex > beginIndex && input.charAt(endIndex - 1) == ' ') {
            --endIndex;
        }
        buffer.append(input.substring(beginIndex, endIndex));
        int endCount = input.length() - endIndex;
        int i = 0;
        while (i < endCount) {
            buffer.append(LEADING_TRAILING_SPACES_REPLACEMENT);
            ++i;
        }
        return buffer.toString();
    }

    public static String replaceNewLines(String input) {
        return CommonPatterns.replaceNewLines(input, NEWLINE_REPLACEMENT);
    }

    public static String replaceNewLines(String input, String replacement) {
        return NEWLINE_PATTERN.matcher(input).replaceAll(replacement);
    }
}

