/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.ConfigurationReader;
import org.eclipse.rwt.internal.IConfiguration;
import org.eclipse.rwt.internal.IInitialization;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceAdapter;
import org.eclipse.rwt.service.IServiceHandler;

public abstract class AbstractServiceHandler
implements IServiceHandler {
    private static final int TIMEOUT = 600000;
    private static final String EXPIRATION_TIME_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final String EXPIRES = "Expires";
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String ENCODING_GZIP = "gzip";
    static /* synthetic */ Class class$0;

    IServiceAdapter getServiceAdapter(Adaptable model) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.IServiceAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IServiceAdapter)model.getAdapter(clazz);
    }

    static boolean isAcceptEncoding() {
        String encodings = AbstractServiceHandler.getRequest().getHeader(ACCEPT_ENCODING);
        return encodings != null && encodings.indexOf(ENCODING_GZIP) != -1;
    }

    static PrintWriter getOutputWriter() throws IOException {
        PrintWriter result;
        if (AbstractServiceHandler.isAcceptEncoding() && AbstractServiceHandler.getInitProps().isCompression()) {
            ServletOutputStream out = AbstractServiceHandler.getResponse().getOutputStream();
            GZIPOutputStream zipStream = new GZIPOutputStream((OutputStream)out);
            OutputStreamWriter utf8Writer = new OutputStreamWriter((OutputStream)zipStream, "UTF-8");
            result = new PrintWriter((Writer)utf8Writer, false);
            AbstractServiceHandler.getResponse().setHeader(CONTENT_ENCODING, ENCODING_GZIP);
        } else {
            result = AbstractServiceHandler.getResponse().getWriter();
        }
        return result;
    }

    protected void setExpirationHeader() {
        FORMATTER.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = new Date(System.currentTimeMillis() + 600000L);
        String expirationTime = FORMATTER.format(date);
        AbstractServiceHandler.getResponse().setHeader(EXPIRES, expirationTime);
    }

    static IInitialization getInitProps() {
        IConfiguration configuration = ConfigurationReader.getConfiguration();
        return configuration.getInitialization();
    }

    protected static HttpServletRequest getRequest() {
        return ContextProvider.getRequest();
    }

    protected static HttpServletResponse getResponse() {
        return ContextProvider.getResponse();
    }
}

