/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.browser.Browser;
import org.eclipse.rwt.internal.browser.BrowserLoader;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.LifeCycleFactory;
import org.eclipse.rwt.internal.resources.ResourceManagerImpl;
import org.eclipse.rwt.internal.service.AbstractServiceHandler;
import org.eclipse.rwt.internal.service.BrowserSurvey;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.RequestParameterBuffer;
import org.eclipse.rwt.internal.service.ServiceStateInfo;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.internal.service.TemplateHolder;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.rwt.service.ISessionStore;

public class LifeCycleServiceHandler
extends AbstractServiceHandler {
    public static final String LOG_REQUEST_PARAMS;
    public static final String LOG_REQUEST_HEADER;
    public static final String LOG_RESPONSE_CONTENT;
    private static final Level LOG_LEVEL;
    private static Logger requestParamsLogger;
    private static Logger requestHeaderLogger;
    private static Logger responseContentLogger;
    private static final DefaultLifeCycleServiceHandlerSync syncHandler;
    public static ILifeCycleRunner lifeCycleRunner;
    public static ILifeCycleServiceHandlerConfigurer configurer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.LifeCycleServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG_REQUEST_PARAMS = String.valueOf(clazz.getName()) + ".requestParams";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rwt.internal.service.LifeCycleServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG_REQUEST_HEADER = String.valueOf(clazz2.getName()) + ".requestHeaders";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.rwt.internal.service.LifeCycleServiceHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG_RESPONSE_CONTENT = String.valueOf(clazz3.getName()) + ".responseContent";
        LOG_LEVEL = Level.FINE;
        requestParamsLogger = Logger.getLogger(LOG_REQUEST_PARAMS);
        requestHeaderLogger = Logger.getLogger(LOG_REQUEST_HEADER);
        responseContentLogger = Logger.getLogger(LOG_RESPONSE_CONTENT);
        syncHandler = new DefaultLifeCycleServiceHandlerSync();
        lifeCycleRunner = new ILifeCycleRunner(){

            public void init() {
            }

            public void run() throws ServletException, IOException {
                LifeCycle lifeCycle = (LifeCycle)LifeCycleFactory.getLifeCycle();
                lifeCycle.execute();
            }
        };
        configurer = new ILifeCycleServiceHandlerConfigurer(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public TemplateHolder getTemplateOfStartupPage() throws IOException {
                TemplateHolder result;
                String resourceName = BrowserSurvey.getResourceName();
                IResourceManager manager = ResourceManagerImpl.getInstance();
                InputStream stream = manager.getResourceAsStream(resourceName);
                if (stream == null) {
                    String text = "Failed to load Browser Survey HTML Page. Resource {0} could not be found.";
                    Object[] param = new Object[]{resourceName};
                    String msg = MessageFormat.format(text, param);
                    throw new IOException(msg);
                }
                InputStreamReader isr = new InputStreamReader(stream, "ISO-8859-1");
                BufferedReader reader = new BufferedReader(isr);
                try {
                    String line = reader.readLine();
                    StringBuffer buffer = new StringBuffer();
                    while (true) {
                        block5: {
                            if (line != null) break block5;
                            result = new TemplateHolder(buffer.toString());
                            break;
                        }
                        buffer.append(line);
                        buffer.append("\n");
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    reader.close();
                    throw throwable;
                }
                {
                    Object var9_14 = null;
                }
                reader.close();
                return result;
            }

            public boolean isStartupPageModifiedSince() {
                return true;
            }

            public LifeCycleServiceHandlerSync getSynchronizationHandler() {
                return syncHandler;
            }
        };
    }

    public void service() throws IOException, ServletException {
        LifeCycleServiceHandler.logRequestHeader();
        LifeCycleServiceHandler.logRequestParams();
        configurer.getSynchronizationHandler().service();
    }

    public static boolean isSessionRestart() {
        HttpServletRequest request = LifeCycleServiceHandler.getRequest();
        boolean startup = request.getParameter("startup") != null;
        String uiRoot = request.getParameter("uiRoot");
        HttpSession session = request.getSession();
        return !session.isNew() && !startup && uiRoot == null || startup && LifeCycleServiceHandler.isBrowserDetected();
    }

    public static void initializeStateInfo() {
        if (LifeCycleServiceHandler.getStateInfo() == null) {
            ServiceStateInfo stateInfo = new ServiceStateInfo();
            ContextProvider.getContext().setStateInfo(stateInfo);
        }
        if (LifeCycleServiceHandler.getStateInfo().getResponseWriter() == null) {
            HtmlResponseWriter htmlResponseWriter = new HtmlResponseWriter();
            LifeCycleServiceHandler.getStateInfo().setResponseWriter(htmlResponseWriter);
        }
    }

    private static void internalService() throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        LifeCycleServiceHandler.initializeStateInfo();
        LifeCycleServiceHandler.checkRequest();
        LifeCycleServiceHandler.detectBrowser();
        if (LifeCycleServiceHandler.isBrowserDetected()) {
            lifeCycleRunner.init();
            RequestParameterBuffer.merge();
            lifeCycleRunner.run();
        } else {
            Map parameters = ContextProvider.getRequest().getParameterMap();
            RequestParameterBuffer.store(parameters);
            BrowserSurvey.sendBrowserSurvey();
        }
        LifeCycleServiceHandler.appendProcessTime(startTime);
        LifeCycleServiceHandler.writeOutput();
    }

    private static boolean isBrowserDetected() {
        return LifeCycleServiceHandler.getBrowser() != null;
    }

    private static Browser getBrowser() {
        String id = "com_w4t_detected_session_browser";
        return (Browser)ContextProvider.getSession().getAttribute(id);
    }

    private static void detectBrowser() {
        if (!LifeCycleServiceHandler.isBrowserDetected() && LifeCycleServiceHandler.getRequest().getParameter("w4t_scriptEnabled") != null && LifeCycleServiceHandler.getRequest().getParameter("w4t_ajaxEnabled") != null) {
            Browser browser = BrowserLoader.load();
            String id = "com_w4t_detected_session_browser";
            ContextProvider.getSession().setAttribute(id, browser);
        }
        if (LifeCycleServiceHandler.isBrowserDetected()) {
            ContextProvider.getStateInfo().setDetectedBrowser(LifeCycleServiceHandler.getBrowser());
        }
    }

    private static void checkRequest() {
        HttpSession session = LifeCycleServiceHandler.getRequest().getSession();
        if (LifeCycleServiceHandler.isSessionRestart()) {
            LifeCycleServiceHandler.clearSession(session);
        }
    }

    private static void clearSession(HttpSession session) {
        Enumeration keys = session.getAttributeNames();
        ArrayList keyBuffer = new ArrayList();
        while (keys.hasMoreElements()) {
            keyBuffer.add(keys.nextElement());
        }
        Object[] attributeNames = keyBuffer.toArray();
        int i = 0;
        while (i < attributeNames.length) {
            String idSessionStore = SessionStoreImpl.ID_SESSION_STORE;
            if (!idSessionStore.equals(attributeNames[i])) {
                session.removeAttribute((String)attributeNames[i]);
            } else {
                SessionStoreImpl sessionStore = (SessionStoreImpl)session.getAttribute(idSessionStore);
                sessionStore.valueUnbound(null);
                sessionStore.valueBound(null);
                sessionStore.setAttribute(SessionSingletonBase.LOCK, new Object());
            }
            ++i;
        }
    }

    private static void appendProcessTime(long startTime) {
        if (LifeCycleServiceHandler.getInitProps().isProcessTime()) {
            long finish = System.currentTimeMillis();
            HtmlResponseWriter content = LifeCycleServiceHandler.getStateInfo().getResponseWriter();
            content.appendFoot(LifeCycleServiceHandler.getProcessTime(startTime, finish));
        }
    }

    private static StringBuffer getProcessTime(long start, long finish) {
        long processTime = finish - start;
        StringBuffer result = new StringBuffer();
        result.append("\nTime to process: ");
        result.append(processTime);
        result.append(" ms");
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeOutput() throws IOException {
        if (!ContextProvider.getContext().isDisposed()) {
            HtmlResponseWriter content = LifeCycleServiceHandler.getStateInfo().getResponseWriter();
            PrintWriter out = LifeCycleServiceHandler.getOutputWriter();
            try {
                int i = 0;
                while (true) {
                    if (i >= content.getHeadSize()) break;
                    out.print(content.getHeadToken(i));
                    ++i;
                }
                i = 0;
                while (true) {
                    if (i >= content.getBodySize()) {
                        i = 0;
                        break;
                    }
                    out.print(content.getBodyToken(i));
                    ++i;
                }
                while (i < content.getFootSize()) {
                    out.print(content.getFootToken(i));
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                out.close();
                throw throwable;
            }
            {
                Object var3_5 = null;
                out.close();
            }
            LifeCycleServiceHandler.logResponseContent();
        }
    }

    private static IServiceStateInfo getStateInfo() {
        return ContextProvider.getStateInfo();
    }

    private static void logRequestHeader() {
        if (requestHeaderLogger.isLoggable(LOG_LEVEL)) {
            HttpServletRequest request = ContextProvider.getRequest();
            Enumeration headerNames = request.getHeaderNames();
            StringBuffer msg = new StringBuffer();
            msg.append("Request header:\n");
            msg.append("(method):");
            msg.append(request.getMethod());
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                msg.append(headerName);
                msg.append(": ");
                msg.append(request.getHeader(headerName));
            }
            requestHeaderLogger.log(LOG_LEVEL, msg.toString());
        }
    }

    private static void logRequestParams() {
        if (requestParamsLogger.isLoggable(LOG_LEVEL)) {
            StringBuffer msg = new StringBuffer();
            msg.append("Request parameters:\n");
            HttpServletRequest request = ContextProvider.getRequest();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                String parameterValue = request.getParameter(parameterName);
                msg.append(parameterName);
                msg.append("=");
                msg.append(parameterValue);
                msg.append("\n");
            }
            requestParamsLogger.log(LOG_LEVEL, msg.toString());
        }
    }

    private static void logResponseContent() {
        if (responseContentLogger.isLoggable(LOG_LEVEL)) {
            HtmlResponseWriter content = LifeCycleServiceHandler.getStateInfo().getResponseWriter();
            StringBuffer msg = new StringBuffer();
            int i = 0;
            while (i < content.getHeadSize()) {
                msg.append(content.getHeadToken(i));
                ++i;
            }
            i = 0;
            while (i < content.getBodySize()) {
                msg.append(content.getBodyToken(i));
                ++i;
            }
            i = 0;
            while (i < content.getFootSize()) {
                msg.append(content.getFootToken(i));
                ++i;
            }
            responseContentLogger.log(LOG_LEVEL, msg.toString());
        }
    }

    private static final class DefaultLifeCycleServiceHandlerSync
    extends LifeCycleServiceHandlerSync {
        private DefaultLifeCycleServiceHandlerSync() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service() throws ServletException, IOException {
            ISessionStore iSessionStore = ContextProvider.getSession();
            synchronized (iSessionStore) {
                this.doService();
            }
        }
    }

    public static interface ILifeCycleRunner {
        public void init();

        public void run() throws ServletException, IOException;
    }

    public static interface ILifeCycleServiceHandlerConfigurer {
        public TemplateHolder getTemplateOfStartupPage() throws IOException;

        public boolean isStartupPageModifiedSince();

        public LifeCycleServiceHandlerSync getSynchronizationHandler();
    }

    public static abstract class LifeCycleServiceHandlerSync {
        public abstract void service() throws ServletException, IOException;

        protected final void doService() throws ServletException, IOException {
            LifeCycleServiceHandler.internalService();
        }
    }
}

