/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.regex.Pattern;

public abstract class JsonValue {
    private static final Pattern PATTERN_BS = Pattern.compile("\\\\");
    private static final String REPL_BS = "\\\\\\\\";
    private static final Pattern PATTERN_QUOTE = Pattern.compile("\"");
    private static final String REPL_QUOTE = "\\\\\\\"";
    public static final JsonValue NULL = new JsonPrimitive("null");
    public static final JsonValue TRUE = new JsonPrimitive("true");
    public static final JsonValue FALSE = new JsonPrimitive("false");

    public static JsonValue valueOf(int value) {
        return new JsonPrimitive(String.valueOf(value));
    }

    public static JsonValue valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static JsonValue valueOf(String value) {
        JsonValue result = value == null ? NULL : new JsonPrimitive(JsonValue.quoteString(value));
        return result;
    }

    public static String quoteString(String string) {
        String replaced = string;
        replaced = PATTERN_BS.matcher(replaced).replaceAll(REPL_BS);
        replaced = PATTERN_QUOTE.matcher(replaced).replaceAll(REPL_QUOTE);
        return "\"" + replaced + "\"";
    }

    private static class JsonPrimitive
    extends JsonValue {
        private final String value;

        public JsonPrimitive(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

